/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.glassfish.main.jul.handler.HandlerConfigurationHelper;
import org.glassfish.main.jul.handler.LogRecordBuffer;
import org.glassfish.main.jul.handler.LoggingPumpThread;
import org.glassfish.main.jul.handler.Syslog;
import org.glassfish.main.jul.handler.SyslogHandlerProperty;
import org.glassfish.main.jul.record.GlassFishLogRecord;
import org.glassfish.main.jul.record.MessageResolver;

public class SyslogHandler
extends Handler {
    private static final MessageResolver MSG_RESOLVER = new MessageResolver();
    private final LogRecordBuffer pendingRecords;
    private final Syslog syslog;
    private LoggingPump pump;

    public SyslogHandler() {
        HandlerConfigurationHelper helper = HandlerConfigurationHelper.forHandlerClass(this.getClass());
        if (!helper.getBoolean(SyslogHandlerProperty.ENABLED, true).booleanValue()) {
            this.syslog = null;
            this.pump = null;
            this.pendingRecords = null;
            return;
        }
        this.setLevel(helper.getLevel(SyslogHandlerProperty.LEVEL, Level.WARNING));
        this.setFormatter(helper.getFormatter(SimpleFormatter.class));
        this.setFilter(helper.getFilter());
        int bufferCapacity = helper.getInteger(SyslogHandlerProperty.BUFFER_CAPACITY, 5000);
        int bufferTimeout = helper.getInteger(SyslogHandlerProperty.BUFFER_TIMEOUT, 300);
        this.pendingRecords = new LogRecordBuffer(bufferCapacity, bufferTimeout);
        String host = helper.getString(SyslogHandlerProperty.HOST, SyslogHandler.getLocalHost());
        int port = helper.getInteger(SyslogHandlerProperty.PORT, 514);
        Charset encoding = helper.getCharset(SyslogHandlerProperty.ENCODING, StandardCharsets.UTF_8);
        this.syslog = new Syslog(host, port, encoding);
        this.pump = new LoggingPump("SyslogHandler log pump", this.pendingRecords);
        this.pump.start();
    }

    @Override
    public void publish(LogRecord record) {
        if (this.pump == null || record == null || record.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        this.pendingRecords.add(MSG_RESOLVER.resolve(record));
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void close() {
        if (this.pump != null && this.pump.isAlive()) {
            this.pump.interrupt();
            this.pump = null;
        }
    }

    private void log(GlassFishLogRecord record) {
        if (this.syslog == null) {
            return;
        }
        Syslog.SyslogLevel syslogLevel = Syslog.SyslogLevel.of(record.getLevel());
        StringBuilder sb = new StringBuilder();
        sb.append("GlassFish");
        sb.append('[').append(ProcessHandle.current().pid()).append(']');
        sb.append(": <").append(syslogLevel.name()).append('>');
        sb.append(' ').append(this.getFormatter().formatMessage(record));
        this.syslog.log(syslogLevel, sb.toString());
    }

    private static String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Could not initialize the SyslogHandler's connection.", e);
        }
    }

    private final class LoggingPump
    extends LoggingPumpThread {
        private LoggingPump(String threadName, LogRecordBuffer buffer) {
            super(threadName, buffer);
        }

        @Override
        protected boolean isShutdownRequested() {
            return SyslogHandler.this.pump == null;
        }

        @Override
        protected int getFlushFrequency() {
            return 1;
        }

        @Override
        protected boolean logRecord(GlassFishLogRecord record) {
            if (record == null) {
                return false;
            }
            SyslogHandler.this.log(record);
            return true;
        }

        @Override
        protected void flushOutput() {
            SyslogHandler.this.flush();
        }
    }
}

