/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.AttributeHolder;
import org.apache.derby.shared.common.reference.Attribute;

public class URLCheck {
    private Vector<AttributeHolder> attributes;
    private static Vector<String> booleanAttributes;
    private LocalizedResource langUtil = LocalizedResource.getInstance();
    private Vector<String> validProps;
    private static Vector<String> validDerbyProps;

    public URLCheck(String string) {
        try {
            Properties properties = this.getAttributes(string, new Properties());
            this.check();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            URLCheck uRLCheck = new URLCheck(stringArray[0]);
        }
    }

    public void check() {
        Enumeration<AttributeHolder> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            AttributeHolder attributeHolder = enumeration.nextElement();
            this.checkForDuplicate(attributeHolder);
            attributeHolder.check(this.validProps);
        }
    }

    public void checkForDuplicate(AttributeHolder attributeHolder) {
        Enumeration<AttributeHolder> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            AttributeHolder attributeHolder2 = enumeration.nextElement();
            if (attributeHolder == attributeHolder2 || !attributeHolder.getName().equals(attributeHolder2.getName())) continue;
            attributeHolder.addError(this.langUtil.getTextMessage("TL_dupAtt", new Object[0]));
        }
    }

    public Properties getAttributes(String string, Properties properties) throws Exception {
        String string2 = "";
        if (string.startsWith("jdbc:derby:net:") || string.startsWith("jdbc:derby://")) {
            this.validProps = null;
        } else if (string.startsWith("jdbc:derby:")) {
            string2 = "jdbc:derby:";
            this.validProps = this.getValidDerbyProps();
        } else {
            this.validProps = null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(string2.length()), ";:\"");
        this.attributes = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            AttributeHolder attributeHolder = new AttributeHolder();
            String string3 = "";
            String string4 = "";
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf(61);
            if (n == -1) continue;
            string3 = string5.substring(0, n).trim();
            string4 = string5.substring(n + 1).trim();
            attributeHolder.setName(string3);
            attributeHolder.setValue(string4);
            attributeHolder.setToken(string5);
            this.attributes.addElement(attributeHolder);
            properties.put(string3, string5);
        }
        return properties;
    }

    public static Vector<String> getBooleanAttributes() {
        if (booleanAttributes == null) {
            booleanAttributes = new Vector();
            booleanAttributes.addElement("dataEncryption");
            booleanAttributes.addElement("create");
            booleanAttributes.addElement("shutdown");
            booleanAttributes.addElement("upgrade");
        }
        return booleanAttributes;
    }

    private Vector<String> getValidDerbyProps() {
        if (validDerbyProps == null) {
            try {
                Vector<String> vector = new Vector<String>();
                Class<Attribute> clazz = Attribute.class;
                Field[] fieldArray = clazz.getFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    Field field = fieldArray[i];
                    vector.addElement((String)field.get(clazz));
                }
                validDerbyProps = vector;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return validDerbyProps;
    }
}

