/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.resourcebase.resources.listener.ResourceManager;
import org.glassfish.resources.listener.ApplicationScopedResourcesManager;

public class ConnectorApplication
implements ApplicationContainer<ConnectorDescriptor>,
EventListener {
    private static final Logger LOG = LogDomains.getLogger(ConnectorApplication.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private String moduleName = "";
    private final String applicationName;
    private final ResourceManager resourceManager;
    private final ClassLoader loader;
    private final ConnectorRuntime runtime;
    private final Events event;
    private final ConnectorDescriptor descriptor;
    private static StringManager localStrings = StringManager.getManager(ConnectorRuntime.class);
    private final ResourcesUtil resourcesUtil;

    public ConnectorApplication(String moduleName, String appName, ResourceManager resourceManager, ApplicationScopedResourcesManager asrManager, ClassLoader loader, ConnectorRuntime runtime, Events event, ConnectorDescriptor descriptor) {
        this.setModuleName(moduleName);
        this.resourceManager = resourceManager;
        this.loader = loader;
        this.runtime = runtime;
        this.applicationName = appName;
        this.event = event;
        this.descriptor = descriptor;
        this.resourcesUtil = ResourcesUtil.createInstance();
    }

    public ConnectorDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean start(ApplicationContext startupContext) {
        boolean started = false;
        this.deployResources();
        this.runtime.registerConnectorApplication(this);
        started = true;
        this.event.register((EventListener)this);
        LOG.log(Level.INFO, "Resource Adapter [ {0} ] started", this.getModuleName());
        return started;
    }

    public void deployResources() {
        this.deployGlobalResources();
    }

    private void deployGlobalResources() {
        Resources allResources = this.resourceManager.getAllResources();
        Collection<Resource> resources = this.resourcesUtil.filterConnectorResources(allResources, this.moduleName, false);
        this.resourceManager.deployResources(resources);
    }

    public void undeployResources() {
        this.undeployGlobalResources(false);
    }

    public boolean undeployGlobalResources(boolean failIfResourcesExist) {
        Collection<Resource> resources = this.resourcesUtil.filterConnectorResources(this.resourceManager.getAllResources(), this.moduleName, true);
        if (failIfResourcesExist && !resources.isEmpty()) {
            String message = "one or more resources of resource-adapter [ " + this.moduleName + " ] exist, use '--cascade=true' to delete them during undeploy";
            LOG.log(Level.WARNING, "resources.of.rar.exist", this.moduleName);
            throw new RuntimeException(message);
        }
        this.resourceManager.undeployResources(resources);
        return true;
    }

    public boolean stop(ApplicationContext stopContext) {
        boolean stopped = false;
        DeploymentContext dc = (DeploymentContext)stopContext;
        UndeployCommandParameters dcp = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
        boolean failIfResourcesExist = false;
        if (dcp != null && dcp.origin == OpsParams.Origin.undeploy && !dcp._ignoreCascade.booleanValue() && !dcp.cascade.booleanValue()) {
            failIfResourcesExist = true;
        }
        if (!this.undeployGlobalResources(failIfResourcesExist)) {
            stopped = false;
        } else {
            this.runtime.unregisterConnectorApplication(this.getModuleName());
            stopped = true;
            LOG.log(Level.INFO, "Resource Adapter [ {0} ] stopped", this.getModuleName());
            this.event.unregister((EventListener)this);
        }
        return stopped;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void event(EventListener.Event event) {
        if (Deployment.UNDEPLOYMENT_VALIDATION.equals((Object)event.type())) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            UndeployCommandParameters dcp = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
            if ((dcp.name.equals(this.moduleName) || dcp.name.equals(this.applicationName) && this.moduleName.contains("#") && this.moduleName.startsWith(dcp.name)) && dcp.origin != OpsParams.Origin.deploy && dcp.origin == OpsParams.Origin.undeploy && !dcp._ignoreCascade.booleanValue() && !dcp.cascade.booleanValue() && !this.resourcesUtil.filterConnectorResources(this.resourceManager.getAllResources(), this.moduleName, true).isEmpty()) {
                String message = localStrings.getString("con.deployer.resources.exist", (Object)this.moduleName);
                LOG.log(Level.WARNING, "resources.of.rar.exist", this.moduleName);
                ActionReport report = dc.getActionReport();
                report.setMessage(message);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
    }
}

