/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.wasp.JspCompilationContext;
import org.glassfish.wasp.Options;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.BeanRepository;
import org.glassfish.wasp.compiler.Collector;
import org.glassfish.wasp.compiler.ELFunctionMapper;
import org.glassfish.wasp.compiler.ErrorDispatcher;
import org.glassfish.wasp.compiler.Generator;
import org.glassfish.wasp.compiler.JavaCompiler;
import org.glassfish.wasp.compiler.JavacErrorDetail;
import org.glassfish.wasp.compiler.JspConfig;
import org.glassfish.wasp.compiler.JspProperty;
import org.glassfish.wasp.compiler.JspRuntimeContext;
import org.glassfish.wasp.compiler.JspUtil;
import org.glassfish.wasp.compiler.Jsr199JavaCompiler;
import org.glassfish.wasp.compiler.Node;
import org.glassfish.wasp.compiler.NullJavaCompiler;
import org.glassfish.wasp.compiler.PageInfo;
import org.glassfish.wasp.compiler.ParserController;
import org.glassfish.wasp.compiler.ScriptingVariabler;
import org.glassfish.wasp.compiler.ServletWriter;
import org.glassfish.wasp.compiler.SmapUtil;
import org.glassfish.wasp.compiler.TagFileProcessor;
import org.glassfish.wasp.compiler.TagPluginManager;
import org.glassfish.wasp.compiler.TextOptimizer;
import org.glassfish.wasp.compiler.Validator;
import org.glassfish.wasp.servlet.JspServletWrapper;

public class Compiler {
    private static String[] systemJars = new String[]{"jstl.jar"};
    private static String[] systemFacesJars = new String[]{"jsf-api.jar", "jsf-impl.jar"};
    protected JspCompilationContext pagesCompilationContext;
    private ErrorDispatcher errDispatcher;
    private PageInfo pageInfo;
    private JspServletWrapper pagesServletWrapper;
    private TagFileProcessor tagFileProcessor;
    private JavaCompiler javaCompiler;
    private Logger log;
    private boolean jspcMode;
    private SmapUtil smapUtil;
    private Options options;
    private Node.Nodes pageNodes;
    private long jspModTime;
    private boolean javaCompilerOptionsSet;

    public Compiler(JspCompilationContext ctxt, JspServletWrapper jsw) {
        this.pagesServletWrapper = jsw;
        this.pagesCompilationContext = ctxt;
        this.jspcMode = false;
        this.options = ctxt.getOptions();
        this.log = Logger.getLogger(Compiler.class.getName());
        this.smapUtil = new SmapUtil(ctxt);
        this.errDispatcher = new ErrorDispatcher(this.jspcMode);
        this.javaCompiler = new NullJavaCompiler();
        this.javaCompiler.init(ctxt, this.errDispatcher, this.jspcMode);
        this.javaCompilerOptionsSet = false;
    }

    public Compiler(JspCompilationContext ctxt, JspServletWrapper jsw, boolean jspcMode) throws WaspException {
        this.pagesServletWrapper = jsw;
        this.pagesCompilationContext = ctxt;
        this.jspcMode = jspcMode;
        this.options = ctxt.getOptions();
        this.log = Logger.getLogger(Compiler.class.getName());
        if (jspcMode) {
            this.log.setLevel(Level.OFF);
        }
        this.smapUtil = new SmapUtil(ctxt);
        this.errDispatcher = new ErrorDispatcher(jspcMode);
        this.initJavaCompiler();
        this.javaCompilerOptionsSet = false;
    }

    private void generateJava() throws Exception {
        long t4 = 0L;
        long t3 = 0L;
        long t2 = 0L;
        long t1 = 0L;
        if (this.log.isLoggable(Level.FINE)) {
            t1 = System.currentTimeMillis();
        }
        this.pageInfo = new PageInfo(new BeanRepository(this.pagesCompilationContext.getClassLoader(), this.errDispatcher), this.pagesCompilationContext.getJspFile());
        JspConfig jspConfig = this.options.getJspConfig();
        JspProperty jspProperty = jspConfig.findJspProperty(this.pagesCompilationContext.getJspFile());
        this.pageInfo.setELIgnored(JspUtil.booleanValue(jspProperty.isELIgnored()));
        this.pageInfo.setScriptingInvalid(JspUtil.booleanValue(jspProperty.isScriptingInvalid()));
        this.pageInfo.setTrimDirectiveWhitespaces(JspUtil.booleanValue(jspProperty.getTrimSpaces()));
        if (jspProperty.getErrorOnELNotFound() != null) {
            this.pageInfo.setErrorOnELNotFound(JspUtil.booleanValue(jspProperty.getErrorOnELNotFound()));
        }
        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(JspUtil.booleanValue(jspProperty.getPoundAllowed()));
        this.pageInfo.setErrorOnUndeclaredNamespace(JspUtil.booleanValue(jspProperty.errorOnUndeclaredNamespace()));
        if (jspProperty.getIncludePrelude() != null) {
            this.pageInfo.setIncludePrelude(jspProperty.getIncludePrelude());
        }
        if (jspProperty.getIncludeCoda() != null) {
            this.pageInfo.setIncludeCoda(jspProperty.getIncludeCoda());
        }
        if (this.options.isDefaultBufferNone() && this.pageInfo.getBufferValue() == null) {
            this.pageInfo.setBuffer(0);
        }
        String javaFileName = this.pagesCompilationContext.getServletJavaFileName();
        ServletWriter writer = null;
        try {
            Writer javaWriter = this.javaCompiler.getJavaWriter(javaFileName, this.pagesCompilationContext.getOptions().getJavaEncoding());
            writer = new ServletWriter(new PrintWriter(javaWriter));
            this.pagesCompilationContext.setWriter(writer);
            JspUtil.resetTemporaryVariableName();
            ParserController parserCtl = new ParserController(this.pagesCompilationContext, this);
            this.pageNodes = parserCtl.parse(this.pagesCompilationContext.getJspFile());
            if (this.pagesCompilationContext.isPrototypeMode()) {
                Generator.generate(writer, this, this.pageNodes);
                writer.close();
                writer = null;
                return;
            }
            Validator.validate(this, this.pageNodes);
            if (this.log.isLoggable(Level.FINE)) {
                t2 = System.currentTimeMillis();
            }
            Collector.collect(this, this.pageNodes);
            this.tagFileProcessor = new TagFileProcessor();
            this.tagFileProcessor.loadTagFiles(this, this.pageNodes);
            if (this.log.isLoggable(Level.FINE)) {
                t3 = System.currentTimeMillis();
            }
            ScriptingVariabler.set(this.pageNodes, this.errDispatcher);
            TagPluginManager tagPluginManager = this.options.getTagPluginManager();
            tagPluginManager.apply(this.pageNodes, this.errDispatcher, this.pageInfo);
            TextOptimizer.concatenate(this, this.pageNodes);
            ELFunctionMapper.map(this, this.pageNodes);
            Generator.generate(writer, this, this.pageNodes);
            writer.close();
            writer = null;
            this.pagesCompilationContext.setWriter(null);
            if (this.log.isLoggable(Level.FINE)) {
                t4 = System.currentTimeMillis();
                this.log.fine("Generated " + javaFileName + " total=" + (t4 - t1) + " generate=" + (t4 - t3) + " validate=" + (t2 - t1));
            }
        }
        catch (Exception e) {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.javaCompiler.doJavaFile(false);
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!this.options.isSmapSuppressed()) {
            this.smapUtil.generateSmap(this.pageNodes);
        }
        this.tagFileProcessor.removeProtoTypeFiles(this.pagesCompilationContext.getClassFileName());
    }

    private void setJavaCompilerOptions() {
        String path;
        StringTokenizer tokenizer;
        if (this.javaCompilerOptionsSet) {
            return;
        }
        this.javaCompilerOptionsSet = true;
        String classpath = this.pagesCompilationContext.getClassPath();
        String sep = System.getProperty("path.separator");
        ArrayList<File> cpath = new ArrayList<File>();
        HashSet<String> paths = new HashSet<String>();
        String sysClassPath = this.options.getSystemClassPath();
        if (sysClassPath != null) {
            tokenizer = new StringTokenizer(sysClassPath, sep);
            while (tokenizer.hasMoreElements()) {
                path = tokenizer.nextToken();
                if (paths.contains(path) || this.systemJarInWebinf(path)) continue;
                paths.add(path);
                cpath.add(new File(path));
            }
        }
        if (classpath != null) {
            tokenizer = new StringTokenizer(classpath, sep);
            while (tokenizer.hasMoreElements()) {
                path = tokenizer.nextToken();
                if (paths.contains(path) || this.systemJarInWebinf(path)) continue;
                paths.add(path);
                cpath.add(new File(path));
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Using classpath: " + sysClassPath + sep + classpath);
        }
        this.javaCompiler.setClassPath(cpath);
        this.javaCompiler.setDebug(this.options.getClassDebugInfo());
        String exts = System.getProperty("java.ext.dirs");
        if (exts != null) {
            this.javaCompiler.setExtdirs(exts);
        }
        if (this.options.getCompilerTargetVM() != null) {
            this.javaCompiler.setTargetVM(this.options.getCompilerTargetVM());
        }
        if (this.options.getCompilerSourceVM() != null) {
            this.javaCompiler.setSourceVM(this.options.getCompilerSourceVM());
        }
    }

    private void generateClass() throws FileNotFoundException, WaspException, Exception {
        long t1 = 0L;
        if (this.log.isLoggable(Level.FINE)) {
            t1 = System.currentTimeMillis();
        }
        String javaFileName = this.pagesCompilationContext.getServletJavaFileName();
        this.setJavaCompilerOptions();
        JavacErrorDetail[] javacErrors = this.javaCompiler.compile(this.pagesCompilationContext.getFullClassName(), this.pageNodes);
        if (javacErrors != null) {
            this.javaCompiler.doJavaFile(true);
            this.log.severe("Error compiling file: " + javaFileName);
            this.errDispatcher.javacError(javacErrors);
        }
        if (this.log.isLoggable(Level.FINE)) {
            long t2 = System.currentTimeMillis();
            this.log.fine("Compiled " + javaFileName + " " + (t2 - t1) + "ms");
        }
        this.javaCompiler.doJavaFile(this.pagesCompilationContext.keepGenerated());
        if (!this.pagesCompilationContext.isPrototypeMode() && !this.options.isSmapSuppressed()) {
            this.smapUtil.installSmap();
        }
        if (this.pagesServletWrapper != null && this.pagesServletWrapper.getServletClassLastModifiedTime() <= 0L) {
            this.pagesServletWrapper.setServletClassLastModifiedTime(this.javaCompiler.getClassLastModified());
        }
        if (this.options.getSaveBytecode()) {
            this.javaCompiler.saveClassFile(this.pagesCompilationContext.getFullClassName(), this.pagesCompilationContext.getClassFileName());
        }
        this.pagesCompilationContext.getRuntimeContext().adjustBytecodeTime(this.pagesCompilationContext.getFullClassName(), this.jspModTime);
    }

    public void compile(boolean compileClass) throws FileNotFoundException, WaspException, Exception {
        try {
            this.pagesCompilationContext.makeOutputDir(this.pagesCompilationContext.getOutputDir());
            if (this.errDispatcher == null) {
                this.errDispatcher = new ErrorDispatcher(this.jspcMode);
            }
            this.generateJava();
            if (compileClass) {
                this.generateClass();
            } else {
                this.javaCompiler.doJavaFile(this.pagesCompilationContext.keepGenerated());
            }
        }
        finally {
            if (this.tagFileProcessor != null) {
                this.tagFileProcessor.removeProtoTypeFiles(null);
            }
            this.javaCompiler.release();
            this.tagFileProcessor = null;
            this.errDispatcher = null;
            if (!this.jspcMode) {
                this.pageInfo = null;
            }
            this.pageNodes = null;
            if (this.pagesCompilationContext.getWriter() != null) {
                this.pagesCompilationContext.getWriter().close();
                this.pagesCompilationContext.setWriter(null);
            }
        }
    }

    public boolean isOutDated() {
        return this.isOutDated(true);
    }

    public boolean isOutDated(boolean checkClass) {
        File jspFile;
        String pagesFile = this.pagesCompilationContext.getJspFile();
        if (this.pagesServletWrapper != null && this.pagesCompilationContext.getOptions().getModificationTestInterval() > 0) {
            if (this.pagesServletWrapper.getLastModificationTest() + (long)(this.pagesCompilationContext.getOptions().getModificationTestInterval() * 1000) > System.currentTimeMillis()) {
                return false;
            }
            this.pagesServletWrapper.setLastModificationTest(System.currentTimeMillis());
        }
        long jspRealLastModified = 0L;
        File targetFile = checkClass ? new File(this.pagesCompilationContext.getClassFileName()) : new File(this.pagesCompilationContext.getServletJavaFileName());
        long targetLastModified = this.getLastModifiedTime(targetFile);
        if (checkClass) {
            String className;
            JspRuntimeContext runtimeContext = this.pagesCompilationContext.getRuntimeContext();
            long cachedTime = runtimeContext.getBytecodeBirthTime(className = this.pagesCompilationContext.getFullClassName());
            if (cachedTime > targetLastModified) {
                targetLastModified = cachedTime;
            } else {
                runtimeContext.setBytecode(className, null);
            }
        }
        if (targetLastModified == 0L) {
            return true;
        }
        if (this.pagesServletWrapper != null && (jspFile = this.pagesServletWrapper.getJspFile()) != null) {
            jspRealLastModified = this.getLastModifiedTime(jspFile);
        }
        if (jspRealLastModified == 0L || targetLastModified < jspRealLastModified) {
            try {
                URL jspUrl = this.pagesCompilationContext.getResource(pagesFile);
                if (jspUrl == null) {
                    this.pagesCompilationContext.incrementRemoved();
                    return false;
                }
                URLConnection uc = jspUrl.openConnection();
                jspRealLastModified = uc instanceof JarURLConnection ? ((JarURLConnection)uc).getJarEntry().getTime() : uc.getLastModified();
                uc.getInputStream().close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        if (checkClass && this.pagesServletWrapper != null) {
            this.pagesServletWrapper.setServletClassLastModifiedTime(targetLastModified);
        }
        if (targetLastModified < jspRealLastModified) {
            this.jspModTime = jspRealLastModified;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Compiler: outdated: " + targetFile + " " + targetLastModified);
            }
            return true;
        }
        if (this.pagesServletWrapper == null) {
            return false;
        }
        List<String> depends = this.pagesServletWrapper.getDependants();
        if (depends == null) {
            return false;
        }
        for (String include : depends) {
            try {
                URL includeUrl = this.pagesCompilationContext.getResource(include);
                if (includeUrl == null) {
                    return true;
                }
                URLConnection includeUconn = includeUrl.openConnection();
                long includeLastModified = 0L;
                if (includeUconn instanceof JarURLConnection) {
                    includeUconn.setUseCaches(false);
                    includeLastModified = ((JarURLConnection)includeUconn).getJarEntry().getTime();
                } else {
                    includeLastModified = includeUconn.getLastModified();
                }
                includeUconn.getInputStream().close();
                if (includeLastModified <= targetLastModified) continue;
                if (include.endsWith(".tld")) {
                    this.pagesCompilationContext.clearTaglibs();
                    this.pagesCompilationContext.clearTagFileJarUrls();
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        return false;
    }

    private long getLastModifiedTime(File file) {
        BasicFileAttributes attributes;
        BasicFileAttributeView attributeView = Files.getFileAttributeView(file.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
        if (attributeView == null) {
            this.log.log(Level.SEVERE, "Basic attribute view is not available for " + file.getAbsolutePath());
            return 0L;
        }
        try {
            attributes = attributeView.readAttributes();
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Failed to read attributes for file " + file.getAbsolutePath(), e);
            return 0L;
        }
        FileTime creationTime = attributes.creationTime();
        FileTime lastModifiedTime = attributes.lastModifiedTime();
        if (creationTime == null) {
            return lastModifiedTime != null ? lastModifiedTime.toMillis() : 0L;
        }
        if (lastModifiedTime == null) {
            return creationTime.toMillis();
        }
        return creationTime.compareTo(lastModifiedTime) <= 0 ? lastModifiedTime.toMillis() : creationTime.toMillis();
    }

    public ErrorDispatcher getErrorDispatcher() {
        return this.errDispatcher;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public JspCompilationContext getCompilationContext() {
        return this.pagesCompilationContext;
    }

    public void removeGeneratedFiles() {
        try {
            String classFileName = this.pagesCompilationContext.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Deleting " + classFile);
                }
                classFile.delete();
            }
        }
        catch (Exception classFileName) {
            // empty catch block
        }
        try {
            String javaFileName = this.pagesCompilationContext.getServletJavaFileName();
            if (javaFileName != null) {
                File javaFile = new File(javaFileName);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Deleting " + javaFile);
                }
                javaFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeGeneratedClassFiles() {
        try {
            String classFileName = this.pagesCompilationContext.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Deleting " + classFile);
                }
                classFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initJavaCompiler() throws WaspException {
        if (this.options.getCompilerClassName() != null) {
            Class<?> compilerClass = this.getClassFor(this.options.getCompilerClassName());
            try {
                this.javaCompiler = (JavaCompiler)compilerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.javaCompiler == null) {
            this.javaCompiler = new Jsr199JavaCompiler();
        }
        this.javaCompiler.init(this.pagesCompilationContext, this.errDispatcher, this.jspcMode);
    }

    private Class<?> getClassFor(String className) {
        try {
            return Class.forName(className, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private boolean systemJarInWebinf(String path) {
        if (path.indexOf("/WEB-INF/") < 0) {
            return false;
        }
        Boolean useMyFaces = (Boolean)this.pagesCompilationContext.getServletContext().getAttribute("com.sun.faces.useMyFaces");
        if (useMyFaces == null || !useMyFaces.booleanValue()) {
            for (String jar : systemFacesJars) {
                if (path.indexOf(jar) <= 0) continue;
                return true;
            }
        }
        for (String jar : systemJars) {
            if (path.indexOf(jar) <= 0) continue;
            return true;
        }
        return false;
    }
}

