/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.event.AdminCommandEventBrokerImpl;
import com.sun.enterprise.admin.util.CachedCommandModel;
import com.sun.enterprise.admin.util.CommandSecurityChecker;
import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.universal.collections.ManifestUtils;
import com.sun.enterprise.util.AnnotationUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.v3.admin.AdminCommandInstanceImpl;
import com.sun.enterprise.v3.admin.CommandNotFoundException;
import com.sun.enterprise.v3.admin.CommandRunnerProgressHelper;
import com.sun.enterprise.v3.admin.JobCreatorService;
import com.sun.enterprise.v3.admin.JobManagerService;
import com.sun.enterprise.v3.common.XMLContentActionReporter;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandLock;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.CommandParameters;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandSupport;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.JobCreator;
import org.glassfish.api.admin.JobManager;
import org.glassfish.api.admin.ManagedJob;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.SupplementalCommandExecutor;
import org.glassfish.api.admin.WrappedAdminCommand;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.common.util.admin.ManPageFinder;
import org.glassfish.common.util.admin.MapInjectionResolver;
import org.glassfish.common.util.admin.UnacceptableValueException;
import org.glassfish.config.support.GenericCrudCommand;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.kernel.KernelLoggerInfo;
import org.hibernate.validator.HibernateValidator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.InjectionManager;
import org.jvnet.hk2.config.InjectionResolver;
import org.jvnet.hk2.config.MessageInterpolatorImpl;
import org.jvnet.hk2.config.UnsatisfiedDependencyException;

@Service
public class CommandRunnerImpl
implements CommandRunner {
    private static final Logger logger = KernelLoggerInfo.getLogger();
    private static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(CommandRunnerImpl.class);
    private static volatile Validator beanValidator;
    private static final String OLD_PASSWORD_PARAM_PREFIX = "AS_ADMIN_";
    private static final InjectionManager injectionMgr;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ServerContext serverContext;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment serverEnvironment;
    @Inject
    private ProcessEnvironment processEnvironment;
    @Inject
    private InstanceStateService instanceStateService;
    @Inject
    private AdminCommandLock adminLock;
    @Inject
    @Named(value="SupplementalCommandExecutorImpl")
    SupplementalCommandExecutor supplementalExecutor;
    @Inject
    private CommandSecurityChecker commandSecurityChecker;

    public ActionReport getActionReport(String name) {
        return (ActionReport)this.serviceLocator.getService(ActionReport.class, name, new Annotation[0]);
    }

    public CommandModel getModel(String commandName, Logger logger) {
        return this.getModel(null, commandName, logger);
    }

    public CommandModel getModel(String scope, String commandName, Logger logger) {
        AdminCommand command;
        try {
            String commandServiceName = scope != null ? scope + commandName : commandName;
            command = (AdminCommand)this.serviceLocator.getService(AdminCommand.class, commandServiceName, new Annotation[0]);
        }
        catch (MultiException e) {
            LogHelper.log((Logger)logger, (Level)Level.SEVERE, (String)"NCLS-CORE-00002", (Throwable)e, (Object[])new Object[]{commandName});
            return null;
        }
        return command == null ? null : CommandRunnerImpl.getModel(command);
    }

    public boolean validateCommandModelETag(AdminCommand command, String eTag) {
        if (command == null) {
            return true;
        }
        if (Utility.isEmpty((String)eTag)) {
            return false;
        }
        return this.validateCommandModelETag(CommandRunnerImpl.getModel(command), eTag);
    }

    public boolean validateCommandModelETag(CommandModel model, String eTag) {
        if (model == null) {
            return true;
        }
        if (Utility.isEmpty((String)eTag)) {
            return false;
        }
        return eTag.equals(CachedCommandModel.computeETag((CommandModel)model));
    }

    public AdminCommand getCommand(String commandName, ActionReport report, Logger logger) {
        return this.getCommand(null, commandName, report, logger);
    }

    private static Class<? extends Annotation> getScope(Class<?> onMe) {
        for (Annotation annotation : onMe.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Scope.class)) continue;
            return annotation.annotationType();
        }
        return null;
    }

    public AdminCommand getCommand(String scope, String commandName, ActionReport report, Logger logger) {
        CommandModel model;
        AdminCommand command = null;
        String commandServiceName = scope == null ? commandName : scope + commandName;
        try {
            command = (AdminCommand)this.serviceLocator.getService(AdminCommand.class, commandServiceName, new Annotation[0]);
        }
        catch (MultiException e) {
            report.setFailureCause((Throwable)e);
        }
        if (command == null) {
            String msg = !CommandRunnerImpl.ok(commandName) ? adminStrings.getLocalString("adapter.command.nocommand", "No command was specified.") : (this.serviceLocator.getServiceHandle(AdminCommand.class, commandServiceName, new Annotation[0]) == null ? adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", new Object[]{commandName}) : adminStrings.getLocalString("adapter.command.notcreated", "Implementation for the command {0} exists in the system, but it has some errors, check server.log for details", new Object[]{commandName}));
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            KernelLoggerInfo.getLogger().fine(msg);
            return null;
        }
        Class<? extends Annotation> myScope = CommandRunnerImpl.getScope(command.getClass());
        if (myScope == null) {
            String msg = adminStrings.getLocalString("adapter.command.noscope", "Implementation for the command {0} exists in the system,\nbut it has no @Scoped annotation", new Object[]{commandName});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            KernelLoggerInfo.getLogger().fine(msg);
            command = null;
        } else if (Singleton.class.equals(myScope) && !(model = CommandRunnerImpl.getModel(command)).getParameters().isEmpty()) {
            String msg = adminStrings.getLocalString("adapter.command.hasparams", "Implementation for the command {0} exists in the system,\nbut it's a singleton that also has parameters", new Object[]{commandName});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            KernelLoggerInfo.getLogger().fine(msg);
            command = null;
        }
        return command;
    }

    public CommandRunner.CommandInvocation getCommandInvocation(String name, ActionReport report, Subject subject) {
        return this.getCommandInvocation(name, report, subject, false);
    }

    public CommandRunner.CommandInvocation getCommandInvocation(String scope, String name, ActionReport report, Subject subject) {
        return this.getCommandInvocation(scope, name, report, subject, false);
    }

    public CommandRunner.CommandInvocation getCommandInvocation(String name, ActionReport report, Subject subject, boolean isNotify) {
        return this.getCommandInvocation(null, name, report, subject, false);
    }

    public CommandRunner.CommandInvocation getCommandInvocation(String scope, String name, ActionReport report, Subject subject, boolean isNotify) {
        return new ExecutionContext(scope, name, report, subject, isNotify);
    }

    public static boolean injectParameters(CommandModel model, Object injectionTarget, InjectionResolver<Param> injector, ActionReport report) {
        if (injectionTarget instanceof GenericCrudCommand) {
            GenericCrudCommand c = (GenericCrudCommand)GenericCrudCommand.class.cast(injectionTarget);
            c.setInjectionResolver(injector);
        }
        try {
            injectionMgr.inject(injectionTarget, new InjectionResolver[]{injector});
        }
        catch (UnsatisfiedDependencyException e) {
            String errorMsg;
            Param param = (Param)e.getAnnotation(Param.class);
            CommandModel.ParamModel paramModel = null;
            for (CommandModel.ParamModel pModel : model.getParameters()) {
                if (!pModel.getParam().equals(param)) continue;
                paramModel = pModel;
                break;
            }
            String usage = CommandRunnerImpl.getUsageText(model);
            if (paramModel != null) {
                String paramName = paramModel.getName();
                String paramDesc = paramModel.getLocalizedDescription();
                errorMsg = param.primary() ? adminStrings.getLocalString("commandrunner.operand.required", "Operand required.") : (param.password() ? adminStrings.getLocalString("adapter.param.missing.passwordfile", "{0} command requires the passwordfile parameter containing {1} entry.", new Object[]{model.getCommandName(), paramName}) : (paramDesc != null ? adminStrings.getLocalString("admin.param.missing", "{0} command requires the {1} parameter ({2})", new Object[]{model.getCommandName(), paramName, paramDesc}) : adminStrings.getLocalString("admin.param.missing.nodesc", "{0} command requires the {1} parameter", new Object[]{model.getCommandName(), paramName})));
            } else {
                errorMsg = adminStrings.getLocalString("admin.param.missing.nofound", "Cannot find {1} in {0} command model, file a bug", new Object[]{model.getCommandName(), e.getUnsatisfiedName()});
            }
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(errorMsg);
            report.setFailureCause((Throwable)e);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(usage);
            return false;
        }
        catch (MultiException e) {
            Throwable exception = null;
            Iterator paramModel = e.getErrors().iterator();
            block4: while (paramModel.hasNext()) {
                Throwable th;
                for (Throwable cause = th = (Throwable)paramModel.next(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof UnacceptableValueException) && !(cause instanceof IllegalArgumentException)) continue;
                    exception = (Exception)th;
                    continue block4;
                }
            }
            if (exception == null) {
                exception = e;
            }
            logger.log(Level.SEVERE, "NCLS-CORE-00003", exception);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(exception.getMessage());
            report.setFailureCause(exception);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(CommandRunnerImpl.getUsageText(model));
            return false;
        }
        CommandRunnerImpl.checkAgainstBeanConstraints(injectionTarget, model.getCommandName());
        return true;
    }

    private static synchronized void initBeanValidator() {
        if (beanValidator != null) {
            return;
        }
        ClassLoader cl = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            Thread.currentThread().setContextClassLoader(HibernateValidator.class.getClassLoader());
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            ValidatorContext validatorContext = validatorFactory.usingContext();
            validatorContext.messageInterpolator((MessageInterpolator)new MessageInterpolatorImpl());
            beanValidator = validatorContext.getValidator();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static void checkAgainstBeanConstraints(Object component, String cname) {
        CommandRunnerImpl.initBeanValidator();
        Set constraintViolations = beanValidator.validate(component, new Class[0]);
        if (constraintViolations == null || constraintViolations.isEmpty()) {
            return;
        }
        StringBuilder msg = new StringBuilder(adminStrings.getLocalString("commandrunner.unacceptableBV", "Parameters for command {0} violate the following constraints: ", new Object[]{cname}));
        boolean addc = false;
        String violationMsg = adminStrings.getLocalString("commandrunner.unacceptableBV.reason", "on parameter [ {1} ] violation reason [ {0} ]");
        for (ConstraintViolation constraintViolation : constraintViolations) {
            if (addc) {
                msg.append(", ");
            }
            msg.append(MessageFormat.format(violationMsg, constraintViolation.getMessage(), constraintViolation.getPropertyPath()));
            addc = true;
        }
        throw new UnacceptableValueException(msg.toString());
    }

    private ActionReport doCommand(CommandModel model, final AdminCommand command, final AdminCommandContext context, final CommandRunnerProgressHelper progressHelper) {
        ActionReport report = context.getActionReport();
        report.setActionDescription(model.getCommandName() + " AdminCommand");
        final Thread thread = Thread.currentThread();
        final ClassLoader origCL = thread.getContextClassLoader();
        final ClassLoader ccl = this.serverContext.getCommonClassLoader();
        WrappedAdminCommand wrappedCommand = new WrappedAdminCommand(command){

            public void execute(final AdminCommandContext context) {
                try {
                    if (origCL != ccl) {
                        thread.setContextClassLoader(ccl);
                    }
                    Subject.doAs(context.getSubject(), new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            command.execute(context);
                            return null;
                        }
                    });
                }
                finally {
                    if (origCL != ccl) {
                        thread.setContextClassLoader(origCL);
                    }
                }
            }
        };
        final AdminCommand otherWrappedCommand = CommandSupport.createWrappers((ServiceLocator)this.serviceLocator, (CommandModel)model, (AdminCommand)wrappedCommand, (ActionReport)report);
        try {
            Subject.doAs(context.getSubject(), new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        if (origCL != ccl) {
                            thread.setContextClassLoader(ccl);
                        }
                        otherWrappedCommand.execute(progressHelper.wrapContext4MainCommand(context));
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        if (origCL != ccl) {
                            thread.setContextClassLoader(origCL);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "NCLS-CORE-00003", e);
            report.setMessage(e.toString());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
        return context.getActionReport();
    }

    static String getUsageText(CommandModel model) {
        StringBuilder usageText = new StringBuilder();
        String usage = model.getUsageText();
        if (CommandRunnerImpl.ok(usage)) {
            usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
            usageText.append(usage);
            return usageText.toString();
        }
        return CommandRunnerImpl.generateUsageText(model);
    }

    private static String generateUsageText(CommandModel model) {
        StringBuffer usageText = new StringBuffer();
        usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
        usageText.append(model.getCommandName());
        usageText.append(" ");
        StringBuffer operand = new StringBuffer();
        for (CommandModel.ParamModel pModel : model.getParameters()) {
            Param param = pModel.getParam();
            String paramName = pModel.getName().toLowerCase(Locale.ENGLISH);
            if (paramName.startsWith("_") || param.password() || param.obsolete()) continue;
            boolean optional = param.optional();
            Class ftype = pModel.getType();
            String fvalue = null;
            String fvalueString = null;
            try {
                fvalue = param.defaultValue();
                if (fvalue != null) {
                    fvalueString = fvalue.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (param.primary()) {
                if (optional) {
                    operand.append("[").append(paramName).append("] ");
                    continue;
                }
                operand.append(paramName).append(" ");
                continue;
            }
            if (optional) {
                usageText.append("[");
            }
            usageText.append("--").append(paramName);
            if (CommandRunnerImpl.ok(param.defaultValue())) {
                usageText.append("=").append(param.defaultValue());
            } else if (ftype.isAssignableFrom(String.class)) {
                if (CommandRunnerImpl.ok(fvalueString)) {
                    usageText.append("=").append(fvalueString);
                } else {
                    usageText.append("=").append(paramName);
                }
            } else if (ftype.isAssignableFrom(Boolean.class)) {
                usageText.append("=").append("true|false");
            } else {
                usageText.append("=").append(paramName);
            }
            if (optional) {
                usageText.append("] ");
                continue;
            }
            usageText.append(" ");
        }
        usageText.append(operand);
        return usageText.toString();
    }

    public BufferedReader getHelp(CommandModel model) throws CommandNotFoundException {
        BufferedReader manPage = CommandRunnerImpl.getManPage(model.getCommandName(), model);
        if (manPage != null) {
            return manPage;
        }
        StringBuilder hlp = new StringBuilder(256);
        StringBuilder part = new StringBuilder(64);
        hlp.append("NAME").append(ManifestUtils.EOL);
        part.append(model.getCommandName());
        String description = model.getLocalizedDescription();
        if (CommandRunnerImpl.ok(description)) {
            part.append(" - ").append(model.getLocalizedDescription());
        }
        hlp.append(this.formatGeneratedManPagePart(part.toString(), 5, 65)).append(ManifestUtils.EOL);
        hlp.append(ManifestUtils.EOL).append("SYNOPSIS").append(ManifestUtils.EOL);
        hlp.append(this.formatGeneratedManPagePart(CommandRunnerImpl.getUsageText(model), 5, 65));
        hlp.append(ManifestUtils.EOL).append(ManifestUtils.EOL);
        hlp.append("OPTIONS").append(ManifestUtils.EOL);
        CommandModel.ParamModel operand = null;
        for (CommandModel.ParamModel paramModel : model.getParameters()) {
            String descr;
            Param param = paramModel.getParam();
            if (param == null || paramModel.getName().startsWith("_") || param.password() || param.obsolete()) continue;
            if (param.primary()) {
                operand = paramModel;
                continue;
            }
            hlp.append("     --").append(paramModel.getName().toLowerCase(Locale.ENGLISH));
            hlp.append(ManifestUtils.EOL);
            if (CommandRunnerImpl.ok(param.shortName())) {
                hlp.append("      -").append(param.shortName().toLowerCase(Locale.ENGLISH));
                hlp.append(ManifestUtils.EOL);
            }
            if (CommandRunnerImpl.ok(descr = paramModel.getLocalizedDescription())) {
                hlp.append(this.formatGeneratedManPagePart(descr, 9, 65));
            }
            hlp.append(ManifestUtils.EOL);
        }
        if (operand != null) {
            hlp.append("OPERANDS").append(ManifestUtils.EOL);
            hlp.append("     ").append(operand.getName().toLowerCase(Locale.ENGLISH));
            hlp.append(ManifestUtils.EOL);
            String descr = operand.getLocalizedDescription();
            if (CommandRunnerImpl.ok(descr)) {
                hlp.append(this.formatGeneratedManPagePart(descr, 9, 65));
            }
        }
        return new BufferedReader(new StringReader(hlp.toString()));
    }

    private String formatGeneratedManPagePart(String part, int prefix, int lineLength) {
        if (part == null) {
            return null;
        }
        if (prefix < 0) {
            prefix = 0;
        }
        StringBuilder sb = new StringBuilder(prefix);
        for (int i = 0; i < prefix; ++i) {
            sb.append(' ');
        }
        String prfx = sb.toString();
        StringBuilder result = new StringBuilder(part.length() + prefix + 16);
        boolean newLine = true;
        boolean lastWasCR = false;
        int counter = 0;
        for (int i = 0; i < part.length(); ++i) {
            boolean addPrefix = newLine;
            char ch = part.charAt(i);
            switch (ch) {
                case '\n': {
                    if (!lastWasCR) {
                        newLine = true;
                    } else {
                        lastWasCR = false;
                    }
                    counter = 0;
                    break;
                }
                case '\r': {
                    newLine = true;
                    lastWasCR = true;
                    counter = 0;
                    break;
                }
                default: {
                    newLine = false;
                    lastWasCR = false;
                    ++counter;
                }
            }
            if (addPrefix && !newLine) {
                result.append(prfx);
                counter += prefix;
            }
            result.append(ch);
            if (lineLength <= 0 || counter < lineLength || newLine) continue;
            newLine = true;
            result.append(ManifestUtils.EOL);
            counter = 0;
        }
        return result.toString();
    }

    public void getHelp(AdminCommand command, ActionReport report) {
        CommandModel model = CommandRunnerImpl.getModel(command);
        report.setActionDescription(model.getCommandName() + " help");
        if (report instanceof XMLContentActionReporter) {
            this.getMetadata(command, model, report);
        } else {
            report.setMessage(model.getCommandName() + " - " + model.getLocalizedDescription());
            report.getTopMessagePart().addProperty("SYNOPSIS", CommandRunnerImpl.encodeManPage(new BufferedReader(new StringReader(CommandRunnerImpl.getUsageText(model)))));
            for (CommandModel.ParamModel param : model.getParameters()) {
                this.addParamUsage(report, param);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private void getMetadata(AdminCommand command, CommandModel model, ActionReport report) {
        String usage;
        ActionReport.MessagePart top = report.getTopMessagePart();
        ActionReport.MessagePart cmd = top.addChild();
        cmd.setChildrenType("command");
        cmd.addProperty("name", model.getCommandName());
        if (model.unknownOptionsAreOperands()) {
            cmd.addProperty("unknown-options-are-operands", "true");
        }
        if (CommandRunnerImpl.ok(usage = model.getUsageText())) {
            cmd.addProperty("usage", usage);
        }
        CommandModel.ParamModel primary = null;
        for (CommandModel.ParamModel p : model.getParameters()) {
            String paramDesc;
            Param param = p.getParam();
            if (param.primary()) {
                primary = p;
                continue;
            }
            ActionReport.MessagePart ppart = cmd.addChild();
            ppart.setChildrenType("option");
            ppart.addProperty("name", p.getName());
            ppart.addProperty("type", CommandRunnerImpl.typeOf(p));
            ppart.addProperty("optional", Boolean.toString(param.optional()));
            if (param.obsolete()) {
                ppart.addProperty("obsolete", "true");
            }
            if (CommandRunnerImpl.ok(paramDesc = p.getLocalizedDescription())) {
                ppart.addProperty("description", paramDesc);
            }
            if (CommandRunnerImpl.ok(param.shortName())) {
                ppart.addProperty("short", param.shortName());
            }
            if (CommandRunnerImpl.ok(param.defaultValue())) {
                ppart.addProperty("default", param.defaultValue());
            }
            if (CommandRunnerImpl.ok(param.acceptableValues())) {
                ppart.addProperty("acceptable-values", param.acceptableValues());
            }
            if (!CommandRunnerImpl.ok(param.alias())) continue;
            ppart.addProperty("alias", param.alias());
        }
        if (primary != null) {
            ActionReport.MessagePart primpart = cmd.addChild();
            primpart.setChildrenType("operand");
            primpart.addProperty("name", primary.getName());
            primpart.addProperty("type", CommandRunnerImpl.typeOf(primary));
            primpart.addProperty("min", primary.getParam().optional() ? "0" : "1");
            primpart.addProperty("max", primary.getParam().multiple() ? "unlimited" : "1");
            String desc = primary.getLocalizedDescription();
            if (CommandRunnerImpl.ok(desc)) {
                primpart.addProperty("description", desc);
            }
        }
    }

    private static String typeOf(CommandModel.ParamModel p) {
        Class t = p.getType();
        if (t == Boolean.class || t == Boolean.TYPE) {
            return "BOOLEAN";
        }
        if (t == File.class || t == File[].class) {
            return "FILE";
        }
        if (t == Properties.class) {
            return "PROPERTIES";
        }
        if (p.getParam().password()) {
            return "PASSWORD";
        }
        return "STRING";
    }

    public static BufferedReader getManPage(String commandName, CommandModel model) {
        Class clazz = model.getCommandClass();
        if (clazz == null) {
            return null;
        }
        return ManPageFinder.getCommandManPage((String)commandName, (String)clazz.getName(), (Locale)Locale.getDefault(), (ClassLoader)clazz.getClassLoader(), (Logger)logger);
    }

    private void addParamUsage(ActionReport report, CommandModel.ParamModel model) {
        Param param = model.getParam();
        if (param != null) {
            String paramName = model.getName().toLowerCase(Locale.ENGLISH);
            if (paramName.startsWith("_") || param.password() || param.obsolete()) {
                return;
            }
            if (param.primary()) {
                report.getTopMessagePart().addProperty(paramName + "_operand", model.getLocalizedDescription());
            } else {
                report.getTopMessagePart().addProperty(paramName, model.getLocalizedDescription());
            }
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static void validateParameters(CommandModel model, ParameterMap parameters) throws MultiException {
        ParameterMap adds = null;
        for (Map.Entry entry : parameters.entrySet()) {
            CommandModel.ParamModel pModel;
            String key = (String)entry.getKey();
            if (key.equals("DEFAULT") || key.equals("help") || key.equals("Xhelp") || key.equals("notify")) continue;
            if (key.startsWith(OLD_PASSWORD_PARAM_PREFIX)) {
                key = key.substring(OLD_PASSWORD_PARAM_PREFIX.length()).toLowerCase(Locale.ENGLISH);
                if (adds == null) {
                    adds = new ParameterMap();
                }
                adds.add((Object)key, (Object)((String)((List)entry.getValue()).get(0)));
            }
            boolean validOption = false;
            Iterator iterator = model.getParameters().iterator();
            while (iterator.hasNext() && !(validOption = (pModel = (CommandModel.ParamModel)iterator.next()).isParamId(key))) {
            }
            if (validOption) continue;
            throw new MultiException((Throwable)new IllegalArgumentException(" Invalid option: " + key));
        }
        parameters.mergeAll(adds);
    }

    static boolean skipValidation(AdminCommand command) {
        try {
            final Field f = command.getClass().getDeclaredField("skipParamValidation");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    f.setAccessible(true);
                    return null;
                }
            });
            if (f.getType().isAssignableFrom(Boolean.TYPE)) {
                return f.getBoolean(command);
            }
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encodeManPage(BufferedReader br) {
        if (br == null) {
            return null;
        }
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("%%%EOL%%%");
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            String string = null;
            return string;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static CommandModel getModel(AdminCommand command) {
        if (command instanceof CommandModelProvider) {
            return ((CommandModelProvider)command).getModel();
        }
        return new CommandModelImpl(command.getClass());
    }

    /*
     * Exception decompiling
     */
    private void doCommand(ExecutionContext inv, AdminCommand command, Subject subject, Job job) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[TRYBLOCK]], but top level block is 95[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Object> buildEnvMap(ParameterMap params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : params.entrySet()) {
            List values = (List)entry.getValue();
            if (values == null || values.size() <= 0) continue;
            result.put((String)entry.getKey(), values.get(0));
        }
        return result;
    }

    public void executeFromCheckpoint(JobManager.Checkpoint checkpoint, boolean revert, AdminCommandEventBroker eventBroker) {
        ExecutionContext ec = new ExecutionContext(null, null, null, null, false);
        ec.executeFromCheckpoint(checkpoint, revert, eventBroker);
    }

    private static boolean isSet(ParameterMap params, String name) {
        String val = (String)params.getOne((Object)name);
        if (val == null) {
            return false;
        }
        return val.length() == 0 || Boolean.valueOf(val) != false;
    }

    private String formatSuspendDate(Date lockTime) {
        if (lockTime != null) {
            String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            return sdf.format(lockTime);
        }
        return adminStrings.getLocalString("lock.timeoutunavailable", "<<Date is unavailable>>");
    }

    static {
        injectionMgr = new InjectionManager();
    }

    class ExecutionContext
    implements CommandRunner.CommandInvocation {
        protected String scope;
        protected String name;
        protected ActionReport report;
        protected ParameterMap params;
        protected CommandParameters paramObject;
        protected Payload.Inbound inbound;
        protected Payload.Outbound outbound;
        protected Subject subject;
        protected ProgressStatus progressStatusChild;
        protected boolean isManagedJob;
        protected boolean isNotify;
        private final List<NameListerPair> nameListerPairs = new ArrayList<NameListerPair>();

        private ExecutionContext(String scope, String name, ActionReport report, Subject subject, boolean isNotify) {
            this.scope = scope;
            this.name = name;
            this.report = report;
            this.subject = subject;
            this.isNotify = isNotify;
        }

        public CommandRunner.CommandInvocation parameters(CommandParameters paramObject) {
            this.paramObject = paramObject;
            return this;
        }

        public CommandRunner.CommandInvocation parameters(ParameterMap params) {
            this.params = params;
            return this;
        }

        public CommandRunner.CommandInvocation inbound(Payload.Inbound inbound) {
            this.inbound = inbound;
            return this;
        }

        public CommandRunner.CommandInvocation outbound(Payload.Outbound outbound) {
            this.outbound = outbound;
            return this;
        }

        public CommandRunner.CommandInvocation listener(String nameRegexp, AdminCommandEventBroker.AdminCommandListener listener) {
            this.nameListerPairs.add(new NameListerPair(nameRegexp, listener));
            return this;
        }

        public CommandRunner.CommandInvocation progressStatusChild(ProgressStatus ps) {
            this.progressStatusChild = ps;
            return this;
        }

        public CommandRunner.CommandInvocation managedJob() {
            this.isManagedJob = true;
            return this;
        }

        public void execute() {
            this.execute(null);
        }

        private ParameterMap parameters() {
            return this.params;
        }

        private CommandParameters typedParams() {
            return this.paramObject;
        }

        private String name() {
            return this.name;
        }

        private String scope() {
            return this.scope;
        }

        public ActionReport report() {
            return this.report;
        }

        private void setReport(ActionReport ar) {
            this.report = ar;
        }

        private Payload.Inbound inboundPayload() {
            return this.inbound;
        }

        private Payload.Outbound outboundPayload() {
            return this.outbound;
        }

        private void executeFromCheckpoint(JobManager.Checkpoint checkpoint, boolean revert, AdminCommandEventBroker eventBroker) {
            Job job = checkpoint.getJob();
            if (this.subject == null) {
                this.subject = checkpoint.getContext().getSubject();
            }
            this.parameters(job.getParameters());
            AdminCommandContext context = checkpoint.getContext();
            this.report = context.getActionReport();
            this.inbound = context.getInboundPayload();
            this.outbound = context.getOutboundPayload();
            this.scope = job.getScope();
            this.name = job.getName();
            if (eventBroker == null) {
                eventBroker = job.getEventBroker() == null ? new AdminCommandEventBrokerImpl() : job.getEventBroker();
            }
            ((AdminCommandInstanceImpl)job).setEventBroker(eventBroker);
            ((AdminCommandInstanceImpl)job).setState(revert ? AdminCommandState.State.REVERTING : AdminCommandState.State.RUNNING_RETRYABLE);
            JobManager jobManager = (JobManager)CommandRunnerImpl.this.serviceLocator.getService(JobManagerService.class, new Annotation[0]);
            jobManager.registerJob(job);
            AdminCommand command = checkpoint.getCommand();
            if (command == null && (command = CommandRunnerImpl.this.getCommand(job.getScope(), job.getName(), this.report(), logger)) == null) {
                return;
            }
            CommandRunnerImpl.this.doCommand(this, command, this.subject, job);
            job.complete(this.report(), this.outboundPayload());
            if (this.progressStatusChild != null) {
                this.progressStatusChild.complete();
            }
            CommandSupport.done((ServiceLocator)CommandRunnerImpl.this.serviceLocator, (AdminCommand)command, (Job)job);
        }

        public void execute(AdminCommand command) {
            if (command == null && (command = CommandRunnerImpl.this.getCommand(this.scope(), this.name(), this.report(), logger)) == null) {
                return;
            }
            if (this.subject == null) {
                this.subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                    @Override
                    public Subject run() {
                        return Subject.getSubject(AccessController.getContext());
                    }
                });
            }
            if (!this.isManagedJob) {
                this.isManagedJob = AnnotationUtil.presentTransitive(ManagedJob.class, command.getClass());
            }
            JobCreator jobCreator = null;
            JobManager jobManager = null;
            jobCreator = (JobCreator)CommandRunnerImpl.this.serviceLocator.getService(JobCreator.class, this.scope + "job-creator", new Annotation[0]);
            jobManager = (JobManager)CommandRunnerImpl.this.serviceLocator.getService(JobManagerService.class, new Annotation[0]);
            if (jobCreator == null) {
                jobCreator = (JobCreator)CommandRunnerImpl.this.serviceLocator.getService(JobCreatorService.class, new Annotation[0]);
            }
            Job job = null;
            job = this.isManagedJob ? jobCreator.createJob(jobManager.getNewId(), this.scope(), this.name(), this.subject, this.isManagedJob, this.parameters()) : jobCreator.createJob(null, this.scope(), this.name(), this.subject, this.isManagedJob, this.parameters());
            for (NameListerPair nameListerPair : this.nameListerPairs) {
                job.getEventBroker().registerListener(nameListerPair.nameRegexp, nameListerPair.listener);
            }
            if (this.isManagedJob) {
                jobManager.registerJob(job);
            }
            CommandRunnerImpl.this.doCommand(this, command, this.subject, job);
            job.complete(this.report(), this.outboundPayload());
            if (this.progressStatusChild != null) {
                this.progressStatusChild.complete();
            }
            CommandSupport.done((ServiceLocator)CommandRunnerImpl.this.serviceLocator, (AdminCommand)command, (Job)job, (boolean)this.isNotify);
        }

        private class NameListerPair {
            private final String nameRegexp;
            private final AdminCommandEventBroker.AdminCommandListener listener;

            public NameListerPair(String nameRegexp, AdminCommandEventBroker.AdminCommandListener listener) {
                this.nameRegexp = nameRegexp;
                this.listener = listener;
            }
        }
    }

    private class UploadedFilesManager {
        private final ActionReport report;
        private final Logger logger;
        private MultiMap<String, File> optionNameToFileMap;
        private PayloadFilesManager.Temp payloadFilesMgr = null;

        private UploadedFilesManager(ActionReport report, Logger logger, Payload.Inbound inboundPayload) throws IOException, Exception {
            this.logger = logger;
            this.report = report;
            this.extractFiles(inboundPayload);
        }

        private MultiMap<String, File> optionNameToFileMap() {
            return this.optionNameToFileMap;
        }

        private void close() {
            if (this.payloadFilesMgr != null) {
                this.payloadFilesMgr.cleanup();
            }
        }

        private void extractFiles(Payload.Inbound inboundPayload) throws Exception {
            if (inboundPayload == null) {
                return;
            }
            File uniqueSubdirUnderApplications = this.chooseTempDirParent();
            this.payloadFilesMgr = new PayloadFilesManager.Temp(uniqueSubdirUnderApplications, this.report, this.logger);
            Map payloadFiles = this.payloadFilesMgr.processPartsExtended(inboundPayload);
            this.optionNameToFileMap = new MultiMap();
            for (Map.Entry e : payloadFiles.entrySet()) {
                String optionName = ((Properties)e.getValue()).getProperty("data-request-name");
                if (optionName == null) continue;
                this.logger.finer("UploadedFilesManager: map " + optionName + " to " + e.getKey());
                this.optionNameToFileMap.add(optionName, (File)e.getKey());
            }
        }

        private File chooseTempDirParent() throws IOException {
            File appRoot = new File(CommandRunnerImpl.this.domain.getApplicationRoot());
            if (!(appRoot.isDirectory() || appRoot.exists() || appRoot.mkdirs())) {
                throw new IOException(adminStrings.getLocalString("commandrunner.errCreDir", "Could not create the directory {0}; no further information is available.", new Object[]{appRoot.getAbsolutePath()}));
            }
            return appRoot;
        }
    }

    private static class DelegatedInjectionResolver
    extends InjectionResolver<Param> {
        private final CommandModel model;
        private final CommandParameters parameters;
        private final MultiMap<String, File> optionNameToUploadedFileMap;

        public DelegatedInjectionResolver(CommandModel model, CommandParameters parameters, MultiMap<String, File> optionNameToUploadedFileMap) {
            super(Param.class);
            this.model = model;
            this.parameters = parameters;
            this.optionNameToUploadedFileMap = optionNameToUploadedFileMap;
        }

        public boolean isOptional(AnnotatedElement element, Param annotation) {
            String name = CommandModel.getParamName((Param)annotation, (AnnotatedElement)element);
            CommandModel.ParamModel param = this.model.getModelFor(name);
            return param.getParam().optional();
        }

        public <V> V getValue(Object component, AnnotatedElement target, Type genericType, Class<V> type) {
            if (target instanceof Field) {
                final Field targetField = (Field)target;
                try {
                    Field sourceField = this.parameters.getClass().getField(targetField.getName());
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            targetField.setAccessible(true);
                            return null;
                        }
                    });
                    Object paramValue = sourceField.get(this.parameters);
                    List paramFileValues = MapInjectionResolver.getUploadedFileParamValues((String)targetField.getName(), targetField.getType(), this.optionNameToUploadedFileMap);
                    if (!paramFileValues.isEmpty()) {
                        Object fileValue = MapInjectionResolver.convertListToObject((AnnotatedElement)target, type, (List)paramFileValues);
                        return (V)fileValue;
                    }
                    if (paramValue != null) {
                        DelegatedInjectionResolver.checkAgainstAcceptableValues(target, paramValue.toString());
                    }
                    return type.cast(paramValue);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            return null;
        }

        private static void checkAgainstAcceptableValues(AnnotatedElement target, String paramValueStr) {
            Param param = target.getAnnotation(Param.class);
            String acceptable = param.acceptableValues();
            String paramName = CommandModel.getParamName((Param)param, (AnnotatedElement)target);
            if (CommandRunnerImpl.ok(acceptable) && CommandRunnerImpl.ok(paramValueStr)) {
                String[] ss;
                for (String s : ss = acceptable.split(",")) {
                    if (!paramValueStr.equals(s.trim())) continue;
                    return;
                }
                throw new UnacceptableValueException(adminStrings.getLocalString("adapter.command.unacceptableValue", "Invalid parameter: {0}.  Its value is {1} but it isn''t one of these acceptable values: {2}", new Object[]{paramName, paramValueStr, acceptable}));
            }
        }
    }

    private static class NameCommandClassPair {
        private final String name;
        private final Class<? extends AdminCommand> clazz;
        private int hash;

        public NameCommandClassPair(String name, Class<? extends AdminCommand> clazz) {
            this.name = name;
            this.clazz = clazz;
            this.hash = 3;
            this.hash = 67 * this.hash + (this.name != null ? this.name.hashCode() : 0);
            this.hash = 67 * this.hash + (this.clazz != null ? this.clazz.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NameCommandClassPair other = (NameCommandClassPair)obj;
            if (this.clazz != other.clazz) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

