/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ConfigurationCleanup;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.config.support.ConfigurationAccess;
import org.glassfish.config.support.DasReaderFilter;
import org.glassfish.config.support.InstanceReaderFilter;
import org.glassfish.config.support.ServerReaderFilter;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.ConfigPopulatorException;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.Populator;

public abstract class DomainXml
implements Populator {
    private static final Logger LOG = Logger.getLogger(DomainXml.class.getName());
    @Inject
    StartupContext context;
    @Inject
    protected ServiceLocator habitat;
    @Inject
    @Optional
    private ModulesRegistry registry;
    @Inject
    XMLInputFactory xif;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    ConfigurationAccess configAccess;
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DomainXml.class);
    private static final LocalStringsImpl strings = new LocalStringsImpl(DomainXml.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ConfigParser parser) throws ConfigPopulatorException {
        ClassLoader parentClassLoader;
        LOG.log(Level.FINE, "NCLS-CFGAPI-00083", this.getClass().getName());
        ClassLoader classLoader = parentClassLoader = this.registry == null ? this.getClass().getClassLoader() : this.registry.getParentClassLoader();
        if (parentClassLoader == null) {
            parentClassLoader = this.getClass().getClassLoader();
        }
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.habitat, (Object)parentClassLoader, null, (Type[])new Type[]{ClassLoader.class});
        String instance = this.env.getInstanceName();
        URL domainURL = null;
        try {
            domainURL = this.getDomainXml(this.env);
            this.parseDomainXml(parser, domainURL, instance);
        }
        catch (NoBackupException ex) {
            this.throwParseError(ex);
        }
        catch (Throwable ex) {
            if (domainURL == null || this.isBackupFile(domainURL)) {
                this.throwParseError(ex);
            }
            try {
                domainURL = this.getAlternativeDomainXml(this.env);
                this.parseDomainXml(parser, this.getAlternativeDomainXml(this.env), instance);
            }
            catch (Throwable e) {
                e.addSuppressed(ex);
                this.throwParseError(e);
            }
        }
        if (this.isBackupFile(domainURL)) {
            Lock writeLock = null;
            try {
                writeLock = this.configAccess.accessWrite();
                File destination = new File(this.env.getConfigDirPath(), "domain.xml");
                File backup = new File(this.env.getConfigDirPath(), "domain.xml.bak");
                if (!destination.exists() || destination.delete() && !destination.exists()) {
                    FileUtils.renameFile((File)backup, (File)destination);
                }
            }
            catch (IOException | TimeoutException destination) {
            }
            finally {
                if (writeLock != null) {
                    writeLock.unlock();
                }
            }
        }
        if ("upgrade".equals(this.context.getPlatformMainServiceName())) {
            this.upgrade();
        }
        for (ServiceHandle cc : this.habitat.getAllServiceHandles(ConfigurationCleanup.class, new Annotation[0])) {
            try {
                cc.getService();
                LOG.log(Level.FINE, "NCLS-CFGAPI-00084", cc.getClass());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "NCLS-CFGAPI-00085", new Object[]{cc.getClass(), e});
                LOG.log(Level.FINE, "Cleaning the domain.xml failed!", e);
            }
        }
        this.decorate();
    }

    protected boolean isBackupFile(URL url) {
        return url.getPath().endsWith("domain.xml.bak");
    }

    private void throwParseError(Throwable parent) {
        throw new ConfigPopulatorException(localStrings.getLocalString("ConfigParsingFailed", "Failed to parse domain.xml"), parent);
    }

    protected void decorate() {
        Server server = (Server)this.habitat.getService(Server.class, this.env.getInstanceName(), new Annotation[0]);
        if (server == null) {
            LOG.log(Level.SEVERE, "NCLS-CFGAPI-00086", this.env.getInstanceName());
            return;
        }
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.habitat, (Object)server, (String)"default-instance-name", (Type[])new Type[]{Server.class});
        server.getConfig().addIndex(this.habitat, "default-instance-name");
        Cluster c = server.getCluster();
        if (c != null) {
            ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.habitat, (Object)c, (String)"default-instance-name", (Type[])new Type[]{Cluster.class});
        }
    }

    protected void upgrade() {
        for (ServiceHandle cu : this.habitat.getAllServiceHandles(ConfigurationUpgrade.class, new Annotation[0])) {
            try {
                cu.getService();
                LOG.log(Level.FINE, "NCLS-CFGAPI-00087", cu.getClass());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "NCLS-CFGAPI-00088", new Object[]{cu.getClass(), e});
                LOG.log(Level.FINE, "Upgrade of the domain.xml failed!", e);
            }
        }
    }

    private boolean checkDomainFile(File domainFile, Supplier<String> errorMessage) {
        if (domainFile.exists() && domainFile.length() > 0L) {
            return true;
        }
        LOG.log(Level.SEVERE, errorMessage.get());
        return false;
    }

    protected URL getAlternativeDomainXml(ServerEnvironmentImpl env) throws IOException {
        File domainXml = new File(env.getConfigDirPath(), "domain.xml.bak");
        if (this.checkDomainFile(domainXml, () -> "NCLS-CFGAPI-00090")) {
            return domainXml.toURI().toURL();
        }
        throw new NoBackupException(env.getConfigDirPath());
    }

    protected URL getDomainXml(ServerEnvironmentImpl env) throws IOException {
        File domainXml = new File(env.getConfigDirPath(), "domain.xml");
        if (this.checkDomainFile(domainXml, () -> "NCLS-CFGAPI-00089")) {
            return domainXml.toURI().toURL();
        }
        return this.getAlternativeDomainXml(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDomainXml(ConfigParser parser, URL domainXml, String serverName) {
        long startNano = System.nanoTime();
        try {
            ServerReaderFilter xsr = null;
            this.xif.setXMLResolver(new XMLResolver(){

                @Override
                public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                    return new ByteArrayInputStream(new byte[0]);
                }
            });
            if (this.env.getRuntimeType() == RuntimeType.DAS || this.env.getRuntimeType() == RuntimeType.EMBEDDED) {
                xsr = new DasReaderFilter(domainXml, this.xif);
            } else if (this.env.getRuntimeType() == RuntimeType.INSTANCE) {
                xsr = new InstanceReaderFilter(this.env.getInstanceName(), domainXml, this.xif);
            } else {
                throw new RuntimeException("Internal Error: Unknown server type: " + this.env.getRuntimeType());
            }
            Lock lock = null;
            try {
                try {
                    lock = this.configAccess.accessRead();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                parser.parse((XMLStreamReader)xsr, this.getDomDocument());
                xsr.close();
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
            String errorMessage = xsr.configWasFound();
            if (errorMessage != null) {
                LOG.log(Level.WARNING, errorMessage);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Fatal Error. Unable to parse " + domainXml, e);
        }
        LOG.log(Level.CONFIG, "NCLS-CFGAPI-00092", System.nanoTime() - startNano);
    }

    protected abstract DomDocument getDomDocument();

    private static class NoBackupException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private NoBackupException(File configDirectory) {
            super(localStrings.getLocalString("NoUsableConfigFile", "No usable configuration file at {0}", new Object[]{configDirectory.getAbsolutePath()}));
        }
    }
}

