/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator;

import com.sun.ejb.codegen.ClassGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.generator.GeneratorException;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.hk2.api.ServiceLocator;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ASMClassWriter
implements ClassWriter {
    private static final String INJECTOR_FIELD = "serviceLocator";
    private static final String FORNAME_INJECTOR_TYPE = "Lorg/glassfish/hk2/api/ServiceLocator;";
    private static final String INTERFACE_INJECTOR_TYPE = "org/glassfish/hk2/api/ServiceLocator";
    private static final String CREATE_AND_INITIALIZE = "createAndInitialize";
    private static final String CREATE_AND_INITIALIZE_SIG = "(Ljava/lang/Class;)Ljava/lang/Object;";
    private final org.objectweb.asm.ClassWriter cw = new org.objectweb.asm.ClassWriter(0);
    private String className;
    private ServiceLocator habitat;
    private final String generatedPath;
    private final Map<String, String> generatedMethods = new HashMap<String, String>();

    public ASMClassWriter(ServiceLocator habitat, String generatedPath, String className, String baseClassName, String resourcePath) {
        this.habitat = habitat;
        this.className = className;
        this.generatedPath = generatedPath;
        if (((String)baseClassName).indexOf("TemplateCommand") != -1) {
            return;
        }
        baseClassName = ((String)baseClassName).indexOf(".") != -1 ? ((String)baseClassName).replace('.', '/') : "org/glassfish/admin/rest/resources/" + (String)baseClassName;
        this.cw.visit(49, 33, generatedPath + className, null, (String)baseClassName, null);
        if (resourcePath != null) {
            RestLogging.restLogger.log(Level.FINE, "Creating resource with path {0} (1)", resourcePath);
            AnnotationVisitor av0 = this.cw.visitAnnotation("Ljakarta/ws/rs/Path;", true);
            av0.visit("value", (Object)("/" + resourcePath + "/"));
            av0.visitEnd();
        }
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, (String)baseClassName, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    @Override
    public void createCustomResourceMapping(String resourceClassName, String mappingPath) {
        String completeName = "org/glassfish/admin/rest/resources/custom/" + resourceClassName;
        String baseClassName = this.generatedPath + this.className;
        MethodVisitor mv = this.cw.visitMethod(1, "get" + resourceClassName, "()L" + completeName + ";", null, null);
        RestLogging.restLogger.log(Level.FINE, "Creating resource with path {0} (2)", mappingPath);
        AnnotationVisitor av0 = mv.visitAnnotation("Ljakarta/ws/rs/Path;", true);
        av0.visit("value", (Object)(mappingPath + "/"));
        av0.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, baseClassName, INJECTOR_FIELD, FORNAME_INJECTOR_TYPE);
        mv.visitLdcInsn((Object)Type.getType((String)("L" + completeName + ";")));
        mv.visitMethodInsn(185, INTERFACE_INJECTOR_TYPE, CREATE_AND_INITIALIZE, CREATE_AND_INITIALIZE_SIG);
        mv.visitTypeInsn(192, completeName);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, baseClassName, "getEntity", "()Lorg/jvnet/hk2/config/Dom;");
        mv.visitMethodInsn(182, completeName, "setEntity", "(Lorg/jvnet/hk2/config/Dom;)V");
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    @Override
    public void createGetCommandResourcePaths(List<CommandResourceMetaData> commandMetaData) {
        MethodVisitor mv = this.cw.visitMethod(1, "getCommandResourcesPaths", "()[[Ljava/lang/String;", null, null);
        mv.visitCode();
        int size = 0;
        for (CommandResourceMetaData metaData : commandMetaData) {
            if (!ResourceUtil.commandIsPresent(this.habitat, metaData.command)) continue;
            ++size;
        }
        mv.visitIntInsn(16, size);
        mv.visitTypeInsn(189, "[Ljava/lang/String;");
        int index = -1;
        for (CommandResourceMetaData metaData : commandMetaData) {
            if (!ResourceUtil.commandIsPresent(this.habitat, metaData.command)) continue;
            switch (++index) {
                case 0: {
                    mv.visitInsn(89);
                    mv.visitInsn(3);
                    mv.visitInsn(6);
                    break;
                }
                case 1: {
                    mv.visitInsn(89);
                    mv.visitInsn(4);
                    mv.visitInsn(6);
                    break;
                }
                case 2: {
                    mv.visitInsn(89);
                    mv.visitInsn(5);
                    mv.visitInsn(6);
                    break;
                }
                case 3: {
                    mv.visitInsn(89);
                    mv.visitInsn(6);
                    mv.visitInsn(6);
                    break;
                }
                case 4: {
                    mv.visitInsn(89);
                    mv.visitInsn(7);
                    mv.visitInsn(6);
                    break;
                }
                case 5: {
                    mv.visitInsn(89);
                    mv.visitInsn(8);
                    mv.visitInsn(6);
                    break;
                }
                default: {
                    mv.visitInsn(89);
                    mv.visitIntInsn(16, index);
                    mv.visitInsn(6);
                }
            }
            mv.visitTypeInsn(189, "java/lang/String");
            mv.visitInsn(89);
            mv.visitInsn(3);
            mv.visitLdcInsn((Object)metaData.resourcePath);
            mv.visitInsn(83);
            mv.visitInsn(89);
            mv.visitInsn(4);
            mv.visitLdcInsn((Object)metaData.httpMethod);
            mv.visitInsn(83);
            mv.visitInsn(89);
            mv.visitInsn(5);
            mv.visitLdcInsn((Object)metaData.command);
            mv.visitInsn(83);
            mv.visitInsn(83);
        }
        mv.visitInsn(176);
        mv.visitMaxs(7, 1);
        mv.visitEnd();
    }

    @Override
    public void createGetCommandResource(String commandResourceClassName, String resourcePath) {
        MethodVisitor mv = this.cw.visitMethod(1, "get" + commandResourceClassName, "()L" + this.generatedPath + commandResourceClassName + ";", null, null);
        RestLogging.restLogger.log(Level.FINE, "Creating resource with path {0} (3)", resourcePath);
        AnnotationVisitor av0 = mv.visitAnnotation("Ljakarta/ws/rs/Path;", true);
        av0.visit("value", (Object)(resourcePath + "/"));
        av0.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.generatedPath + this.className, INJECTOR_FIELD, FORNAME_INJECTOR_TYPE);
        mv.visitLdcInsn((Object)Type.getType((String)("L" + this.generatedPath + commandResourceClassName + ";")));
        mv.visitMethodInsn(185, INTERFACE_INJECTOR_TYPE, CREATE_AND_INITIALIZE, CREATE_AND_INITIALIZE_SIG);
        mv.visitTypeInsn(192, this.generatedPath + commandResourceClassName);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    @Override
    public void createCommandResourceConstructor(String commandResourceClassName, String commandName, String httpMethod, boolean linkedToParent, CommandResourceMetaData.ParameterMetaData[] commandParams, String commandDisplayName, String commandAction) {
        String baseClassName = "";
        if (httpMethod.equals("GET")) {
            baseClassName = "org/glassfish/admin/rest/resources/TemplateCommandGetResource";
        } else if (httpMethod.equals("DELETE")) {
            baseClassName = "org/glassfish/admin/rest/resources/TemplateCommandDeleteResource";
        } else if (httpMethod.equals("POST")) {
            baseClassName = "org/glassfish/admin/rest/resources/TemplateCommandPostResource";
        } else {
            throw new GeneratorException("Invalid httpMethod specified: " + httpMethod);
        }
        boolean isget = httpMethod.equals("GET");
        this.cw.visit(49, 33, this.generatedPath + commandResourceClassName, null, baseClassName, null);
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)commandResourceClassName);
        mv.visitLdcInsn((Object)commandName);
        mv.visitLdcInsn((Object)httpMethod);
        if (!isget) {
            mv.visitLdcInsn((Object)commandAction);
            mv.visitLdcInsn((Object)commandDisplayName);
        }
        if (linkedToParent) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        if (!isget) {
            mv.visitMethodInsn(183, baseClassName, "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V");
        } else {
            mv.visitMethodInsn(183, baseClassName, "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V");
        }
        mv.visitInsn(177);
        if (!isget) {
            mv.visitMaxs(7, 1);
        } else {
            mv.visitMaxs(5, 1);
        }
        mv.visitEnd();
        if (commandParams != null) {
            mv = this.cw.visitMethod(4, "getCommandParams", "()Ljava/util/HashMap;", "()Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/String;>;", null);
            mv.visitCode();
            mv.visitTypeInsn(187, "java/util/HashMap");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
            mv.visitVarInsn(58, 1);
            for (CommandResourceMetaData.ParameterMetaData commandParam : commandParams) {
                mv.visitVarInsn(25, 1);
                mv.visitLdcInsn((Object)commandParam.name);
                mv.visitLdcInsn((Object)commandParam.value);
                mv.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                mv.visitInsn(87);
            }
            mv.visitVarInsn(25, 1);
            mv.visitInsn(176);
            mv.visitMaxs(3, 2);
            mv.visitEnd();
        }
    }

    @Override
    public void done() {
        this.cw.visitEnd();
        try {
            this.defineClass(this.getClass(), this.cw.toByteArray());
            if ("true".equals(System.getenv("REST_DEBUG"))) {
                this.debug(this.className, this.cw.toByteArray());
            }
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void createGetDeleteCommand(String commandName) {
        MethodVisitor mv = this.cw.visitMethod(1, "getDeleteCommand", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)commandName);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    @Override
    public void createGetPostCommand(String commandName) {
        MethodVisitor mv = this.cw.visitMethod(1, "getPostCommand", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)commandName);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    @Override
    public void createGetChildResource(String path, String childResourceClassName) {
        String methodName;
        Object childClass = childResourceClassName.equals("PropertiesBagResource") ? "org/glassfish/admin/rest/resources/PropertiesBagResource" : this.generatedPath + childResourceClassName;
        if (((String)childClass).equals(this.generatedMethods.get(methodName = "get" + childResourceClassName))) {
            return;
        }
        this.generatedMethods.put(methodName, (String)childClass);
        MethodVisitor mv = this.cw.visitMethod(1, methodName, "()L" + (String)childClass + ";", null, null);
        RestLogging.restLogger.log(Level.FINE, "Creating resource with path {0} (4)", path);
        AnnotationVisitor av0 = mv.visitAnnotation("Ljakarta/ws/rs/Path;", true);
        av0.visit("value", (Object)(path + "/"));
        av0.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.generatedPath + this.className, INJECTOR_FIELD, FORNAME_INJECTOR_TYPE);
        mv.visitLdcInsn((Object)Type.getType((String)("L" + (String)childClass + ";")));
        mv.visitMethodInsn(185, INTERFACE_INJECTOR_TYPE, CREATE_AND_INITIALIZE, CREATE_AND_INITIALIZE_SIG);
        mv.visitTypeInsn(192, (String)childClass);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.generatedPath + this.className, "getEntity", "()Lorg/jvnet/hk2/config/Dom;");
        mv.visitLdcInsn((Object)path);
        mv.visitMethodInsn(182, (String)childClass, "setParentAndTagName", "(Lorg/jvnet/hk2/config/Dom;Ljava/lang/String;)V");
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    @Override
    public void createGetChildResourceForListResources(String keyAttributeName, String childResourceClassName) {
        MethodVisitor mv = this.cw.visitMethod(1, "get" + childResourceClassName, "(Ljava/lang/String;)L" + this.generatedPath + childResourceClassName + ";", null, null);
        RestLogging.restLogger.log(Level.FINE, "Creating resource with path {0} (5)", keyAttributeName);
        AnnotationVisitor av0 = mv.visitAnnotation("Ljakarta/ws/rs/Path;", true);
        av0.visit("value", (Object)("{" + keyAttributeName + "}/"));
        av0.visitEnd();
        av0 = mv.visitParameterAnnotation(0, "Ljakarta/ws/rs/PathParam;", true);
        av0.visit("value", (Object)keyAttributeName);
        av0.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.generatedPath + "List" + childResourceClassName, INJECTOR_FIELD, FORNAME_INJECTOR_TYPE);
        mv.visitLdcInsn((Object)Type.getType((String)("L" + this.generatedPath + childResourceClassName + ";")));
        mv.visitMethodInsn(185, INTERFACE_INJECTOR_TYPE, CREATE_AND_INITIALIZE, CREATE_AND_INITIALIZE_SIG);
        mv.visitTypeInsn(192, this.generatedPath + childResourceClassName);
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.generatedPath + "List" + childResourceClassName, "entity", "Ljava/util/List;");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.generatedPath + "List" + childResourceClassName, "tagName", "Ljava/lang/String;");
        mv.visitMethodInsn(182, this.generatedPath + childResourceClassName, "setBeanByKey", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V");
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitMaxs(4, 3);
        mv.visitEnd();
    }

    @Override
    public void createGetPostCommandForCollectionLeafResource(String postCommandName) {
        MethodVisitor mv = this.cw.visitMethod(4, "getPostCommand", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)postCommandName);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    @Override
    public void createGetDeleteCommandForCollectionLeafResource(String deleteCommandName) {
        MethodVisitor mv = this.cw.visitMethod(4, "getDeleteCommand", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)deleteCommandName);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    @Override
    public void createGetDisplayNameForCollectionLeafResource(String displayName) {
        MethodVisitor mv = this.cw.visitMethod(4, "getName", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)displayName);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public byte[] getByteClass() {
        return this.cw.toByteArray();
    }

    private void defineClass(Class similarClass, byte[] classBytes) throws Exception {
        String generatedClassName = "org.glassfish.admin.rest.resources.generatedASM." + this.className;
        RestLogging.restLogger.log(Level.FINEST, "Generating class {0}", generatedClassName);
        ClassLoader loader = similarClass.getClassLoader();
        ProtectionDomain pd = similarClass.getProtectionDomain();
        byte[] byteContent = this.getByteClass();
        ClassGenerator.defineClass((ClassLoader)loader, (String)generatedClassName, (byte[])byteContent, (ProtectionDomain)pd);
        try {
            loader.loadClass(generatedClassName);
        }
        catch (ClassNotFoundException cnfEx) {
            throw new GeneratorException(cnfEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debug(String clsName, byte[] classData) {
        clsName = clsName.replace('.', '/');
        int index = (clsName = clsName.replace('\\', '/')).lastIndexOf("/");
        if (index >= 0) {
            clsName = clsName.substring(index + 1);
        }
        FileOutputStream fos = null;
        try {
            String rootPath = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "rest" + File.separator;
            File parentDir = new File(rootPath);
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                throw new RuntimeException("Unable to create parent directory for generated class file logging");
            }
            fos = new FileOutputStream(new File(parentDir, clsName + ".class"));
            fos.write(classData);
            fos.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    RestLogging.restLogger.log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

