/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.util.cluster.SyncRequest;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.common.util.admin.AuthTokenManager;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_synchronize-instance")
@PerLookup
public class SynchronizeInstanceCommand
extends LocalInstanceCommand {
    @Param(name="instance_name", primary=true, optional=true)
    private String instanceName0;
    @Param(name="sync", optional=true, defaultValue="normal", acceptableValues="none, normal, full")
    protected String sync = "normal";
    private RemoteCLICommand syncCmd = null;
    private static final String SYNC_STATE_FILE = ".syncstate";

    @Override
    protected void validate() throws CommandException {
        if (SynchronizeInstanceCommand.ok((String)this.instanceName0)) {
            this.instanceName = this.instanceName0;
        }
        super.validate();
    }

    protected int executeCommand() throws CommandException {
        if (this.synchronizeInstance()) {
            return 0;
        }
        logger.info(Strings.get("Sync.failed", this.programOpts.getHost(), Integer.toString(this.programOpts.getPort())));
        return 1;
    }

    protected boolean synchronizeInstance() throws CommandException {
        File domainXml;
        File dasProperties = this.getServerDirs().getDasPropertiesFile();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("das.properties: " + dasProperties);
        }
        if (!dasProperties.exists()) {
            logger.info(Strings.get("Sync.noDASConfigured", dasProperties.toString()));
            return false;
        }
        this.setDasDefaults(dasProperties);
        String origAuthToken = this.programOpts.getAuthToken();
        if (origAuthToken != null) {
            this.programOpts.setAuthToken(AuthTokenManager.markTokenForReuse((String)origAuthToken));
        }
        this.syncCmd = new RemoteCLICommand("_synchronize-files", this.programOpts, this.env);
        this.syncCmd.setFileOutputDirectory(this.instanceDir);
        File syncState = new File(this.instanceDir, SYNC_STATE_FILE);
        boolean doFullSync = false;
        if (this.sync.equals("normal") && syncState.exists()) {
            String lastSync = DateFormat.getDateTimeInstance().format(new Date(syncState.lastModified()));
            logger.info(Strings.get("Sync.fullRequired", lastSync));
            doFullSync = true;
        }
        try {
            syncState.createNewFile();
        }
        catch (IOException ex) {
            logger.warning(Strings.get("Sync.cantCreateSyncState", syncState));
        }
        if (this.sync.equals("full") || doFullSync) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Strings.get("Instance.fullsync", this.instanceName));
            }
            this.removeSubdirectory("config");
            this.removeSubdirectory("applications");
            this.removeSubdirectory("generated");
            this.removeSubdirectory("lib");
            this.removeSubdirectory("docroot");
        }
        long dtime = (domainXml = new File(new File(this.instanceDir, "config"), "domain.xml")).exists() ? domainXml.lastModified() : -1L;
        File docroot = new File(this.instanceDir, "docroot");
        CommandException exc = null;
        try {
            SyncRequest sr = this.getModTimes("config", SyncLevel.FILES);
            this.synchronizeFiles(sr);
            if (domainXml.lastModified() == dtime) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(Strings.get("Sync.alreadySynced"));
                }
                if (!syncState.delete()) {
                    logger.warning(Strings.get("Sync.cantDeleteSyncState", syncState));
                }
                return true;
            }
            sr = this.getModTimes("applications", SyncLevel.DIRECTORY);
            this.synchronizeFiles(sr);
            File appsDir = new File(this.instanceDir, "applications");
            File archiveDir = new File(appsDir, "__internal");
            for (File adir : FileUtils.listFiles((File)archiveDir)) {
                File[] af = FileUtils.listFiles((File)adir);
                if (af.length != 1) {
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.finer("IGNORING " + adir + ", # files " + af.length);
                    continue;
                }
                File archive = af[0];
                File appDir = new File(appsDir, adir.getName());
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("UNZIP " + archive + " TO " + appDir);
                }
                try {
                    SynchronizeInstanceCommand.expand(appDir, archive);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            FileUtils.whack((File)archiveDir);
            sr = this.getModTimes("lib", SyncLevel.RECURSIVE);
            this.synchronizeFiles(sr);
            sr = this.getModTimes("docroot", SyncLevel.DIRECTORY);
            this.synchronizeFiles(sr);
            sr = new SyncRequest();
            sr.instance = this.instanceName;
            sr.dir = "config-specific";
            File configDir = new File(this.instanceDir, "config");
            for (File f : configDir.listFiles()) {
                if (!f.isDirectory()) continue;
                this.getFileModTimes(f, configDir, sr, SyncLevel.DIRECTORY);
            }
            if (origAuthToken != null) {
                this.syncCmd.getProgramOptions().setAuthToken(origAuthToken);
            }
            this.synchronizeFiles(sr);
        }
        catch (ConnectException cex) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Couldn't connect to DAS: " + cex);
            }
            exc = new CommandException(Strings.get("Sync.connectFailed", cex.getMessage()));
        }
        catch (CommandException ex) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Exception during synchronization: " + ex);
            }
            exc = ex;
        }
        if (exc != null) {
            if (domainXml.exists() && domainXml.lastModified() == dtime && docroot.isDirectory()) {
                if (!syncState.delete()) {
                    logger.warning(Strings.get("Sync.cantDeleteSyncState", syncState));
                }
                return false;
            }
            throw exc;
        }
        if (!syncState.delete()) {
            logger.warning(Strings.get("Sync.cantDeleteSyncState", syncState));
        }
        return true;
    }

    private SyncRequest getModTimes(String dir, SyncLevel level) {
        SyncRequest sr = new SyncRequest();
        sr.instance = this.instanceName;
        sr.dir = dir;
        File fdir = new File(this.instanceDir, dir);
        if (!fdir.exists()) {
            return sr;
        }
        this.getFileModTimes(fdir, fdir, sr, level);
        return sr;
    }

    private void getFileModTimes(File dir, File baseDir, SyncRequest sr, SyncLevel level) {
        if (level == SyncLevel.TOP) {
            long time = dir.lastModified();
            SyncRequest.ModTime mt = new SyncRequest.ModTime(".", time);
            sr.files.add(mt);
            return;
        }
        for (String file : dir.list()) {
            String name;
            File f = new File(dir, file);
            long time = f.lastModified();
            if (time == 0L) continue;
            if (f.isDirectory()) {
                if (level == SyncLevel.RECURSIVE) {
                    this.getFileModTimes(f, baseDir, sr, level);
                    continue;
                }
                if (level == SyncLevel.FILES) continue;
            }
            if ((name = baseDir.toURI().relativize(f.toURI()).getPath()).endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            SyncRequest.ModTime mt = new SyncRequest.ModTime(name, time);
            sr.files.add(mt);
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer(f + ": mod time " + mt.time);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void synchronizeFiles(SyncRequest sr) throws CommandException, ConnectException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("mt.", ".xml");
            tempFile.deleteOnExit();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SyncRequest.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)sr, tempFile);
            if (logger.isLoggable(Level.FINER)) {
                marshaller.marshal((Object)sr, (OutputStream)System.out);
            }
            File syncdir = new File(this.instanceDir, sr.dir);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Sync directory: " + syncdir);
            }
            this.syncCmd.executeAndReturnOutput(new String[]{"_synchronize-files", tempFile.getPath()});
            if (tempFile == null) return;
            if (tempFile.delete()) return;
        }
        catch (IOException ex) {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Got exception: " + ex);
                }
                throw new CommandException(Strings.get("Sync.dirFailed", sr.dir, ex.toString()), (Throwable)ex);
                catch (JAXBException jex) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Got exception: " + jex);
                    }
                    throw new CommandException(Strings.get("Sync.dirFailed", sr.dir, jex.toString()), (Throwable)jex);
                }
                catch (CommandException cex) {
                    Throwable cause = cex.getCause();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Got exception: " + cex);
                        logger.finer("  cause: " + cause);
                    }
                    if (cause instanceof ConnectException) {
                        throw (ConnectException)cause;
                    }
                    throw new CommandException(Strings.get("Sync.dirFailed", sr.dir, cex.getMessage()), (Throwable)cex);
                }
            }
            catch (Throwable throwable) {
                if (tempFile == null) throw throwable;
                if (tempFile.delete()) throw throwable;
                logger.warning(Strings.get("Sync.cantDeleteTempFile", tempFile));
                throw throwable;
            }
        }
        logger.warning(Strings.get("Sync.cantDeleteTempFile", tempFile));
    }

    private void removeSubdirectory(String name) {
        File subdir = new File(this.instanceDir, name);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Removing: " + subdir);
        }
        FileUtils.whack((File)subdir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(File dir, File archive) throws Exception {
        if (!dir.mkdir()) {
            logger.warning(Strings.get("Sync.cantCreateDirectory", dir));
        }
        long modtime = archive.lastModified();
        ZipFile zf = new ZipFile(archive);
        try {
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                File entry = new File(dir, ze.getName());
                if (ze.isDirectory()) {
                    if (entry.mkdir()) continue;
                    logger.warning(Strings.get("Sync.cantCreateDirectory", dir));
                    continue;
                }
                FileUtils.copy((InputStream)zf.getInputStream(ze), (FileOutputStream)new FileOutputStream(entry), (long)0L);
            }
        }
        finally {
            try {
                zf.close();
            }
            catch (IOException iOException) {}
        }
        if (!dir.setLastModified(modtime)) {
            logger.warning(Strings.get("Sync.cantSetModTime", dir));
        }
    }

    private static enum SyncLevel {
        TOP,
        FILES,
        DIRECTORY,
        RECURSIVE;

    }
}

