/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.cache;

import com.sun.enterprise.admin.util.cache.AdminCache;
import com.sun.enterprise.admin.util.cache.AdminCacheFileStore;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AdminCacheWeakReference
implements AdminCache {
    private static final AdminCacheWeakReference instance = new AdminCacheWeakReference();
    private AdminCacheFileStore fileCache = AdminCacheFileStore.getInstance();
    private final Map<String, CachedItem> cache = new HashMap<String, CachedItem>();

    private AdminCacheWeakReference() {
    }

    @Override
    public <A> A get(String key, Class<A> clazz) {
        Object obj;
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Attribute clazz can not be null.");
        }
        CachedItem cachedItem = this.cache.get(key);
        if (cachedItem != null && (obj = cachedItem.getItem()) != null && clazz.isAssignableFrom(obj.getClass())) {
            return (A)obj;
        }
        A item = this.fileCache.get(key, clazz);
        if (item != null) {
            if (cachedItem == null) {
                this.cache.put(key, new CachedItem(item));
            } else {
                cachedItem.setItem(item);
            }
        } else {
            this.cache.remove(key);
        }
        return item;
    }

    @Override
    public void put(String key, Object data) {
        this.fileCache.put(key, data);
        this.cache.put(key, new CachedItem(data, new Date()));
    }

    @Override
    public boolean contains(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        CachedItem item = this.cache.get(key);
        if (item != null) {
            return true;
        }
        boolean result = this.fileCache.contains(key);
        if (result) {
            this.cache.put(key, new CachedItem(null));
        }
        return result;
    }

    @Override
    public Date lastUpdated(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        CachedItem item = this.cache.get(key);
        if (item != null && item.lastUpdateInStore != null) {
            return item.lastUpdateInStore;
        }
        Date result = this.fileCache.lastUpdated(key);
        if (result != null) {
            if (item == null) {
                this.cache.put(key, new CachedItem(result));
            } else {
                if (item.updated != -1L && item.updated < result.getTime()) {
                    item.setItem(null);
                }
                item.lastUpdateInStore = result;
            }
        }
        return result;
    }

    public static AdminCacheWeakReference getInstance() {
        return instance;
    }

    private static final class CachedItem {
        private WeakReference item;
        private long updated = -1L;
        private Date lastUpdateInStore;

        private CachedItem(Object item) {
            this.setItem(item);
        }

        private CachedItem(Object item, Date lastUpdateInStore) {
            this.setItem(item);
            this.lastUpdateInStore = lastUpdateInStore;
        }

        private CachedItem(Date lastUpdateInStore) {
            this.lastUpdateInStore = lastUpdateInStore;
        }

        public Object getItem() {
            if (this.item == null) {
                return null;
            }
            return this.item.get();
        }

        public void setItem(Object item) {
            this.item = item == null ? null : new WeakReference<Object>(item);
            this.updated = System.currentTimeMillis();
        }

        public Date getLastUpdateInStore() {
            return this.lastUpdateInStore;
        }

        public void setLastUpdateInStore(Date lastUpdateInStore) {
            this.lastUpdateInStore = lastUpdateInStore;
        }

        public long getUpdated() {
            return this.updated;
        }
    }
}

