/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DbfFactory {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String AS_INSTALL_ROOT = "com.sun.aas.installRoot";
    private static final String AS_SCHEMA_DIR = System.getProperty("com.sun.aas.installRoot") + File.separatorChar + "lib" + File.separatorChar + "schemas" + File.separatorChar;
    private static final String AS_DTD_DIR = System.getProperty("com.sun.aas.installRoot") + File.separatorChar + "lib" + File.separatorChar + "dtds" + File.separatorChar;
    private static final String FACELET_TAGLIB_2_0_XSD = "/com/sun/faces/web-facelettaglibrary_2_0.xsd";
    private static final String FACELET_TAGLIB_2_2_XSD = "/com/sun/faces/web-facelettaglibrary_2_2.xsd";
    private static final String FACELET_TAGLIB_3_0_XSD = "/com/sun/faces/web-facelettaglibrary_3_0.xsd";
    private static final String FACES_2_0_XSD = "/com/sun/faces/web-facesconfig_2_0.xsd";
    private static final String FACES_2_1_XSD = "/com/sun/faces/web-facesconfig_2_1.xsd";
    private static final String FACES_2_2_XSD = "/com/sun/faces/web-facesconfig_2_2.xsd";
    private static final String FACES_2_3_XSD = "/com/sun/faces/web-facesconfig_2_3.xsd";
    private static final String FACES_3_0_XSD = "/com/sun/faces/web-facesconfig_3_0.xsd";
    private static final String FACES_1_2_XSD = "/com/sun/faces/web-facesconfig_1_2.xsd";
    private static final String FACES_1_1_XSD = "/com/sun/faces/web-facesconfig_1_1.xsd";
    private static final String FACELET_TAGLIB_2_0_XSD_FILE = AS_SCHEMA_DIR + "web-facelettaglibrary_2_0.xsd";
    private static final String FACELET_TAGLIB_2_2_XSD_FILE = AS_SCHEMA_DIR + "web-facelettaglibrary_2_2.xsd";
    private static final String FACELET_TAGLIB_3_0_XSD_FILE = AS_SCHEMA_DIR + "web-facelettaglibrary_3_0.xsd";
    private static final String FACES_2_0_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_2_0.xsd";
    private static final String FACES_2_1_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_2_1.xsd";
    private static final String FACES_2_2_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_2_2.xsd";
    private static final String FACES_2_3_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_2_3.xsd";
    private static final String FACES_3_0_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_3_0.xsd";
    private static final String FACES_1_2_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_1_2.xsd";
    public static final EntityResolver FACES_ENTITY_RESOLVER = new FacesEntityResolver();
    private static final String SCHEMA_MAP = "com.sun.faces.config.schemaMap";
    public static final FacesErrorHandler FACES_ERROR_HANDLER = new FacesErrorHandler();

    public static DocumentBuilderFactory getFactory() {
        DocumentBuilderFactory factory = Util.createDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        return factory;
    }

    public static Schema getSchema(ServletContext servletContext, FacesSchema schemaId) {
        Map<FacesSchema, Schema> schemaMap = DbfFactory.getSchemaMap(servletContext);
        if (!schemaMap.containsKey((Object)schemaId)) {
            DbfFactory.loadSchema(schemaMap, schemaId);
        }
        return schemaMap.get((Object)schemaId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<FacesSchema, Schema> getSchemaMap(ServletContext servletContext) {
        Map schemaMap = (Map)servletContext.getAttribute(SCHEMA_MAP);
        if (schemaMap == null) {
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                schemaMap = Collections.synchronizedMap(new EnumMap(FacesSchema.class));
                servletContext.setAttribute(SCHEMA_MAP, schemaMap);
            }
        }
        return schemaMap;
    }

    public static void removeSchemaMap(ServletContext servletContext) {
        servletContext.removeAttribute(SCHEMA_MAP);
    }

    private static void loadSchema(Map<FacesSchema, Schema> schemaMap, FacesSchema schemaId) {
        try {
            switch (schemaId) {
                case FACES_12: {
                    URL url = DbfFactory.class.getResource(FACES_1_2_XSD);
                    if (url == null) {
                        File f = new File(FACES_1_2_XSD_FILE);
                        if (!f.exists()) {
                            throw new IllegalStateException("Unable to find web-facesconfig_1_2.xsd");
                        }
                        url = f.toURI().toURL();
                    }
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream in = conn.getInputStream();
                    SchemaFactory factory = Util.createSchemaFactory("http://www.w3.org/2001/XMLSchema");
                    factory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
                    Schema schema = factory.newSchema(new StreamSource(in));
                    schemaMap.put(schemaId, schema);
                    break;
                }
                case FACES_11: {
                    URL url = DbfFactory.class.getResource(FACES_1_1_XSD);
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream in = conn.getInputStream();
                    SchemaFactory factory = Util.createSchemaFactory("http://www.w3.org/2001/XMLSchema");
                    factory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
                    Schema schema = factory.newSchema(new StreamSource(in));
                    schemaMap.put(schemaId, schema);
                    break;
                }
                case FACES_21: {
                    URL url = DbfFactory.class.getResource(FACES_2_1_XSD);
                    if (url == null) {
                        File f = new File(FACES_2_1_XSD_FILE);
                        if (!f.exists()) {
                            throw new IllegalStateException("Unable to find web-facesconfig_2_1.xsd");
                        }
                        url = f.toURI().toURL();
                    }
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream in = conn.getInputStream();
                    SchemaFactory factory = Util.createSchemaFactory("http://www.w3.org/2001/XMLSchema");
                    factory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
                    Schema schema = factory.newSchema(new StreamSource(in));
                    schemaMap.put(schemaId, schema);
                    break;
                }
                case FACES_22: {
                    URL url = DbfFactory.class.getResource(FACES_2_2_XSD);
                    if (url == null) {
                        File f = new File(FACES_2_2_XSD_FILE);
                        if (!f.exists()) {
                            throw new IllegalStateException("Unable to find web-facesconfig_2_2.xsd");
                        }
                        url = f.toURI().toURL();
                    }
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream in = conn.getInputStream();
                    SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    factory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
                    Schema schema = factory.newSchema(new StreamSource(in));
                    schemaMap.put(schemaId, schema);
                    break;
                }
                case FACES_23: {
                    URL url = DbfFactory.class.getResource(FACES_2_3_XSD);
                    if (url == null) {
                        File f = new File(FACES_2_3_XSD_FILE);
                        if (!f.exists()) {
                            throw new IllegalStateException("Unable to find web-facesconfig_2_3.xsd");
                        }
                        url = f.toURI().toURL();
                    }
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream in = conn.getInputStream();
                    SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    factory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
                    Schema schema = factory.newSchema(new StreamSource(in));
                    schemaMap.put(schemaId, schema);
                    break;
                }
                case FACES_30: {
                    URL url = DbfFactory.class.getResource(FACES_3_0_XSD);
                    if (url == null) {
                        File f = new File(FACES_3_0_XSD_FILE);
                        if (!f.exists()) {
                            throw new IllegalStateException("Unable to find web-facesconfig_3_0.xsd");
                        }
                        url = f.toURI().toURL();
                    }
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream in = conn.getInputStream();
                    SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    factory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
                    Schema schema = factory.newSchema(new StreamSource(in));
                    schemaMap.put(schemaId, schema);
                    break;
                }
                case FACES_20: {
                    URL url = DbfFactory.class.getResource(FACES_2_0_XSD);
                    if (url == null) {
                        File f = new File(FACES_2_0_XSD_FILE);
                        if (!f.exists()) {
                            throw new IllegalStateException("Unable to find web-facesconfig_2_0.xsd");
                        }
                        url = f.toURI().toURL();
                    }
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream in = conn.getInputStream();
                    SchemaFactory factory = Util.createSchemaFactory("http://www.w3.org/2001/XMLSchema");
                    factory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
                    Schema schema = factory.newSchema(new StreamSource(in));
                    schemaMap.put(schemaId, schema);
                    break;
                }
                case FACELET_TAGLIB_20: {
                    URL url = DbfFactory.class.getResource(FACELET_TAGLIB_2_0_XSD);
                    if (url == null) {
                        File f = new File(FACELET_TAGLIB_2_0_XSD_FILE);
                        if (!f.exists()) {
                            throw new IllegalStateException("Unable to find web-facelettaglibrary_2_0.xsd");
                        }
                        url = f.toURI().toURL();
                    }
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream in = conn.getInputStream();
                    SchemaFactory factory = Util.createSchemaFactory("http://www.w3.org/2001/XMLSchema");
                    factory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
                    Schema schema = factory.newSchema(new StreamSource(in));
                    schemaMap.put(schemaId, schema);
                    break;
                }
                case FACELET_TAGLIB_22: {
                    URL url = DbfFactory.class.getResource(FACELET_TAGLIB_2_2_XSD);
                    if (url == null) {
                        File f = new File(FACELET_TAGLIB_2_2_XSD_FILE);
                        if (!f.exists()) {
                            throw new IllegalStateException("Unable to find web-facelettaglibrary_2_2.xsd");
                        }
                        url = f.toURI().toURL();
                    }
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream in = conn.getInputStream();
                    SchemaFactory factory = Util.createSchemaFactory("http://www.w3.org/2001/XMLSchema");
                    factory.setResourceResolver((LSResourceResolver)((Object)FACES_ENTITY_RESOLVER));
                    Schema schema = factory.newSchema(new StreamSource(in));
                    schemaMap.put(schemaId, schema);
                    break;
                }
                default: {
                    throw new ConfigurationException("Unrecognized Faces Version: " + schemaId.toString());
                }
            }
        }
        catch (ConfigurationException | IOException | IllegalStateException | SAXException e) {
            throw new ConfigurationException(e);
        }
    }

    static /* synthetic */ String access$100() {
        return AS_DTD_DIR;
    }

    static /* synthetic */ String access$200() {
        return FACES_2_0_XSD_FILE;
    }

    static /* synthetic */ String access$300() {
        return FACES_2_1_XSD_FILE;
    }

    static /* synthetic */ String access$400() {
        return FACES_2_2_XSD_FILE;
    }

    static /* synthetic */ String access$500() {
        return FACES_2_3_XSD_FILE;
    }

    static /* synthetic */ String access$600() {
        return FACES_3_0_XSD_FILE;
    }

    static /* synthetic */ String access$700() {
        return FACELET_TAGLIB_2_0_XSD_FILE;
    }

    static /* synthetic */ String access$800() {
        return FACELET_TAGLIB_3_0_XSD_FILE;
    }

    static /* synthetic */ String access$900() {
        return FACES_1_2_XSD_FILE;
    }

    static /* synthetic */ String access$1000() {
        return AS_SCHEMA_DIR;
    }

    private static final class Input
    implements LSInput {
        InputStream in;

        public Input(InputStream in) {
            this.in = in;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public InputStream getByteStream() {
            return this.in;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }
    }

    private static class FacesErrorHandler
    implements ErrorHandler {
        private FacesErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    private static class FacesEntityResolver
    extends DefaultHandler
    implements LSResourceResolver {
        private static final String[][] DTD_SCHEMA_INFO = new String[][]{{"web-facesconfig_1_0.dtd", "/com/sun/faces/web-facesconfig_1_0.dtd", DbfFactory.access$100() + "web-facesconfig_1_0.dtd"}, {"web-facesconfig_1_1.dtd", "/com/sun/faces/web-facesconfig_1_1.dtd", DbfFactory.access$100() + "web-facesconfig_1_1.dtd"}, {"web-facesconfig_2_0.xsd", "/com/sun/faces/web-facesconfig_2_0.xsd", DbfFactory.access$200()}, {"web-facesconfig_2_1.xsd", "/com/sun/faces/web-facesconfig_2_1.xsd", DbfFactory.access$300()}, {"web-facesconfig_2_2.xsd", "/com/sun/faces/web-facesconfig_2_2.xsd", DbfFactory.access$400()}, {"web-facesconfig_2_3.xsd", "/com/sun/faces/web-facesconfig_2_3.xsd", DbfFactory.access$500()}, {"web-facesconfig_3_0.xsd", "/com/sun/faces/web-facesconfig_3_0.xsd", DbfFactory.access$600()}, {"facelet-taglib_1_0.dtd", "/com/sun/faces/facelet-taglib_1_0.dtd", null}, {"web-facelettaglibrary_2_0.xsd", "/com/sun/faces/web-facelettaglibrary_2_0.xsd", DbfFactory.access$700()}, {"web-facelettaglibrary_3_0.xsd", "/com/sun/faces/web-facelettaglibrary_3_0.xsd", DbfFactory.access$800()}, {"web-facesconfig_1_2.xsd", "/com/sun/faces/web-facesconfig_1_2.xsd", DbfFactory.access$900()}, {"web-facesconfig_1_1.xsd", "/com/sun/faces/web-facesconfig_1_1.xsd", null}, {"javaee_5.xsd", "/com/sun/faces/javaee_5.xsd", DbfFactory.access$1000() + "javaee_5.xsd"}, {"javaee_6.xsd", "/com/sun/faces/javaee_6.xsd", DbfFactory.access$1000() + "javaee_6.xsd"}, {"javaee_7.xsd", "/com/sun/faces/javaee_7.xsd", DbfFactory.access$1000() + "javaee_7.xsd"}, {"javaee_8.xsd", "/com/sun/faces/javaee_8.xsd", DbfFactory.access$1000() + "javaee_8.xsd"}, {"jakartaee_9.xsd", "/com/sun/faces/jakartaee_9.xsd", DbfFactory.access$1000() + "jakartaee_9.xsd"}, {"javaee_web_services_client_1_2.xsd", "/com/sun/faces/javaee_web_services_client_1_2.xsd", DbfFactory.access$1000() + "javaee_web_services_client_1_2.xsd"}, {"javaee_web_services_client_1_3.xsd", "/com/sun/faces/javaee_web_services_client_1_3.xsd", DbfFactory.access$1000() + "javaee_web_services_client_1_3.xsd"}, {"javaee_web_services_client_1_4.xsd", "/com/sun/faces/javaee_web_services_client_1_4.xsd", DbfFactory.access$1000() + "javaee_web_services_client_1_4.xsd"}, {"jakartaee_web_services_client_2_0.xsd", "/com/sun/faces/jakartaee_web_services_client_2_0.xsd", DbfFactory.access$1000() + "jakartaee_web_services_client_2_0.xsd"}, {"xml.xsd", "/com/sun/faces/xml.xsd", DbfFactory.access$1000() + "xml.xsd"}, {"datatypes.dtd", "/com/sun/faces/datatypes.dtd", DbfFactory.access$1000() + "datatypes.dtd"}, {"XMLSchema.dtd", "/com/sun/faces/XMLSchema.dtd", DbfFactory.access$1000() + "XMLSchema.dtd"}};
        private HashMap<String, String> entities = new HashMap(12, 1.0f);

        public FacesEntityResolver() {
            for (String[] aDTD_SCHEMA_INFO : DTD_SCHEMA_INFO) {
                URL url = this.getClass().getResource(aDTD_SCHEMA_INFO[1]);
                if (url == null) {
                    block6: {
                        File f;
                        String path;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "jsf.config.cannot_resolve_entities", new Object[]{aDTD_SCHEMA_INFO[1], aDTD_SCHEMA_INFO[0]});
                        }
                        if ((path = aDTD_SCHEMA_INFO[2]) == null || !(f = new File(path)).exists()) continue;
                        try {
                            url = f.toURI().toURL();
                        }
                        catch (MalformedURLException mue) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                            LOGGER.log(Level.SEVERE, mue.toString(), mue);
                        }
                    }
                    if (url == null) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.log(Level.FINE, "jsf.config.cannot_resolve_entities", new Object[]{aDTD_SCHEMA_INFO[1], aDTD_SCHEMA_INFO[2]});
                        continue;
                    }
                    this.entities.put(aDTD_SCHEMA_INFO[0], url.toString());
                    continue;
                }
                this.entities.put(aDTD_SCHEMA_INFO[0], url.toString());
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            InputSource source;
            if (systemId == null) {
                InputSource result;
                try {
                    result = super.resolveEntity(publicId, null);
                }
                catch (IOException | SAXException e) {
                    throw new SAXException(e);
                }
                return result;
            }
            String grammarName = systemId.substring(systemId.lastIndexOf(47) + 1);
            String entityURL = this.entities.get(grammarName);
            if (entityURL == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unknown entity, deferring to superclass.");
                }
                try {
                    source = super.resolveEntity(publicId, systemId);
                }
                catch (IOException | SAXException e) {
                    throw new SAXException(e);
                }
            }
            try {
                source = new InputSource(new URL(entityURL).openStream());
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.config.cannot_create_inputsource", entityURL);
                }
                source = null;
            }
            if (source != null) {
                source.setSystemId(entityURL);
                if (publicId != null) {
                    source.setPublicId(publicId);
                }
            }
            return source;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                InputSource source = this.resolveEntity(publicId, systemId);
                if (source != null) {
                    return new Input(source.getByteStream());
                }
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            return null;
        }
    }

    public static enum FacesSchema {
        FACES_20,
        FACES_21,
        FACES_22,
        FACES_23,
        FACES_30,
        FACES_12,
        FACES_11,
        FACELET_TAGLIB_20,
        FACELET_TAGLIB_22;

    }
}

