/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.util.FacesLogger;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class ZipDirectoryEntryScanner {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final String PREFIX = "META-INF/resources";
    private static final int PREFIX_LENGTH = "META-INF/resources".length();
    Map<String, Boolean> resourceLibraries;

    ZipDirectoryEntryScanner() {
        ExternalContext extContext = FacesContext.getCurrentInstance().getExternalContext();
        Set<String> webInfLibJars = extContext.getResourcePaths("/WEB-INF/lib");
        this.resourceLibraries = new ConcurrentHashMap<String, Boolean>();
        ZipEntry ze = null;
        String entryName = null;
        if (webInfLibJars != null) {
            for (String cur : webInfLibJars) {
                try {
                    ZipInputStream zis = new ZipInputStream(extContext.getResourceAsStream(cur));
                    Throwable throwable = null;
                    try {
                        while (null != (ze = zis.getNextEntry())) {
                            int i;
                            entryName = ze.getName();
                            if (!entryName.startsWith(PREFIX) || PREFIX_LENGTH >= entryName.length() || (entryName = entryName.substring(PREFIX_LENGTH + 1)).endsWith("/") || -1 == (i = entryName.lastIndexOf("/")) || this.resourceLibraries.containsKey(entryName = entryName.substring(0, i))) continue;
                            this.resourceLibraries.put(entryName, Boolean.TRUE);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (zis == null) continue;
                        if (throwable != null) {
                            try {
                                zis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        zis.close();
                    }
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to inspect resource library " + cur, ioe);
                }
            }
        }
        Iterator<String> iter = this.resourceLibraries.keySet().iterator();
        while (iter.hasNext()) {
            String cur;
            cur = iter.next();
            if (!cur.contains("/")) continue;
            iter.remove();
        }
    }

    boolean libraryExists(String libraryName, String localePrefix) {
        String key = localePrefix != null ? localePrefix + "/" + libraryName : libraryName;
        return this.resourceLibraries.containsKey(key);
    }
}

