/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.resolution;

import java.util.Set;
import javax.validation.ConstraintDeclarationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.ContainerElementEntity1;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.ContainerElementEntity2;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.ContainerElementEntity3;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper11;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper111;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper21;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper211;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper212;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper22;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.IWrapper221;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.Wrapper1;
import org.hibernate.beanvalidation.tck.tests.valueextraction.resolution.model.Wrapper2;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ContainerElementValueExtractorResolutionAlgorithmTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ContainerElementValueExtractorResolutionAlgorithmTest.webArchiveBuilder().withTestClass(ContainerElementValueExtractorResolutionAlgorithmTest.class)).withPackage(IWrapper11.class.getPackage())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-constraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-constraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-constraints", id="d")})
    public void mostSpecificValueExtractorFound() {
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new IWrapper11ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper111ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper111ValueExtractor1()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)new ContainerElementEntity1(null, 4L), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("wrapper").containerElement("IWrapper11-0", false, null, null, Wrapper1.class, 0));
        violations = validator.validate((Object)new ContainerElementEntity1("string", null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("wrapper").containerElement("IWrapper111-1", false, null, null, Wrapper1.class, 1));
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-constraints", id="c")
    public void customGenericTypeWithContainerElementConstraintButNoValueExtractorThrowsException() {
        this.getValidator().validate((Object)new ContainerElementEntity1(null, 4L), new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-constraints", id="e")
    public void parallelValueExtractorDefinitionsCausesException() {
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new IWrapper21ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper211ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper212ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper22ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper221ValueExtractor0()).buildValidatorFactory().getValidator();
        validator.validate((Object)new ContainerElementEntity2(null, null), new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-constraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-constraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-constraints", id="d")})
    public void parallelValueExtractorDefinitionsIsOKIfOnlyOneMaximallySpecific() {
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new IWrapper21ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper211ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper212ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper22ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper221ValueExtractor0()).addValueExtractor((ValueExtractor)new Wrapper2ValueExtractor0()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)new ContainerElementEntity2(null, 4L), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("wrapper").containerElement("Wrapper2-0", false, null, null, Wrapper2.class, 0));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-constraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-constraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-algorithm-constraints", id="d")})
    public void declaringTypeIsConsideredAndNotRuntimeType() {
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new IWrapper21ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper211ValueExtractor0()).addValueExtractor((ValueExtractor)new IWrapper212ValueExtractor0()).addValueExtractor((ValueExtractor)new Wrapper2ValueExtractor0()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)new ContainerElementEntity3(null, 4L), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("wrapper").containerElement("IWrapper21-0", false, null, null, IWrapper21.class, 0));
    }

    private static class Wrapper2ValueExtractor0
    implements ValueExtractor<Wrapper2<?, ?>> {
        private Wrapper2ValueExtractor0() {
        }

        public void extractValues(Wrapper2<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("Wrapper2-0", originalValue.getProperty1());
        }
    }

    private static class IWrapper221ValueExtractor0
    implements ValueExtractor<IWrapper221<?, ?>> {
        private IWrapper221ValueExtractor0() {
        }

        public void extractValues(IWrapper221<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper221-0", originalValue.getProperty1());
        }
    }

    private static class IWrapper22ValueExtractor0
    implements ValueExtractor<IWrapper22<?, ?>> {
        private IWrapper22ValueExtractor0() {
        }

        public void extractValues(IWrapper22<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper22-0", originalValue.getProperty1());
        }
    }

    private static class IWrapper212ValueExtractor0
    implements ValueExtractor<IWrapper212<?, ?>> {
        private IWrapper212ValueExtractor0() {
        }

        public void extractValues(IWrapper212<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper212-0", originalValue.getProperty1());
        }
    }

    private static class IWrapper211ValueExtractor0
    implements ValueExtractor<IWrapper211<?, ?>> {
        private IWrapper211ValueExtractor0() {
        }

        public void extractValues(IWrapper211<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper211-0", originalValue.getProperty1());
        }
    }

    private static class IWrapper21ValueExtractor0
    implements ValueExtractor<IWrapper21<?, ?>> {
        private IWrapper21ValueExtractor0() {
        }

        public void extractValues(IWrapper21<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper21-0", originalValue.getProperty1());
        }
    }

    private static class IWrapper111ValueExtractor1
    implements ValueExtractor<IWrapper111<?, ?>> {
        private IWrapper111ValueExtractor1() {
        }

        public void extractValues(IWrapper111<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper111-1", originalValue.getProperty2());
        }
    }

    private static class IWrapper111ValueExtractor0
    implements ValueExtractor<IWrapper111<?, ?>> {
        private IWrapper111ValueExtractor0() {
        }

        public void extractValues(IWrapper111<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper111-0", originalValue.getProperty1());
        }
    }

    private static class IWrapper11ValueExtractor0
    implements ValueExtractor<IWrapper11<?, ?>> {
        private IWrapper11ValueExtractor0() {
        }

        public void extractValues(IWrapper11<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value("IWrapper11-0", originalValue.getProperty1());
        }
    }
}

