/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.common.ui.DialogUtils;
import org.eclipse.emf.edapt.declaration.Library;
import org.eclipse.emf.edapt.declaration.LibraryImplementation;
import org.eclipse.emf.edapt.declaration.Operation;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.common.FileUtils;
import org.eclipse.emf.edapt.internal.common.LoggingUtils;
import org.eclipse.emf.edapt.internal.common.ResourceUtils;
import org.eclipse.emf.edapt.internal.common.URIUtils;
import org.eclipse.emf.edapt.internal.declaration.OperationRegistry;
import org.eclipse.emf.edapt.internal.migration.execution.ValidationLevel;
import org.eclipse.emf.edapt.internal.migration.execution.internal.MigratorCommandLine;
import org.eclipse.emf.edapt.internal.migration.execution.internal.MigratorCommandLineOption;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.ui.MigrationUIActivator;
import org.eclipse.jdt.launching.JavaLaunchDelegate;

public class MigrationLaunchConfigurationDelegate
extends JavaLaunchDelegate {
    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String historyFilename = configuration.getAttribute(MigratorCommandLineOption.HISTORY.id(), null);
        if (historyFilename == null) {
            DialogUtils.openErrorDialogAsync((String)"Error", (String)"Could not determine history.");
            return false;
        }
        IFile historyFile = FileUtils.getFile((String)historyFilename);
        if (!historyFile.exists()) {
            DialogUtils.openErrorDialogAsync((String)"Error", (String)("History " + historyFilename + " does not exist."));
            return false;
        }
        URI uri = URIUtils.getURI((IResource)historyFile);
        try {
            ResourceUtils.loadElement((URI)uri);
        }
        catch (IOException e) {
            DialogUtils.openErrorDialogAsync((String)"Error", (String)("Could not load history " + historyFilename + ": " + e.getMessage()));
            return false;
        }
        List<IFile> modelFiles = this.getModelFiles(configuration);
        for (IFile modelFile : modelFiles) {
            if (modelFile.exists()) continue;
            DialogUtils.openErrorDialogAsync((String)"Error", (String)("Model " + modelFile.getLocation().toString() + " does not exist."));
            return false;
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    private List<IFile> getModelFiles(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        List modelURIs = configuration.getAttribute(MigratorCommandLineOption.MODELS.id(), Collections.emptyList());
        for (String modelURI : modelURIs) {
            IFile file = FileUtils.getFile((String)modelURI);
            files.add(file);
        }
        return files;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchesListener)new LaunchTerminationListener(configuration, launch, monitor));
        super.launch(configuration, mode, launch, monitor);
    }

    public String getMainTypeName(ILaunchConfiguration configuration) {
        return Migrator.class.getName();
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        List<URI> modelURIs = this.getModelURIs(configuration);
        URI historyURI = this.getHistoryURI(configuration);
        int sourceReleaseNumber = this.getSourceReleaseNumber(configuration);
        int targetReleaseNumber = this.getTargetReleaseNumber(configuration);
        ValidationLevel level = this.getValidationLevel(configuration);
        boolean backup = this.isBackup(configuration);
        List<Class<? extends LibraryImplementation>> libraries = this.getLibraries();
        List<Class<? extends OperationImplementation>> operations = this.getOperations();
        MigratorCommandLine commandLine = new MigratorCommandLine(historyURI, modelURIs, sourceReleaseNumber, targetReleaseNumber, level, backup, libraries, operations);
        String argument = commandLine.getCommandLine();
        String vmArguments = configuration.getAttribute(MigratorCommandLineOption.VM_ARGUMENTS.id(), "");
        argument = String.valueOf(argument) + " " + vmArguments;
        return argument;
    }

    private List<URI> getModelURIs(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<URI> modelURIs = new ArrayList<URI>();
        List<IFile> modelFiles = this.getModelFiles(configuration);
        for (IFile modelFile : modelFiles) {
            modelURIs.add(URIUtils.getURI((String)modelFile.getLocation().toString()));
        }
        return modelURIs;
    }

    private URI getHistoryURI(ILaunchConfiguration configuration) throws CoreException {
        String historyFilename = configuration.getAttribute(MigratorCommandLineOption.HISTORY.id(), "");
        IFile file = FileUtils.getFile((String)historyFilename);
        URI historyURI = URIUtils.getURI((String)file.getLocation().toString());
        return historyURI;
    }

    private int getSourceReleaseNumber(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(MigratorCommandLineOption.SOURCE_RELEASE.id(), -1);
    }

    private int getTargetReleaseNumber(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(MigratorCommandLineOption.TARGET_RELEASE.id(), -1);
    }

    private ValidationLevel getValidationLevel(ILaunchConfiguration configuration) throws CoreException {
        return ValidationLevel.valueOf((String)configuration.getAttribute(MigratorCommandLineOption.VALIDATION_LEVEL.id(), ValidationLevel.CUSTOM_MIGRATION.toString()));
    }

    private boolean isBackup(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(MigratorCommandLineOption.BACKUP.id(), false);
    }

    private List<Class<? extends LibraryImplementation>> getLibraries() {
        OperationRegistry registry = OperationRegistry.getInstance();
        ArrayList<Class<? extends LibraryImplementation>> libraries = new ArrayList<Class<? extends LibraryImplementation>>();
        for (Library library : registry.getRootLibraries()) {
            libraries.add(library.getImplementation());
        }
        return libraries;
    }

    private List<Class<? extends OperationImplementation>> getOperations() {
        OperationRegistry registry = OperationRegistry.getInstance();
        ArrayList<Class<? extends OperationImplementation>> operations = new ArrayList<Class<? extends OperationImplementation>>();
        for (Operation operation : registry.getRootOperations()) {
            operations.add(operation.getImplementation());
        }
        return operations;
    }

    private class LaunchTerminationListener
    implements ILaunchesListener2 {
        private final ILaunchConfiguration configuration;
        private final ILaunch launch;
        private final IProgressMonitor monitor;

        public LaunchTerminationListener(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) {
            this.configuration = configuration;
            this.launch = launch;
            this.monitor = monitor;
        }

        public void launchesRemoved(ILaunch[] launches) {
            this.refreshModelsWhenTerminated();
        }

        public void launchesChanged(ILaunch[] launches) {
            this.refreshModelsWhenTerminated();
        }

        public void launchesAdded(ILaunch[] launches) {
            this.refreshModelsWhenTerminated();
        }

        private void refreshModelsWhenTerminated() {
            if (this.launch.isTerminated()) {
                this.refreshModels();
            }
        }

        public void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch l = iLaunchArray[n2];
                if (l == this.launch) {
                    this.refreshModels();
                }
                ++n2;
            }
        }

        private void refreshModels() {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        while (!LaunchTerminationListener.this.launch.isTerminated()) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException e) {
                        LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
                    }
                    List modelFiles = MigrationLaunchConfigurationDelegate.this.getModelFiles(LaunchTerminationListener.this.configuration);
                    for (IFile modelFile : modelFiles) {
                        modelFile.getParent().refreshLocal(2, monitor);
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(operation, this.monitor);
            }
            catch (CoreException e) {
                LoggingUtils.logError((Plugin)MigrationUIActivator.getDefault(), (Throwable)e);
            }
        }
    }
}

