/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.URLResource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;

public class ImportTask
extends Task {
    private String file;
    private boolean optional;
    private String targetPrefix;
    private String prefixSeparator = ".";
    private final Union resources = new Union();
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    static /* synthetic */ Class class$org$apache$tools$ant$types$resources$FileProvider;

    public ImportTask() {
        this.resources.setCache(true);
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setAs(String prefix) {
        this.targetPrefix = prefix;
    }

    public void setPrefixSeparator(String s) {
        this.prefixSeparator = s;
    }

    public void add(ResourceCollection r) {
        this.resources.add(r);
    }

    public void execute() {
        if (this.file == null && this.resources.size() == 0) {
            throw new BuildException("import requires file attribute or at least one nested resource");
        }
        if (this.getOwningTarget() == null || !"".equals(this.getOwningTarget().getName())) {
            throw new BuildException("import only allowed as a top-level task");
        }
        ProjectHelper helper = (ProjectHelper)this.getProject().getReference("ant.projectHelper");
        if (helper == null) {
            throw new BuildException("import requires support in ProjectHelper");
        }
        Vector importStack = helper.getImportStack();
        if (importStack.size() == 0) {
            throw new BuildException("import requires support in ProjectHelper");
        }
        if (this.getLocation() == null || this.getLocation().getFileName() == null) {
            throw new BuildException("Unable to get location of import task");
        }
        Union resourcesToImport = new Union(this.getProject(), this.resources);
        Resource fromFileAttribute = this.getFileAttributeResource();
        if (fromFileAttribute != null) {
            this.resources.add(fromFileAttribute);
        }
        Iterator i = resourcesToImport.iterator();
        while (i.hasNext()) {
            this.importResource(helper, (Resource)i.next());
        }
    }

    private void importResource(ProjectHelper helper, Resource importedResource) {
        Vector importStack = helper.getImportStack();
        this.getProject().log("Importing file " + importedResource + " from " + this.getLocation().getFileName(), 3);
        if (!importedResource.isExists()) {
            String message = "Cannot find " + importedResource + " imported from " + this.getLocation().getFileName();
            if (this.optional) {
                this.getProject().log(message, 3);
                return;
            }
            throw new BuildException(message);
        }
        File importedFile = null;
        FileProvider fp = (FileProvider)importedResource.as(class$org$apache$tools$ant$types$resources$FileProvider == null ? (class$org$apache$tools$ant$types$resources$FileProvider = ImportTask.class$("org.apache.tools.ant.types.resources.FileProvider")) : class$org$apache$tools$ant$types$resources$FileProvider);
        if (fp != null) {
            importedFile = fp.getFile();
        }
        if (!this.isInIncludeMode() && (importStack.contains(importedResource) || importedFile != null && importStack.contains(importedFile))) {
            this.getProject().log("Skipped already imported file:\n   " + importedResource + "\n", 3);
            return;
        }
        String oldPrefix = ProjectHelper.getCurrentTargetPrefix();
        boolean oldIncludeMode = ProjectHelper.isInIncludeMode();
        String oldSep = ProjectHelper.getCurrentPrefixSeparator();
        try {
            String prefix = this.targetPrefix;
            if (this.isInIncludeMode() && oldPrefix != null && this.targetPrefix != null) {
                prefix = oldPrefix + oldSep + this.targetPrefix;
            }
            ImportTask.setProjectHelperProps(prefix, this.prefixSeparator, this.isInIncludeMode());
            helper.parse(this.getProject(), importedResource);
        }
        catch (BuildException ex) {
            throw ProjectHelper.addLocationToBuildException(ex, this.getLocation());
        }
        finally {
            ImportTask.setProjectHelperProps(oldPrefix, oldSep, oldIncludeMode);
        }
    }

    private Resource getFileAttributeResource() {
        if (this.file != null) {
            File buildFile = new File(this.getLocation().getFileName()).getAbsoluteFile();
            if (buildFile.exists()) {
                File buildFileParent = new File(buildFile.getParent());
                File importedFile = FILE_UTILS.resolveFile(buildFileParent, this.file);
                return new FileResource(importedFile);
            }
            try {
                URL buildFileURL = new URL(this.getLocation().getFileName());
                URL importedFile = new URL(buildFileURL, this.file);
                return new URLResource(importedFile);
            }
            catch (MalformedURLException ex) {
                this.log(ex.toString(), 3);
                throw new BuildException("failed to resolve " + this.file + " relative to " + this.getLocation().getFileName());
            }
        }
        return null;
    }

    protected final boolean isInIncludeMode() {
        return "include".equals(this.getTaskType());
    }

    private static void setProjectHelperProps(String prefix, String prefixSep, boolean inIncludeMode) {
        ProjectHelper.setCurrentTargetPrefix(prefix);
        ProjectHelper.setCurrentPrefixSeparator(prefixSep);
        ProjectHelper.setInIncludeMode(inIncludeMode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

