/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.runtime.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.ease.lang.unittest.execution.ITestExecutionStrategy;
import org.eclipse.ease.lang.unittest.runtime.IRuntimeFactory;
import org.eclipse.ease.lang.unittest.runtime.IRuntimePackage;
import org.eclipse.ease.lang.unittest.runtime.ITest;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.ease.lang.unittest.runtime.impl.TestEntity;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class TestContainer
extends TestEntity
implements ITestContainer {
    protected EList<ITestEntity> children;
    protected static final Object RESOURCE_EDEFAULT = null;
    protected Object resource = RESOURCE_EDEFAULT;

    protected TestContainer() {
    }

    @Override
    protected EClass eStaticClass() {
        return IRuntimePackage.Literals.TEST_CONTAINER;
    }

    public EList<ITestEntity> getChildrenGen() {
        if (this.children == null) {
            this.children = new EObjectContainmentWithInverseEList(ITestEntity.class, (InternalEObject)this, 11, 5);
        }
        return this.children;
    }

    @Override
    public Object getResource() {
        return this.resource;
    }

    @Override
    public void setResource(Object newResource) {
        Object oldResource = this.resource;
        this.resource = newResource;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldResource, this.resource));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITest getTest(String name) {
        for (ITestEntity child : this.getCopyOfChildren()) {
            if (!(child instanceof ITest) || !name.equals(child.getName())) continue;
            return (ITest)child;
        }
        ITest test = IRuntimeFactory.eINSTANCE.createTest();
        test.setName(name);
        test.setEntityStatus(TestStatus.RUNNING);
        TestContainer testContainer = this;
        synchronized (testContainer) {
            this.getChildren().add((Object)test);
        }
        return test;
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getChildren()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getChildren()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getChildren();
            }
            case 12: {
                return this.getResource();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.getChildren().clear();
                this.getChildren().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setResource(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.getChildren().clear();
                return;
            }
            case 12: {
                this.setResource(RESOURCE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.children != null && !this.children.isEmpty();
            }
            case 12: {
                return RESOURCE_EDEFAULT == null ? this.resource != null : !RESOURCE_EDEFAULT.equals(this.resource);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 13: {
                return this.getTest((String)arguments.get(0));
            }
            case 14: {
                return this.getChildContainers();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (resource: ");
        result.append(this.resource);
        result.append(')');
        return result.toString();
    }

    @Override
    public void run(ITestExecutionStrategy strategy) {
        this.setEntityStatus(TestStatus.RUNNING);
        for (ITestContainer child : this.getChildContainers()) {
            if (this.isTerminated()) continue;
            strategy.execute(child);
        }
        this.setEntityStatus(TestStatus.FINISHED);
    }

    @Override
    public EList<ITestContainer> getChildContainers() {
        BasicEList result = new BasicEList();
        for (ITestEntity child : this.getCopyOfChildren()) {
            if (!(child instanceof ITestContainer)) continue;
            result.add((Object)((ITestContainer)child));
        }
        return result;
    }

    @Override
    public TestStatus getStatus() {
        int status = super.getStatus().getValue();
        for (ITestEntity child : this.getCopyOfChildren()) {
            status = Math.max(status, child.getStatus().getValue());
        }
        return TestStatus.get(status);
    }

    @Override
    public boolean hasError() {
        for (ITestEntity child : this.getCopyOfChildren()) {
            if (!child.hasError()) continue;
            return true;
        }
        return super.hasError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        TestContainer testContainer = this;
        synchronized (testContainer) {
            for (ITestEntity child : this.getCopyOfChildren()) {
                if (!(child instanceof ITest)) continue;
                this.getChildren().remove((Object)child);
            }
        }
        super.reset();
    }

    @Override
    public long getEstimatedDuration() {
        long duration = super.getEstimatedDuration();
        List<ITestEntity> children = this.getCopyOfChildren();
        if (duration < 0L && !children.isEmpty()) {
            duration = 0L;
            for (ITestEntity child : children) {
                long childDuration = child.getEstimatedDuration();
                if (childDuration < 0L) {
                    return childDuration;
                }
                duration += childDuration;
            }
            return duration;
        }
        return super.getEstimatedDuration();
    }

    @Override
    public void setTerminated(boolean newTerminated) {
        super.setTerminated(newTerminated);
        for (ITestEntity child : this.getCopyOfChildren()) {
            child.setTerminated(newTerminated);
        }
    }

    @Override
    public synchronized EList<ITestEntity> getChildren() {
        return this.getChildrenGen();
    }

    @Override
    public synchronized List<ITestEntity> getCopyOfChildren() {
        return new ArrayList<ITestEntity>((Collection<ITestEntity>)this.getChildrenGen());
    }
}

