/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.nashorn;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.lang.javascript.JavaScriptHelper;

public class NashornScriptEngine
extends AbstractScriptEngine
implements IScriptEngine {
    private ScriptEngine fEngine;

    public NashornScriptEngine() {
        super("Nashorn");
    }

    public void terminateCurrent() {
    }

    protected Object internalGetVariable(String name) {
        return this.fEngine.get(name);
    }

    protected Map<String, Object> internalGetVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Bindings bindings = this.fEngine.getBindings(100);
        for (Map.Entry entry : bindings.entrySet()) {
            variables.put((String)entry.getKey(), entry.getValue());
        }
        return variables;
    }

    protected boolean internalHasVariable(String name) {
        return this.fEngine.getBindings(100).containsKey(name);
    }

    protected void internalSetVariable(String name, Object content) {
        if (!JavaScriptHelper.isSaveName((String)name)) {
            throw new RuntimeException("\"" + name + "\" is not a valid JavaScript variable name");
        }
        this.fEngine.put(name, content);
    }

    protected Object internalRemoveVariable(String name) {
        return this.fEngine.getBindings(100).remove(name);
    }

    public String getSaveVariableName(String name) {
        return JavaScriptHelper.getSaveName((String)name);
    }

    public void registerJar(URL url) {
    }

    protected boolean setupEngine() {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        this.fEngine = engineManager.getEngineByName("nashorn");
        return this.fEngine != null;
    }

    protected boolean teardownEngine() {
        this.fEngine = null;
        return true;
    }

    protected Object execute(Script script, Object reference, String fileName, boolean uiThread) throws Exception {
        return this.fEngine.eval(script.getCode());
    }
}

