/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.jython.debugger;

import java.io.InputStream;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.debugging.EventDispatchJob;
import org.eclipse.ease.debugging.IEventProcessor;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.lang.python.debugger.IPythonDebugEngine;
import org.eclipse.ease.lang.python.debugger.PythonDebugger;
import org.eclipse.ease.lang.python.debugger.ResourceHelper;
import org.eclipse.ease.lang.python.debugger.model.PythonDebugTarget;
import org.eclipse.ease.lang.python.jython.JythonScriptEngine;
import org.eclipse.ease.lang.python.jython.debugger.JythonDebugger;
import org.python.core.Py;

public class JythonDebuggerEngine
extends JythonScriptEngine
implements IPythonDebugEngine {
    private PythonDebugger fDebugger = null;

    public void setDebugger(PythonDebugger debugger) {
        this.fDebugger = debugger;
    }

    protected void setupEngine() throws ScriptEngineException {
        super.setupEngine();
        if (this.fDebugger != null) {
            try {
                InputStream stream = ResourceHelper.getResourceStream((String)"org.eclipse.ease.lang.python", (String)"pysrc/edb.py");
                this.internalSetVariable("_pyease_debugger", Py.java2py((Object)this.fDebugger));
                super.internalExecute(new Script("Load Python debugger", (Object)stream), null, "Load Python Debugger");
            }
            catch (Throwable e) {
                throw new ScriptEngineException("Failed to load Python Debugger", e);
            }
        }
    }

    protected Object internalExecute(Script script, Object reference, String fileName) throws Exception {
        if (this.fDebugger != null) {
            return this.fDebugger.execute(script);
        }
        return super.internalExecute(script, reference, fileName);
    }

    public void setupDebugger(ILaunch launch, boolean suspendOnStartup, boolean suspendOnScriptLoad, boolean showDynamicCode) {
        PythonDebugTarget target = new PythonDebugTarget(launch, suspendOnStartup, suspendOnScriptLoad, showDynamicCode);
        launch.addDebugTarget((IDebugTarget)target);
        JythonDebugger debugger = new JythonDebugger((IDebugEngine)this, showDynamicCode);
        this.setDebugger(debugger);
        EventDispatchJob dispatcher = new EventDispatchJob((IEventProcessor)target, (IEventProcessor)debugger);
        target.setDispatcher(dispatcher);
        debugger.setDispatcher(dispatcher);
        dispatcher.schedule();
    }

    public ScriptStackTrace getExceptionStackTrace() {
        return null;
    }
}

