/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.eclipse.ease.helpgenerator.IMemento;
import org.eclipse.ease.helpgenerator.IReporter;
import org.eclipse.ease.helpgenerator.XMLMemento;
import org.eclipse.ease.helpgenerator.documentation.ClassNameResolver;
import org.eclipse.ease.helpgenerator.documentation.ReferenceReplacer;
import org.eclipse.ease.helpgenerator.documentation.linkcreators.JavaDoc11LinkCreator;
import org.eclipse.ease.helpgenerator.documentation.linkcreators.JavaDoc8LinkCreator;
import org.eclipse.ease.helpgenerator.documentation.linkcreators.ModuleLinkCreator;
import org.eclipse.ease.helpgenerator.htmlwriter.HtmlWriter;
import org.eclipse.ease.helpgenerator.model.AbstractClassModel;
import org.eclipse.ease.helpgenerator.model.Category;
import org.eclipse.ease.helpgenerator.model.ModuleDefinition;

public abstract class AbstractModuleDoclet {
    private final Map<String, List<String>> fParameters = new HashMap<String, List<String>>();
    private IReporter fReporter;
    private final ReferenceReplacer fReferenceReplacer = new ReferenceReplacer();

    protected static ModuleDefinition findModule(String className, Set<ModuleDefinition> modules) {
        for (ModuleDefinition module : modules) {
            if (!className.equals(module.getClassName())) continue;
            return module;
        }
        return null;
    }

    public static String createHTMLFileName(String moduleID) {
        return "module_" + AbstractModuleDoclet.escape(moduleID) + ".html";
    }

    private static String escape(String data) {
        return data.replace(' ', '_').toLowerCase();
    }

    public AbstractModuleDoclet() {
        this.fReferenceReplacer.addLinkCreator(new ModuleLinkCreator());
    }

    public boolean run() {
        try {
            for (ModuleDefinition module : this.getModules()) {
                AbstractClassModel classModel = this.getClassModel(module);
                if (classModel != null) {
                    this.createHTMLFile(module, classModel);
                    continue;
                }
                this.getReporter().report(1, "No class definition found for module \"" + module.getName() + "\"");
            }
            if (this.hasModuleDefinitions()) {
                Set<String> tocFiles = this.createModuleTOCFiles();
                this.updatePluginXML(tocFiles);
                this.updateManifest();
                this.updateBuildProperties();
            }
        }
        catch (Exception e) {
            this.getReporter().report(2, e.getMessage());
            e.printStackTrace();
            return false;
        }
        return !this.getReporter().hasErrors();
    }

    private boolean hasModuleDefinitions() throws Exception {
        return !this.getModules().isEmpty() || !this.getCategories().isEmpty();
    }

    public void setParameter(String option, List<String> arguments) {
        if ("-link".equals(option)) {
            this.registerLinks(arguments.get(0));
        } else if ("-linkoffline".equals(option)) {
            this.registerOfflineLinks(arguments.get(0), arguments.get(1));
        } else {
            this.fParameters.put(option, arguments);
        }
    }

    public IReporter getReporter() {
        if (this.fReporter == null) {
            this.fReporter = this.createReporter();
        }
        return this.fReporter;
    }

    public Set<ModuleDefinition> getModules() throws Exception {
        HashSet<ModuleDefinition> registeredModules = new HashSet<ModuleDefinition>();
        try {
            IMemento document = this.getPluginDefinition();
            for (IMemento extensionNode : document.getChildren("extension")) {
                if (!"org.eclipse.ease.modules".equals(extensionNode.getString("point"))) continue;
                for (IMemento instanceNode : extensionNode.getChildren("module")) {
                    registeredModules.add(new ModuleDefinition(instanceNode));
                }
            }
        }
        catch (Exception e) {
            this.getReporter().report(0, "No plugin definition found, skipping");
        }
        return registeredModules;
    }

    public Set<Category> getCategories() {
        HashSet<Category> categories = new HashSet<Category>();
        try {
            IMemento document = this.getPluginDefinition();
            for (IMemento extensionNode : document.getChildren("extension")) {
                if (!"org.eclipse.ease.modules".equals(extensionNode.getString("point"))) continue;
                for (IMemento instanceNode : extensionNode.getChildren("category")) {
                    categories.add(new Category(instanceNode));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return categories;
    }

    public IMemento getPluginDefinition() throws Exception {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.getPluginOrFragmentFile()), StandardCharsets.UTF_8);
        XMLMemento root = XMLMemento.createReadRoot(reader);
        reader.close();
        return root;
    }

    public File getProjectFile(String path, boolean shallExist) throws IOException {
        File pluginDefinition = this.getRootFolder().toPath().resolve(path).toFile();
        if (pluginDefinition.exists() || !shallExist) {
            return pluginDefinition;
        }
        throw new IOException(path + " not found");
    }

    public File getPluginOrFragmentFile() throws IOException {
        try {
            return this.getProjectFile("plugin.xml", true);
        }
        catch (Exception exception) {
            return this.getProjectFile("fragment.xml", true);
        }
    }

    public File getBuildPropertiesFile() throws IOException {
        return this.getProjectFile("build.properties", true);
    }

    public File getManifestFile() throws IOException {
        return this.getProjectFile("META-INF/MANIFEST.MF", true);
    }

    public File getRootFolder() throws IOException {
        List<String> parameter = this.fParameters.get("-root");
        if (parameter == null || parameter.size() != 1) {
            throw new IOException("Root folder not found, use -root parameter");
        }
        File rootFolder = new File(parameter.get(0));
        if (!rootFolder.exists()) {
            throw new FileNotFoundException("Root folder \"" + parameter.get(0) + "\"does not exist");
        }
        if (!rootFolder.isDirectory()) {
            throw new IOException("Root folder is not a directory");
        }
        return rootFolder;
    }

    public boolean failOnMissingDocs() {
        List<String> parameter = this.fParameters.get("-failOnMissingDocs");
        if (parameter == null || parameter.size() != 1) {
            return true;
        }
        return Boolean.parseBoolean(parameter.get(0));
    }

    public boolean failOnHtmlErrors() {
        List<String> parameter = this.fParameters.get("-failOnHTMLError");
        if (parameter == null || parameter.size() != 1) {
            return true;
        }
        return Boolean.parseBoolean(parameter.get(0));
    }

    public void verifyXmlContent(String content, String className) {
        try {
            XMLMemento.createReadRoot(new StringReader(content));
        }
        catch (Exception e) {
            this.getReporter().reportInvalidHtml("invalid file content for " + className + ":\t" + e.getMessage());
        }
    }

    public void createHTMLFile(ModuleDefinition module, AbstractClassModel classModel) throws IOException {
        HtmlWriter htmlWriter = new HtmlWriter(module, classModel, this.getReporter());
        String content = htmlWriter.createContents();
        this.fReferenceReplacer.setClassNameResolver(new ClassNameResolver(classModel.getImportedClasses()));
        content = this.fReferenceReplacer.replaceReferences(content);
        this.verifyXmlContent(content, classModel.getClassName());
        if (!Files.exists(this.getProjectFile("help", false).toPath(), new LinkOption[0])) {
            Files.createDirectory(this.getProjectFile("help", false).toPath(), new FileAttribute[0]);
        }
        Files.write(this.getHtmlHelpFilePath(module.getId()), content.getBytes(), new OpenOption[0]);
    }

    private Path getHtmlHelpFilePath(String moduleID) throws IOException {
        return this.getProjectFile("help/module_" + AbstractModuleDoclet.escape(moduleID) + ".html", false).toPath();
    }

    public void updateBuildProperties() throws IOException {
        File buildFile = this.getBuildPropertiesFile();
        Properties properties = new Properties();
        properties.load(new FileInputStream(buildFile));
        String property = properties.getProperty("bin.includes");
        if (!property.contains("help/")) {
            if (property.trim().isEmpty()) {
                properties.setProperty("bin.includes", "help/");
            } else {
                properties.setProperty("bin.includes", "help/," + property.trim());
            }
            FileOutputStream out = new FileOutputStream(buildFile);
            properties.store(out, "");
            out.close();
        }
    }

    public void updateManifest() throws IOException {
        File manifestFile = this.getManifestFile();
        Manifest manifest = new Manifest();
        manifest.read(new FileInputStream(manifestFile));
        Attributes mainAttributes = manifest.getMainAttributes();
        String require = mainAttributes.getValue("Require-Bundle");
        if (require == null || require.isEmpty()) {
            mainAttributes.putValue("Require-Bundle", "org.eclipse.help;bundle-version=\"[3.5.0,4.0.0)\"");
        } else if (!require.contains("org.eclipse.help")) {
            mainAttributes.putValue("Require-Bundle", "org.eclipse.help;bundle-version=\"[3.5.0,4.0.0)\"," + require);
        } else {
            return;
        }
        FileOutputStream out = new FileOutputStream(manifestFile);
        manifest.write(out);
        out.close();
    }

    public Set<String> createModuleTOCFiles() throws Exception {
        HashMap<String, IMemento> tocDefinitions = new HashMap<String, IMemento>();
        for (Category category : this.getCategories()) {
            XMLMemento memento = XMLMemento.createWriteRoot("toc");
            memento.putString("label", category.getName());
            memento.putString("link_to", category.getHelpLink());
            IMemento topicNode = memento.createChild("topic");
            topicNode.putString("label", category.getName());
            topicNode.putBoolean("sort", true);
            topicNode.createChild("anchor").putString("id", "modules_anchor");
            tocDefinitions.put(category.getFileName(), memento);
        }
        for (ModuleDefinition moduleDefinition : this.getModules()) {
            IMemento memento;
            String categoryID = moduleDefinition.getCategoryId();
            String fileName = Category.createCategoryFileName(categoryID).replace("category_", "modules_");
            if (tocDefinitions.containsKey(fileName)) {
                memento = (IMemento)tocDefinitions.get(fileName);
            } else {
                memento = XMLMemento.createWriteRoot("toc");
                memento.putString("label", "Modules");
                memento.putString("link_to", Category.createCategoryLink(categoryID));
                tocDefinitions.put(fileName, memento);
            }
            IMemento topicNode = memento.createChild("topic");
            topicNode.putString("href", "help/" + AbstractModuleDoclet.createHTMLFileName(moduleDefinition.getId()));
            topicNode.putString("label", moduleDefinition.getName());
        }
        for (Map.Entry entry : tocDefinitions.entrySet()) {
            Files.write(this.getProjectFile("help/" + (String)entry.getKey(), false).toPath(), ((IMemento)entry.getValue()).toString().getBytes(), new OpenOption[0]);
        }
        return tocDefinitions.keySet();
    }

    public void updatePluginXML(Collection<String> tocs) throws Exception {
        HashSet<String> toDo = new HashSet<String>(tocs);
        IMemento memento = this.getPluginDefinition();
        for (IMemento extensionNode : memento.getChildren("extension")) {
            String extensionPoint = extensionNode.getString("point");
            if (!"org.eclipse.help.toc".equals(extensionPoint)) continue;
            for (IMemento tocNode : extensionNode.getChildren("toc")) {
                String tocLocation = tocNode.getString("file");
                if (tocLocation.length() <= 5) continue;
                toDo.remove(tocLocation.substring(5));
            }
        }
        for (String fileLocation : toDo) {
            IMemento extensionNode = memento.createChild("extension");
            extensionNode.putString("point", "org.eclipse.help.toc");
            IMemento tocNode = extensionNode.createChild("toc");
            tocNode.putString("file", "help/" + fileLocation);
            tocNode.putBoolean("primary", false);
        }
        if (!toDo.isEmpty()) {
            File pluginFile = this.getPluginOrFragmentFile();
            Files.write(pluginFile.toPath(), memento.toString().replace("&#x0A;", "\n").getBytes(), new OpenOption[0]);
        }
    }

    protected void registerLinks(String url) {
        this.registerOfflineLinks(url, url);
    }

    protected void registerOfflineLinks(String remoteUrl, String packageLocation) {
        try {
            List<String> packageContent = this.loadPackages(packageLocation);
            if (!packageContent.isEmpty()) {
                if (JavaDoc11LinkCreator.isModuleEntry(packageContent.get(0))) {
                    this.fReferenceReplacer.addLinkCreator(new JavaDoc11LinkCreator(remoteUrl, packageContent, this.fReferenceReplacer));
                } else {
                    this.fReferenceReplacer.addLinkCreator(new JavaDoc8LinkCreator(remoteUrl, packageContent, this.fReferenceReplacer));
                }
            }
        }
        catch (IOException e1) {
            this.getReporter().report(1, "Cannot read package data from '" + packageLocation + "': " + e1.getMessage());
        }
    }

    private List<String> loadPackages(String contentDescriptionFile) throws IOException {
        if (contentDescriptionFile.endsWith("element-list")) {
            return this.validateContent(this.readContent(contentDescriptionFile));
        }
        if (contentDescriptionFile.endsWith("package-list")) {
            return this.validateContent(this.readContent(contentDescriptionFile));
        }
        try {
            return this.validateContent(this.readContent(contentDescriptionFile + "/element-list"));
        }
        catch (IOException e) {
            return this.validateContent(this.readContent(contentDescriptionFile + "/package-list"));
        }
    }

    private List<String> validateContent(List<String> content) throws IOException {
        if (content.isEmpty()) {
            throw new IOException("Empty content detected");
        }
        for (int index = 0; index < Math.min(10, content.size()); ++index) {
            if (!content.get(index).contains("<")) continue;
            throw new IOException("Invalid package content detected in line " + (index + 1));
        }
        return content;
    }

    private List<String> readContent(String location) throws IOException {
        List<String> list;
        block13: {
            InputStream packageData = new URL(location).openStream();
            Throwable throwable = null;
            try {
                list = new BufferedReader(new InputStreamReader(packageData, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
                if (packageData == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (packageData != null) {
                            AbstractModuleDoclet.$closeResource(throwable, packageData);
                        }
                        throw throwable3;
                    }
                }
                catch (MalformedURLException e) {
                    try (FileInputStream packageData2 = new FileInputStream(location);){
                        List<String> list2 = new BufferedReader(new InputStreamReader((InputStream)packageData2, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
                        return list2;
                    }
                }
            }
            AbstractModuleDoclet.$closeResource(throwable, packageData);
        }
        return list;
    }

    protected abstract AbstractClassModel getClassModel(ModuleDefinition var1);

    protected abstract IReporter createReporter();
}

