/*
* Copyright (c) 2000, 2007 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials 
* are made available under the terms of the Eclipse Public License v1.0
* which is available at
* http://www.eclipse.org/legal/epl-v10.html
*/

package org.eclipse.datatools.sqltools.parsers.sql.xml.query;

public interface SQLXMLQueryParsersym {
    public final static int
      TK_ACCESS = 117,
      TK_ACCTNG = 118,
      TK_ACTION = 119,
      TK_ACTIVATE = 120,
      TK_ADD = 121,
      TK_ADMIN = 122,
      TK_ADMINISTRATION = 123,
      TK_AFTER = 124,
      TK_AGE = 125,
      TK_ALIAS = 126,
      TK_ALL = 20,
      TK_ALLOCATE = 127,
      TK_ALLOW = 128,
      TK_ALTER = 129,
      TK_ALTERIN = 130,
      TK_ALWAYS = 131,
      TK_AND = 29,
      TK_ANY = 51,
      TK_APPEND = 132,
      TK_APPL_ID = 133,
      TK_APPL_NAME = 134,
      TK_APPLNAME = 135,
      TK_ARRAY = 21,
      TK_AS = 3,
      TK_ASC = 52,
      TK_ASCII = 136,
      TK_ASENSITIVE = 137,
      TK_ASSIGNMENT = 138,
      TK_ASSOCIATE = 139,
      TK_AST = 140,
      TK_ASUTIME = 141,
      TK_AT = 142,
      TK_ATOMIC = 143,
      TK_ATTRIBUTE = 144,
      TK_ATTRIBUTES = 145,
      TK_AUTHORIZATION = 146,
      TK_AUTH_ID = 147,
      TK_AUTHID = 148,
      TK_AUTOMATIC = 149,
      TK_AUTOSTART = 150,
      TK_AVAILABLE = 151,
      TK_B = 152,
      TK_BEFORE = 153,
      TK_BEGIN = 154,
      TK_BERNOULLI = 155,
      TK_BETWEEN = 22,
      TK_BIGINT = 156,
      TK_BINARY = 157,
      TK_BIND = 158,
      TK_BINDADD = 159,
      TK_BIT = 160,
      TK_BLOB = 161,
      TK_BLOCKED = 162,
      TK_BLOCKSIZE = 163,
      TK_BOTH = 164,
      TK_BUFFER = 165,
      TK_BUFFERPOOL = 166,
      TK_BUFFERPOOLS = 167,
      TK_BUFFERSIZE = 168,
      TK_BUILD = 169,
      TK_BY = 7,
      TK_BYPASS = 170,
      TK_C = 171,
      TK_CACHE = 172,
      TK_CACHING = 173,
      TK_CALL = 174,
      TK_CALLED = 175,
      TK_CALLER = 176,
      TK_CAPTURE = 177,
      TK_CARDINALITIES = 178,
      TK_CARDINALITY = 179,
      TK_CASCADE = 180,
      TK_CASCADED = 181,
      TK_CASE = 182,
      TK_CAST = 183,
      TK_CCSID = 184,
      TK_CHANGE = 185,
      TK_CHANGED = 186,
      TK_CHANGES = 187,
      TK_CHAR = 188,
      TK_CHARACTER = 189,
      TK_CHECK = 190,
      TK_CHECKED = 191,
      TK_CLIENT = 192,
      TK_CLOB = 193,
      TK_CLOSE = 194,
      TK_CLR = 195,
      TK_CLUSTER = 196,
      TK_COBOL = 197,
      TK_COLLECT = 198,
      TK_COLLID = 199,
      TK_COLUMN = 200,
      TK_COLUMNS = 53,
      TK_COMM = 201,
      TK_COMMENT = 202,
      TK_COMMIT = 203,
      TK_COMMITTED = 204,
      TK_COMPACT = 205,
      TK_COMPARE = 206,
      TK_COMPARISONS = 207,
      TK_COMPRESS = 208,
      TK_COMPRESSION = 209,
      TK_CONCAT = 54,
      TK_CONDITION = 210,
      TK_CONN = 211,
      TK_CONNECT = 212,
      TK_CONNECTIONS = 213,
      TK_CONNECTOPT = 214,
      TK_CONNHEADER = 215,
      TK_CONNMEMUSE = 216,
      TK_CONSERVATIVE = 217,
      TK_CONSTRAINT = 218,
      TK_CONSTRAINTS = 219,
      TK_CONSTRUCTOR = 220,
      TK_CONTAINERS = 221,
      TK_CONTAINS = 222,
      TK_CONTENT = 8,
      TK_CONTINUE = 223,
      TK_CONTINUOUSLY = 224,
      TK_CONTROL = 225,
      TK_COPY = 226,
      TK_COUNT = 227,
      TK_COUNT_BIG = 228,
      TK_CPU = 229,
      TK_CREATE = 230,
      TK_CREATE_EXTERNAL_ROUTINE = 231,
      TK_CREATEIN = 232,
      TK_CREATE_NOT_FENCED = 233,
      TK_CREATE_NOT_FENCED_ROUTINE = 234,
      TK_CREATETAB = 235,
      TK_CS = 236,
      TK_CUBE = 55,
      TK_CURRENT = 237,
      TK_CURRENT_DATE = 238,
      TK_CURRENT_DEFAULT_TRANSFORM_GROUP = 239,
      TK_CURRENT_PATH = 56,
      TK_CURRENT_ROLE = 57,
      TK_CURRENT_TIME = 240,
      TK_CURRENT_TIMESTAMP = 241,
      TK_CURRENT_TRANSFORM_GROUP_FOR_TYPE = 242,
      TK_CURRENT_USER = 58,
      TK_CURRVAL = 243,
      TK_CURSOR = 244,
      TK_CURSORS = 245,
      TK_CYCLE = 246,
      TK_DATA = 247,
      TK_DATABASE = 248,
      TK_DATALINK = 249,
      TK_DATE = 250,
      TK_DAY = 251,
      TK_DAYS = 59,
      TK_DB = 252,
      TK_DBADM = 253,
      TK_DBCLOB = 254,
      TK_DBINFO = 255,
      TK_DBMEMUSE = 256,
      TK_DBPARTITIONNUM = 257,
      TK_DBPARTITIONNUMS = 258,
      TK_DB2DARI = 259,
      TK_DB2GENRL = 260,
      TK_DB2GENERAL = 261,
      TK_DB2OPTIONS = 262,
      TK_DB2SPL = 263,
      TK_DB2SQL = 264,
      TK_DB2_RETURN_STATUS = 265,
      TK_DB2_TOKEN_STRING = 266,
      TK_DEACTIVATE = 267,
      TK_DEADLOCK = 268,
      TK_DEADLOCKS = 269,
      TK_DEC = 270,
      TK_DECIMAL = 271,
      TK_DECLARE = 272,
      TK_DEFAULT = 30,
      TK_DEFAULTS = 273,
      TK_DEFINE = 274,
      TK_DEFINITION = 275,
      TK_DEGREE = 276,
      TK_DEFER = 277,
      TK_DEFERRED = 278,
      TK_DELETE = 60,
      TK_DESC = 61,
      TK_DESCRIPTOR = 279,
      TK_DETAILED = 280,
      TK_DETAILS = 281,
      TK_DETERMINED = 282,
      TK_DETERMINISTIC = 283,
      TK_DEVICE = 284,
      TK_DIAGNOSTICS = 285,
      TK_DIMENSIONS = 286,
      TK_DIRTY = 287,
      TK_DISABLE = 288,
      TK_DISALLOW = 289,
      TK_DISPATCH = 290,
      TK_DISTINCT = 31,
      TK_DISTRIBUTION = 291,
      TK_DLCONN = 292,
      TK_DLLOCK = 293,
      TK_DO = 294,
      TK_DOUBLE = 295,
      TK_DROP = 296,
      TK_DROPIN = 297,
      TK_DROPPED = 298,
      TK_DYNAMIC = 299,
      TK_EACH = 300,
      TK_ELEMENT = 32,
      TK_ELSE = 62,
      TK_ELSEIF = 301,
      TK_EMPTY = 23,
      TK_ENABLE = 302,
      TK_ENCRYPTION = 303,
      TK_END = 63,
      TK_ENDING = 304,
      TK_ENFORCED = 305,
      TK_ERASE = 306,
      TK_ESCAPE = 64,
      TK_ESTIMATE = 307,
      TK_EUR = 308,
      TK_EVALUATE = 309,
      TK_EVENT = 310,
      TK_EXACT = 311,
      TK_EXCEPT = 9,
      TK_EXCEPTION = 312,
      TK_EXCLUDE = 313,
      TK_EXCLUDES = 314,
      TK_EXCLUDING = 65,
      TK_EXCLUSIVE = 315,
      TK_EXECNODE = 316,
      TK_EXECUTE = 317,
      TK_EXISTS = 318,
      TK_EXIT = 319,
      TK_EXPAND = 320,
      TK_EXPLAIN = 321,
      TK_EXPRESSION = 322,
      TK_EXTEND = 323,
      TK_EXTENDED = 324,
      TK_EXTENSION = 325,
      TK_EXTENTSIZE = 326,
      TK_EXTERNAL = 327,
      TK_FALSE = 33,
      TK_FEDERATED = 328,
      TK_FEDERATED_TOOL = 329,
      TK_FENCED = 330,
      TK_FETCH = 331,
      TK_FILE = 332,
      TK_FILTER = 333,
      TK_FINAL = 334,
      TK_FIRST = 66,
      TK_FLOAT = 335,
      TK_FLUSH = 336,
      TK_FOLLOWING = 337,
      TK_FOR = 338,
      TK_FORCE = 339,
      TK_FOREIGN = 340,
      TK__FOREIGNKEY = 341,
      TK_FOUND = 342,
      TK_FREE = 343,
      TK_FREEPAGE = 344,
      TK_FROM = 24,
      TK_FS = 345,
      TK_FULL = 10,
      TK_FUNCTION = 346,
      TK_G = 34,
      TK_GBPCACHE = 347,
      TK_GENERAL = 348,
      TK_GENERATE = 349,
      TK_GENERATED = 350,
      TK_GET = 351,
      TK_GLOBAL = 352,
      TK_GOTO = 353,
      TK_GRANT = 354,
      TK_GRAPHIC = 355,
      TK_GROUP = 35,
      TK_GROUPING = 356,
      TK_HANDLER = 357,
      TK_HASHING = 358,
      TK_HAVING = 36,
      TK_HIDDEN = 359,
      TK_HIERARCHY = 360,
      TK_HIGH = 361,
      TK_HOLD = 362,
      TK_HOUR = 363,
      TK_HOURS = 67,
      TK_HPJ = 364,
      TK_ID = 68,
      TK_IDENTITY = 365,
      TK_IF = 366,
      TK_IGNORE = 367,
      TK_IMMEDIATE = 368,
      TK_IMPLICIT_SCHEMA = 369,
      TK_IN = 4,
      TK_INCLUDE = 370,
      TK_INCLUDES = 371,
      TK_INCLUDING = 69,
      TK_INCREMENT = 372,
      TK_INCREMENTAL = 373,
      TK_INDEX = 374,
      TK_INDEXES = 375,
      TK_INDICATOR = 376,
      TK_INFIX = 377,
      TK_INFO = 378,
      TK_INHERIT = 379,
      TK_INITIALLY = 380,
      TK_INITIAL_INSTS = 381,
      TK_INITIAL_IOS = 382,
      TK_INLINE = 383,
      TK_INNER = 11,
      TK_INOUT = 384,
      TK_INPUT = 385,
      TK_INSENSITIVE = 386,
      TK_INSERT = 70,
      TK_INSTANTIABLE = 387,
      TK_INSTEAD = 388,
      TK_INSTS_PER_ARGBYTE = 389,
      TK_INSTS_PER_INVOC = 390,
      TK_INT = 391,
      TK_INTEGER = 392,
      TK_INTEGRITY = 393,
      TK_INTERSECT = 12,
      TK_INTO = 71,
      TK_IO = 394,
      TK_IOS_PER_ARGBYTE = 395,
      TK_IOS_PER_INVOC = 396,
      TK_IS = 25,
      TK_ISO = 397,
      TK_ITERATE = 398,
      TK_ISOLATION = 399,
      TK_JAVA = 400,
      TK_JIS = 401,
      TK_JOIN = 37,
      TK_K = 72,
      TK_KEEP = 402,
      TK_KEY = 403,
      TK_KEYS = 404,
      TK_L = 405,
      TK_LANGUAGE = 406,
      TK_LARGE = 38,
      TK_LAST = 73,
      TK_LATERAL = 407,
      TK_LC_CTYPE = 408,
      TK_LEADING = 409,
      TK_LEAVE = 410,
      TK_LEFT = 13,
      TK_LENGTH = 411,
      TK_LEVEL = 412,
      TK_LEVEL2 = 413,
      TK_LIBRARY = 414,
      TK_LIBRARYADM = 415,
      TK_LIKE = 26,
      TK_LIMIT = 416,
      TK_LINK = 417,
      TK_LINKTYPE = 418,
      TK_LOAD = 419,
      TK_LOCAL = 420,
      TK_LOCALE = 421,
      TK_LOCALTIME = 422,
      TK_LOCALTIMESTAMP = 423,
      TK_LOCATOR = 424,
      TK_LOCATORS = 425,
      TK_LOCK = 426,
      TK_LOCKS = 427,
      TK_LOCKSIZE = 428,
      TK_LOG = 429,
      TK_LOGGED = 430,
      TK_LONG = 431,
      TK_LONGVAR = 432,
      TK_LOOP = 433,
      TK_LOW = 434,
      TK_M = 74,
      TK_MAIN_PROG = 435,
      TK_MANAGED = 436,
      TK_MANUALSTART = 437,
      TK_MAPPING = 438,
      TK_MATCHED = 439,
      TK_MATERIALIZED = 440,
      TK_MAXFILES = 441,
      TK_MAXFILESIZE = 442,
      TK_MAXVALUE = 443,
      TK_MDC = 444,
      TK_MERGE = 445,
      TK_MESSAGE_TEXT = 446,
      TK_METHOD = 447,
      TK_METHODS = 448,
      TK_MICROSECOND = 449,
      TK_MICROSECONDS = 75,
      TK_MINPCTUSED = 450,
      TK_MINUTE = 451,
      TK_MINUTES = 76,
      TK_MINVALUE = 452,
      TK_MIXED = 453,
      TK_MODE = 454,
      TK_MODIFIES = 455,
      TK_MONITOR = 456,
      TK_MONTH = 457,
      TK_MONTHS = 77,
      TK_MOVEMENT = 458,
      TK_MULTISET = 27,
      TK_N = 78,
      TK_NAME = 79,
      TK_NEW = 459,
      TK_NEW_TABLE = 460,
      TK_NEXT = 461,
      TK_NEXTVAL = 462,
      TK_NICKNAME = 463,
      TK_NO = 14,
      TK_NOCACHE = 464,
      TK_NOCYCLE = 465,
      TK_NODE = 466,
      TK_NODES = 467,
      TK_NODEGROUP = 468,
      TK_NOMAXVALUE = 469,
      TK_NOMINVALUE = 470,
      TK_NONBLOCKED = 471,
      TK_NONE = 472,
      TK_NOORDER = 473,
      TK_NOT = 5,
      TK_NULL = 6,
      TK_NULLS = 80,
      TK_NUM = 474,
      TK_NUMBLOCKPAGES = 475,
      TK_NUMERIC = 476,
      TK_NUM_FREQVALUES = 477,
      TK_NUM_QUANTILES = 478,
      TK_OBJECT = 81,
      TK_OF = 479,
      TK_OFF = 480,
      TK_OLD = 481,
      TK_OLD_TABLE = 482,
      TK_OLE = 483,
      TK_OLEDB = 484,
      TK_ON = 28,
      TK_ONCE = 485,
      TK_ONLINE = 486,
      TK_ONLY = 487,
      TK_OPEN = 488,
      TK_OPTIMIZATION = 489,
      TK_OPTIMIZE = 490,
      TK_OPTION = 82,
      TK_OPTIONS = 491,
      TK_OR = 39,
      TK_ORDER = 40,
      TK_ORGANIZE = 492,
      TK_OUT = 493,
      TK_OUTER = 83,
      TK_OVER = 494,
      TK_OVERFLOW = 495,
      TK_OVERHEAD = 496,
      TK_OVERRIDING = 497,
      TK_P = 498,
      TK_PACKAGE = 499,
      TK_PAGE = 500,
      TK_PAGESIZE = 501,
      TK_PARALLEL = 502,
      TK_PARAMETER = 503,
      TK_PASSTHRU = 504,
      TK_PASSWORD = 505,
      TK_PATH = 84,
      TK_PARTITION = 506,
      TK_PARTITIONING = 507,
      TK_PARTITIONINGS = 508,
      TK_PATROLLER = 509,
      TK_PCTDEACTIVATE = 510,
      TK_PCTFREE = 511,
      TK_PENDING = 512,
      TK_PERCENT_ARGBYTES = 513,
      TK_PERMISSION = 514,
      TK_PIECESIZE = 515,
      TK_PIPE = 516,
      TK_PLAN = 517,
      TK_PRECEDING = 518,
      TK_PRECISION = 85,
      TK_PREDICATES = 519,
      TK_PREFETCHSIZE = 520,
      TK_PREPARE = 521,
      TK_PRESERVE = 86,
      TK_PREVIOUS = 522,
      TK_PREVVAL = 523,
      TK_PRIMARY = 524,
      TK__PRIMARYKEY = 525,
      TK_PRIQTY = 526,
      TK_PRIVILEGES = 527,
      TK_PROCEDURE = 528,
      TK_PROFILE = 529,
      TK_PROGRAM = 530,
      TK_PROPAGATE = 531,
      TK_PROTOCOL = 532,
      TK_PRUNE = 533,
      TK_PUBLIC = 534,
      TK_QUERY = 535,
      TK_QUERYNO = 536,
      TK_QUERYTAG = 537,
      TK_QUIESCE_CONNECT = 538,
      TK_RANGE = 539,
      TK_RATE = 540,
      TK_RATIO = 541,
      TK_READ = 542,
      TK_READS = 543,
      TK_REAL = 544,
      TK_RECOMMEND = 545,
      TK_RECONCILE = 546,
      TK_RECOVERY = 547,
      TK_RECREATE = 548,
      TK_REDUCE = 549,
      TK_REF = 87,
      TK_REFERENCE = 550,
      TK_REFERENCES = 551,
      TK_REFERENCING = 552,
      TK_REFRESH = 553,
      TK_REGISTERS = 554,
      TK_REGULAR = 555,
      TK_RELEASE = 556,
      TK_REMAIN = 557,
      TK_REMOTE = 558,
      TK_RENAME = 559,
      TK_REOPT = 560,
      TK_REPEATABLE = 561,
      TK_REPEAT = 562,
      TK_REPLACE = 563,
      TK_REPLICATED = 564,
      TK_REQUIRING = 565,
      TK_RESET = 566,
      TK_RESIDENT = 567,
      TK_RESIGNAL = 568,
      TK_RESIZE = 569,
      TK_RESOLVE = 570,
      TK_RESTART = 571,
      TK_RESTORE = 572,
      TK_RESTRICT = 573,
      TK_RESULT = 574,
      TK_RESULT_SET_LOCATOR = 575,
      TK_RETAIN = 576,
      TK_RETURN = 577,
      TK_RETURNS = 578,
      TK_RETURN_STATUS = 579,
      TK_REVERSE = 580,
      TK_REVOKE = 581,
      TK_RIGHT = 15,
      TK_ROLLBACK = 582,
      TK_ROLLUP = 88,
      TK_ROUTINE = 583,
      TK_ROW = 584,
      TK_ROW_COUNT = 585,
      TK_ROWS = 586,
      TK_RR = 587,
      TK_RS = 588,
      TK_RUN = 589,
      TK_S = 590,
      TK_SAMPLED = 591,
      TK_SAVEPOINT = 592,
      TK_SBCS = 593,
      TK_SCANS = 594,
      TK_SCHEMA = 595,
      TK_SCOPE = 596,
      TK_SCRATCHPAD = 597,
      TK_SCROLL = 598,
      TK_SEARCH = 599,
      TK_SECOND = 600,
      TK_SECONDS = 89,
      TK_SECQTY = 601,
      TK_SECURITYADM = 602,
      TK_SELECT = 90,
      TK_SELECTION = 603,
      TK_SELECTIVE = 604,
      TK_SELECTIVITY = 605,
      TK_SELF = 606,
      TK_SENSITIVE = 607,
      TK_SEQUENCE = 41,
      TK_SERIALIZABLE = 608,
      TK_SERVER = 609,
      TK_SESSION = 610,
      TK_SESSION_USER = 91,
      TK_SET = 42,
      TK_SETS = 92,
      TK_SETTING = 611,
      TK_SHARE = 612,
      TK_SHRLEVEL = 613,
      TK_SIGNAL = 614,
      TK_SIMPLE = 615,
      TK_SIZE = 616,
      TK_SMALLINT = 617,
      TK_SNAPSHOT = 618,
      TK_SOME = 93,
      TK_SOURCE = 619,
      TK_SPECIAL = 620,
      TK_SPECIFIC = 621,
      TK_SPECIFICATION = 622,
      TK_SPLIT = 623,
      TK_SQL = 624,
      TK_SQLDATA = 625,
      TK_SQLERROR = 626,
      TK_SQLEXCEPTION = 627,
      TK_SQLWARNING = 628,
      TK_SQLID = 629,
      TK_SQLMACRO = 630,
      TK_SQLSTATE = 631,
      TK_SSA = 632,
      TK_STABILITY = 633,
      TK_STAGING = 634,
      TK_START = 635,
      TK_STATE = 636,
      TK_STATEMENT = 637,
      TK_STATEMENTS = 638,
      TK_STATIC = 639,
      TK_STATISTICS = 640,
      TK_STARTING = 641,
      TK_STAY = 642,
      TK_STMT = 643,
      TK_STOGROUP = 644,
      TK_STORAGE = 645,
      TK_STORED = 646,
      TK_STRIP = 94,
      TK_STRIPE = 647,
      TK_STYLE = 648,
      TK_SUB = 649,
      TK_SUBSECTION = 650,
      TK_SUMMARY = 651,
      TK_SWITCH = 652,
      TK_SYMMETRIC = 653,
      TK_SYNONYM = 654,
      TK_SYSTEM = 655,
      TK_SYSTEM_USER = 95,
      TK_T = 656,
      TK_TABLE = 657,
      TK_TABLES = 658,
      TK_TABLESAMPLE = 659,
      TK_TABLESPACE = 660,
      TK_TABLESPACES = 661,
      TK_TARGET = 662,
      TK_TEMPLATE = 663,
      TK_TEMPORARY = 664,
      TK_THEN = 43,
      TK_THREADSAFE = 665,
      TK_THROUGH = 666,
      TK_TIME = 667,
      TK_TIMEOUT = 668,
      TK_TIMESTAMP = 669,
      TK_TIMEZONE = 670,
      TK_TO = 96,
      TK_TOKEN = 671,
      TK_TRAILING = 672,
      TK_TRANSACTIONS = 673,
      TK_TRANSFERRATE = 674,
      TK_TRANSFORM = 675,
      TK_TRANSFORMS = 676,
      TK_TRANSLATE = 677,
      TK_TREAT = 678,
      TK_TRIGGER = 679,
      TK_TRUE = 44,
      TK_TRUNC = 680,
      TK_TWOLEVEL = 681,
      TK_TYPE = 682,
      TK_TYPES = 683,
      TK_UNBOUNDED = 684,
      TK_UNCHECKED = 685,
      TK_UNCOMMITTED = 686,
      TK_UNDER = 687,
      TK_UNDO = 688,
      TK_UNICODE = 689,
      TK_UNION = 16,
      TK_UNIQUE = 690,
      TK_UNLINK = 691,
      TK_UNTIL = 692,
      TK_UPDATE = 97,
      TK_UR = 693,
      TK_URL = 694,
      TK_USA = 695,
      TK_USE = 696,
      TK_USAGE = 697,
      TK_USER = 98,
      TK_USERID = 698,
      TK_USING = 699,
      TK_VALUE = 99,
      TK_VALUES = 45,
      TK_VARCHAR = 700,
      TK_VARGRAPHIC = 701,
      TK_VARIANT = 702,
      TK_VARYING = 100,
      TK_VCAT = 703,
      TK_VERSION = 101,
      TK_VIEW = 704,
      TK_VOLATILE = 705,
      TK_WAIT = 706,
      TK_WHEN = 46,
      TK_WHERE = 17,
      TK_WHILE = 707,
      TK_WITH = 18,
      TK_WITHOUT = 708,
      TK_WORK = 709,
      TK_WRAPPER = 710,
      TK_WRITE = 711,
      TK_WRKSTNNAME = 712,
      TK_X = 713,
      TK_XACT = 714,
      TK_YEAR = 715,
      TK_YEARS = 102,
      TK_YES = 716,
      TK_ABSENT = 103,
      TK_ACCORDING = 104,
      TK_BASE64 = 717,
      TK_DOCUMENT = 47,
      TK_ENCODING = 105,
      TK_HEX = 718,
      TK_LOCATION = 106,
      TK_NAMESPACE = 48,
      TK_NIL = 107,
      TK_ORDINALITY = 108,
      TK_PASSING = 109,
      TK_PI = 719,
      TK_RETURNING = 49,
      TK_URI = 110,
      TK_WHITESPACE = 111,
      TK_XML = 720,
      TK_XMLAGG = 721,
      TK_XMLATTRIBUTES = 112,
      TK_XMLBINARY = 722,
      TK_XMLCAST = 723,
      TK_XMLCOMMENT = 724,
      TK_XMLCONCAT = 725,
      TK_XMLDECLARATION = 113,
      TK_XMLDOCUMENT = 726,
      TK_XMLELEMENT = 727,
      TK_XMLEXISTS = 728,
      TK_XMLFOREST = 729,
      TK_XMLNAMESPACES = 114,
      TK_XMLPARSE = 730,
      TK_XMLPI = 731,
      TK_XMLQUERY = 732,
      TK_XMLSCHEMA = 115,
      TK_XMLSERIALIZE = 733,
      TK_XMLTABLE = 734,
      TK_XMLTEXT = 735,
      TK_XMLVALIDATE = 736,
      TK_DOUBLE_QUOTE = 762,
      TK_QUOTE = 763,
      TK_LEFT_PAREN = 116,
      TK_RIGHT_PAREN = 19,
      TK_ASTERISK = 740,
      TK_PLUS_SIGN = 1,
      TK_COMMA = 50,
      TK_MINUS_SIGN = 2,
      TK_PERIOD = 756,
      TK_SOLIDUS = 753,
      TK_COLON = 764,
      TK_SEMICOLON = 765,
      TK_LESS_THAN_OPERATOR = 743,
      TK_EQUALS_OPERATOR = 741,
      TK_GREATER_THAN_OPERATOR = 744,
      TK_QUESTION_MARK = 766,
      TK_LEFT_BRACKET = 757,
      TK_RIGHT_BRACKET = 758,
      TK_VERTICAL_BAR = 767,
      TK_NOT_EQUALS_OPERATOR = 745,
      TK_GREATER_THAN_OR_EQUALS_OPERATOR = 746,
      TK_LESS_THAN_OR_EQUALS_OPERATOR = 747,
      TK_CONCAT_OPERATOR = 754,
      TK_DOUBLE_PERIOD = 768,
      TK_RIGHT_ARROW = 769,
      TK_REGULAR_IDENTIFIER = 737,
      TK_DELIMITED_IDENTIFIER = 738,
      TK_EMBEDDED_VARIABLE_NAME = 770,
      TK_UNSIGNED_INTEGER = 742,
      TK_SUFFIXED_UNSIGNED_INTEGER = 771,
      TK_EXACT_NUMERIC_LITERAL = 748,
      TK_APPROXIMATE_NUMERIC_LITERAL = 749,
      TK_NATIONAL_CHAR_STRING_LITERAL = 772,
      TK_NATIONAL_HEX_STRING_LITERAL = 773,
      TK_BIT_STRING_LITERAL = 774,
      TK_HEX_STRING_LITERAL = 750,
      TK_CHAR_STRING_LITERAL = 739,
      TK_COMMENT_STRING = 775,
      TK_DELIMITED_TYPE_IDENTIFIER = 776,
      TK_VERSION_IDENTIFIER = 777,
      TK_STATEMENT_TERMINATOR = 755,
      TK_HOSTVARIABLE = 751,
      TK_PARAMETER_MARKER = 752,
      TK_LEFT_BRACKET_TRIGRAPH = 759,
      TK_RIGHT_BRACKET_TRIGRAPH = 760,
      TK_EOLN = 778,
      TK_EOF = 761,
      TK_PARSE_ERROR = 779;

      public final static String orderedTerminalSymbols[] = {
                 "",
                 "PLUS_SIGN",
                 "MINUS_SIGN",
                 "AS",
                 "IN",
                 "NOT",
                 "NULL",
                 "BY",
                 "CONTENT",
                 "EXCEPT",
                 "FULL",
                 "INNER",
                 "INTERSECT",
                 "LEFT",
                 "NO",
                 "RIGHT",
                 "UNION",
                 "WHERE",
                 "WITH",
                 "RIGHT_PAREN",
                 "ALL",
                 "ARRAY",
                 "BETWEEN",
                 "EMPTY",
                 "FROM",
                 "IS",
                 "LIKE",
                 "MULTISET",
                 "ON",
                 "AND",
                 "DEFAULT",
                 "DISTINCT",
                 "ELEMENT",
                 "FALSE",
                 "G",
                 "GROUP",
                 "HAVING",
                 "JOIN",
                 "LARGE",
                 "OR",
                 "ORDER",
                 "SEQUENCE",
                 "SET",
                 "THEN",
                 "TRUE",
                 "VALUES",
                 "WHEN",
                 "DOCUMENT",
                 "NAMESPACE",
                 "RETURNING",
                 "COMMA",
                 "ANY",
                 "ASC",
                 "COLUMNS",
                 "CONCAT",
                 "CUBE",
                 "CURRENT_PATH",
                 "CURRENT_ROLE",
                 "CURRENT_USER",
                 "DAYS",
                 "DELETE",
                 "DESC",
                 "ELSE",
                 "END",
                 "ESCAPE",
                 "EXCLUDING",
                 "FIRST",
                 "HOURS",
                 "ID",
                 "INCLUDING",
                 "INSERT",
                 "INTO",
                 "K",
                 "LAST",
                 "M",
                 "MICROSECONDS",
                 "MINUTES",
                 "MONTHS",
                 "N",
                 "NAME",
                 "NULLS",
                 "OBJECT",
                 "OPTION",
                 "OUTER",
                 "PATH",
                 "PRECISION",
                 "PRESERVE",
                 "REF",
                 "ROLLUP",
                 "SECONDS",
                 "SELECT",
                 "SESSION_USER",
                 "SETS",
                 "SOME",
                 "STRIP",
                 "SYSTEM_USER",
                 "TO",
                 "UPDATE",
                 "USER",
                 "VALUE",
                 "VARYING",
                 "VERSION",
                 "YEARS",
                 "ABSENT",
                 "ACCORDING",
                 "ENCODING",
                 "LOCATION",
                 "NIL",
                 "ORDINALITY",
                 "PASSING",
                 "URI",
                 "WHITESPACE",
                 "XMLATTRIBUTES",
                 "XMLDECLARATION",
                 "XMLNAMESPACES",
                 "XMLSCHEMA",
                 "LEFT_PAREN",
                 "ACCESS",
                 "ACCTNG",
                 "ACTION",
                 "ACTIVATE",
                 "ADD",
                 "ADMIN",
                 "ADMINISTRATION",
                 "AFTER",
                 "AGE",
                 "ALIAS",
                 "ALLOCATE",
                 "ALLOW",
                 "ALTER",
                 "ALTERIN",
                 "ALWAYS",
                 "APPEND",
                 "APPL_ID",
                 "APPL_NAME",
                 "APPLNAME",
                 "ASCII",
                 "ASENSITIVE",
                 "ASSIGNMENT",
                 "ASSOCIATE",
                 "AST",
                 "ASUTIME",
                 "AT",
                 "ATOMIC",
                 "ATTRIBUTE",
                 "ATTRIBUTES",
                 "AUTHORIZATION",
                 "AUTH_ID",
                 "AUTHID",
                 "AUTOMATIC",
                 "AUTOSTART",
                 "AVAILABLE",
                 "B",
                 "BEFORE",
                 "BEGIN",
                 "BERNOULLI",
                 "BIGINT",
                 "BINARY",
                 "BIND",
                 "BINDADD",
                 "BIT",
                 "BLOB",
                 "BLOCKED",
                 "BLOCKSIZE",
                 "BOTH",
                 "BUFFER",
                 "BUFFERPOOL",
                 "BUFFERPOOLS",
                 "BUFFERSIZE",
                 "BUILD",
                 "BYPASS",
                 "C",
                 "CACHE",
                 "CACHING",
                 "CALL",
                 "CALLED",
                 "CALLER",
                 "CAPTURE",
                 "CARDINALITIES",
                 "CARDINALITY",
                 "CASCADE",
                 "CASCADED",
                 "CASE",
                 "CAST",
                 "CCSID",
                 "CHANGE",
                 "CHANGED",
                 "CHANGES",
                 "CHAR",
                 "CHARACTER",
                 "CHECK",
                 "CHECKED",
                 "CLIENT",
                 "CLOB",
                 "CLOSE",
                 "CLR",
                 "CLUSTER",
                 "COBOL",
                 "COLLECT",
                 "COLLID",
                 "COLUMN",
                 "COMM",
                 "COMMENT",
                 "COMMIT",
                 "COMMITTED",
                 "COMPACT",
                 "COMPARE",
                 "COMPARISONS",
                 "COMPRESS",
                 "COMPRESSION",
                 "CONDITION",
                 "CONN",
                 "CONNECT",
                 "CONNECTIONS",
                 "CONNECTOPT",
                 "CONNHEADER",
                 "CONNMEMUSE",
                 "CONSERVATIVE",
                 "CONSTRAINT",
                 "CONSTRAINTS",
                 "CONSTRUCTOR",
                 "CONTAINERS",
                 "CONTAINS",
                 "CONTINUE",
                 "CONTINUOUSLY",
                 "CONTROL",
                 "COPY",
                 "COUNT",
                 "COUNT_BIG",
                 "CPU",
                 "CREATE",
                 "CREATE_EXTERNAL_ROUTINE",
                 "CREATEIN",
                 "CREATE_NOT_FENCED",
                 "CREATE_NOT_FENCED_ROUTINE",
                 "CREATETAB",
                 "CS",
                 "CURRENT",
                 "CURRENT_DATE",
                 "CURRENT_DEFAULT_TRANSFORM_GROUP",
                 "CURRENT_TIME",
                 "CURRENT_TIMESTAMP",
                 "CURRENT_TRANSFORM_GROUP_FOR_TYPE",
                 "CURRVAL",
                 "CURSOR",
                 "CURSORS",
                 "CYCLE",
                 "DATA",
                 "DATABASE",
                 "DATALINK",
                 "DATE",
                 "DAY",
                 "DB",
                 "DBADM",
                 "DBCLOB",
                 "DBINFO",
                 "DBMEMUSE",
                 "DBPARTITIONNUM",
                 "DBPARTITIONNUMS",
                 "DB2DARI",
                 "DB2GENRL",
                 "DB2GENERAL",
                 "DB2OPTIONS",
                 "DB2SPL",
                 "DB2SQL",
                 "DB2_RETURN_STATUS",
                 "DB2_TOKEN_STRING",
                 "DEACTIVATE",
                 "DEADLOCK",
                 "DEADLOCKS",
                 "DEC",
                 "DECIMAL",
                 "DECLARE",
                 "DEFAULTS",
                 "DEFINE",
                 "DEFINITION",
                 "DEGREE",
                 "DEFER",
                 "DEFERRED",
                 "DESCRIPTOR",
                 "DETAILED",
                 "DETAILS",
                 "DETERMINED",
                 "DETERMINISTIC",
                 "DEVICE",
                 "DIAGNOSTICS",
                 "DIMENSIONS",
                 "DIRTY",
                 "DISABLE",
                 "DISALLOW",
                 "DISPATCH",
                 "DISTRIBUTION",
                 "DLCONN",
                 "DLLOCK",
                 "DO",
                 "DOUBLE",
                 "DROP",
                 "DROPIN",
                 "DROPPED",
                 "DYNAMIC",
                 "EACH",
                 "ELSEIF",
                 "ENABLE",
                 "ENCRYPTION",
                 "ENDING",
                 "ENFORCED",
                 "ERASE",
                 "ESTIMATE",
                 "EUR",
                 "EVALUATE",
                 "EVENT",
                 "EXACT",
                 "EXCEPTION",
                 "EXCLUDE",
                 "EXCLUDES",
                 "EXCLUSIVE",
                 "EXECNODE",
                 "EXECUTE",
                 "EXISTS",
                 "EXIT",
                 "EXPAND",
                 "EXPLAIN",
                 "EXPRESSION",
                 "EXTEND",
                 "EXTENDED",
                 "EXTENSION",
                 "EXTENTSIZE",
                 "EXTERNAL",
                 "FEDERATED",
                 "FEDERATED_TOOL",
                 "FENCED",
                 "FETCH",
                 "FILE",
                 "FILTER",
                 "FINAL",
                 "FLOAT",
                 "FLUSH",
                 "FOLLOWING",
                 "FOR",
                 "FORCE",
                 "FOREIGN",
                 "_FOREIGNKEY",
                 "FOUND",
                 "FREE",
                 "FREEPAGE",
                 "FS",
                 "FUNCTION",
                 "GBPCACHE",
                 "GENERAL",
                 "GENERATE",
                 "GENERATED",
                 "GET",
                 "GLOBAL",
                 "GOTO",
                 "GRANT",
                 "GRAPHIC",
                 "GROUPING",
                 "HANDLER",
                 "HASHING",
                 "HIDDEN",
                 "HIERARCHY",
                 "HIGH",
                 "HOLD",
                 "HOUR",
                 "HPJ",
                 "IDENTITY",
                 "IF",
                 "IGNORE",
                 "IMMEDIATE",
                 "IMPLICIT_SCHEMA",
                 "INCLUDE",
                 "INCLUDES",
                 "INCREMENT",
                 "INCREMENTAL",
                 "INDEX",
                 "INDEXES",
                 "INDICATOR",
                 "INFIX",
                 "INFO",
                 "INHERIT",
                 "INITIALLY",
                 "INITIAL_INSTS",
                 "INITIAL_IOS",
                 "INLINE",
                 "INOUT",
                 "INPUT",
                 "INSENSITIVE",
                 "INSTANTIABLE",
                 "INSTEAD",
                 "INSTS_PER_ARGBYTE",
                 "INSTS_PER_INVOC",
                 "INT",
                 "INTEGER",
                 "INTEGRITY",
                 "IO",
                 "IOS_PER_ARGBYTE",
                 "IOS_PER_INVOC",
                 "ISO",
                 "ITERATE",
                 "ISOLATION",
                 "JAVA",
                 "JIS",
                 "KEEP",
                 "KEY",
                 "KEYS",
                 "L",
                 "LANGUAGE",
                 "LATERAL",
                 "LC_CTYPE",
                 "LEADING",
                 "LEAVE",
                 "LENGTH",
                 "LEVEL",
                 "LEVEL2",
                 "LIBRARY",
                 "LIBRARYADM",
                 "LIMIT",
                 "LINK",
                 "LINKTYPE",
                 "LOAD",
                 "LOCAL",
                 "LOCALE",
                 "LOCALTIME",
                 "LOCALTIMESTAMP",
                 "LOCATOR",
                 "LOCATORS",
                 "LOCK",
                 "LOCKS",
                 "LOCKSIZE",
                 "LOG",
                 "LOGGED",
                 "LONG",
                 "LONGVAR",
                 "LOOP",
                 "LOW",
                 "MAIN_PROG",
                 "MANAGED",
                 "MANUALSTART",
                 "MAPPING",
                 "MATCHED",
                 "MATERIALIZED",
                 "MAXFILES",
                 "MAXFILESIZE",
                 "MAXVALUE",
                 "MDC",
                 "MERGE",
                 "MESSAGE_TEXT",
                 "METHOD",
                 "METHODS",
                 "MICROSECOND",
                 "MINPCTUSED",
                 "MINUTE",
                 "MINVALUE",
                 "MIXED",
                 "MODE",
                 "MODIFIES",
                 "MONITOR",
                 "MONTH",
                 "MOVEMENT",
                 "NEW",
                 "NEW_TABLE",
                 "NEXT",
                 "NEXTVAL",
                 "NICKNAME",
                 "NOCACHE",
                 "NOCYCLE",
                 "NODE",
                 "NODES",
                 "NODEGROUP",
                 "NOMAXVALUE",
                 "NOMINVALUE",
                 "NONBLOCKED",
                 "NONE",
                 "NOORDER",
                 "NUM",
                 "NUMBLOCKPAGES",
                 "NUMERIC",
                 "NUM_FREQVALUES",
                 "NUM_QUANTILES",
                 "OF",
                 "OFF",
                 "OLD",
                 "OLD_TABLE",
                 "OLE",
                 "OLEDB",
                 "ONCE",
                 "ONLINE",
                 "ONLY",
                 "OPEN",
                 "OPTIMIZATION",
                 "OPTIMIZE",
                 "OPTIONS",
                 "ORGANIZE",
                 "OUT",
                 "OVER",
                 "OVERFLOW",
                 "OVERHEAD",
                 "OVERRIDING",
                 "P",
                 "PACKAGE",
                 "PAGE",
                 "PAGESIZE",
                 "PARALLEL",
                 "PARAMETER",
                 "PASSTHRU",
                 "PASSWORD",
                 "PARTITION",
                 "PARTITIONING",
                 "PARTITIONINGS",
                 "PATROLLER",
                 "PCTDEACTIVATE",
                 "PCTFREE",
                 "PENDING",
                 "PERCENT_ARGBYTES",
                 "PERMISSION",
                 "PIECESIZE",
                 "PIPE",
                 "PLAN",
                 "PRECEDING",
                 "PREDICATES",
                 "PREFETCHSIZE",
                 "PREPARE",
                 "PREVIOUS",
                 "PREVVAL",
                 "PRIMARY",
                 "_PRIMARYKEY",
                 "PRIQTY",
                 "PRIVILEGES",
                 "PROCEDURE",
                 "PROFILE",
                 "PROGRAM",
                 "PROPAGATE",
                 "PROTOCOL",
                 "PRUNE",
                 "PUBLIC",
                 "QUERY",
                 "QUERYNO",
                 "QUERYTAG",
                 "QUIESCE_CONNECT",
                 "RANGE",
                 "RATE",
                 "RATIO",
                 "READ",
                 "READS",
                 "REAL",
                 "RECOMMEND",
                 "RECONCILE",
                 "RECOVERY",
                 "RECREATE",
                 "REDUCE",
                 "REFERENCE",
                 "REFERENCES",
                 "REFERENCING",
                 "REFRESH",
                 "REGISTERS",
                 "REGULAR",
                 "RELEASE",
                 "REMAIN",
                 "REMOTE",
                 "RENAME",
                 "REOPT",
                 "REPEATABLE",
                 "REPEAT",
                 "REPLACE",
                 "REPLICATED",
                 "REQUIRING",
                 "RESET",
                 "RESIDENT",
                 "RESIGNAL",
                 "RESIZE",
                 "RESOLVE",
                 "RESTART",
                 "RESTORE",
                 "RESTRICT",
                 "RESULT",
                 "RESULT_SET_LOCATOR",
                 "RETAIN",
                 "RETURN",
                 "RETURNS",
                 "RETURN_STATUS",
                 "REVERSE",
                 "REVOKE",
                 "ROLLBACK",
                 "ROUTINE",
                 "ROW",
                 "ROW_COUNT",
                 "ROWS",
                 "RR",
                 "RS",
                 "RUN",
                 "S",
                 "SAMPLED",
                 "SAVEPOINT",
                 "SBCS",
                 "SCANS",
                 "SCHEMA",
                 "SCOPE",
                 "SCRATCHPAD",
                 "SCROLL",
                 "SEARCH",
                 "SECOND",
                 "SECQTY",
                 "SECURITYADM",
                 "SELECTION",
                 "SELECTIVE",
                 "SELECTIVITY",
                 "SELF",
                 "SENSITIVE",
                 "SERIALIZABLE",
                 "SERVER",
                 "SESSION",
                 "SETTING",
                 "SHARE",
                 "SHRLEVEL",
                 "SIGNAL",
                 "SIMPLE",
                 "SIZE",
                 "SMALLINT",
                 "SNAPSHOT",
                 "SOURCE",
                 "SPECIAL",
                 "SPECIFIC",
                 "SPECIFICATION",
                 "SPLIT",
                 "SQL",
                 "SQLDATA",
                 "SQLERROR",
                 "SQLEXCEPTION",
                 "SQLWARNING",
                 "SQLID",
                 "SQLMACRO",
                 "SQLSTATE",
                 "SSA",
                 "STABILITY",
                 "STAGING",
                 "START",
                 "STATE",
                 "STATEMENT",
                 "STATEMENTS",
                 "STATIC",
                 "STATISTICS",
                 "STARTING",
                 "STAY",
                 "STMT",
                 "STOGROUP",
                 "STORAGE",
                 "STORED",
                 "STRIPE",
                 "STYLE",
                 "SUB",
                 "SUBSECTION",
                 "SUMMARY",
                 "SWITCH",
                 "SYMMETRIC",
                 "SYNONYM",
                 "SYSTEM",
                 "T",
                 "TABLE",
                 "TABLES",
                 "TABLESAMPLE",
                 "TABLESPACE",
                 "TABLESPACES",
                 "TARGET",
                 "TEMPLATE",
                 "TEMPORARY",
                 "THREADSAFE",
                 "THROUGH",
                 "TIME",
                 "TIMEOUT",
                 "TIMESTAMP",
                 "TIMEZONE",
                 "TOKEN",
                 "TRAILING",
                 "TRANSACTIONS",
                 "TRANSFERRATE",
                 "TRANSFORM",
                 "TRANSFORMS",
                 "TRANSLATE",
                 "TREAT",
                 "TRIGGER",
                 "TRUNC",
                 "TWOLEVEL",
                 "TYPE",
                 "TYPES",
                 "UNBOUNDED",
                 "UNCHECKED",
                 "UNCOMMITTED",
                 "UNDER",
                 "UNDO",
                 "UNICODE",
                 "UNIQUE",
                 "UNLINK",
                 "UNTIL",
                 "UR",
                 "URL",
                 "USA",
                 "USE",
                 "USAGE",
                 "USERID",
                 "USING",
                 "VARCHAR",
                 "VARGRAPHIC",
                 "VARIANT",
                 "VCAT",
                 "VIEW",
                 "VOLATILE",
                 "WAIT",
                 "WHILE",
                 "WITHOUT",
                 "WORK",
                 "WRAPPER",
                 "WRITE",
                 "WRKSTNNAME",
                 "X",
                 "XACT",
                 "YEAR",
                 "YES",
                 "BASE64",
                 "HEX",
                 "PI",
                 "XML",
                 "XMLAGG",
                 "XMLBINARY",
                 "XMLCAST",
                 "XMLCOMMENT",
                 "XMLCONCAT",
                 "XMLDOCUMENT",
                 "XMLELEMENT",
                 "XMLEXISTS",
                 "XMLFOREST",
                 "XMLPARSE",
                 "XMLPI",
                 "XMLQUERY",
                 "XMLSERIALIZE",
                 "XMLTABLE",
                 "XMLTEXT",
                 "XMLVALIDATE",
                 "REGULAR_IDENTIFIER",
                 "DELIMITED_IDENTIFIER",
                 "CHAR_STRING_LITERAL",
                 "ASTERISK",
                 "EQUALS_OPERATOR",
                 "UNSIGNED_INTEGER",
                 "LESS_THAN_OPERATOR",
                 "GREATER_THAN_OPERATOR",
                 "NOT_EQUALS_OPERATOR",
                 "GREATER_THAN_OR_EQUALS_OPERATOR",
                 "LESS_THAN_OR_EQUALS_OPERATOR",
                 "EXACT_NUMERIC_LITERAL",
                 "APPROXIMATE_NUMERIC_LITERAL",
                 "HEX_STRING_LITERAL",
                 "HOSTVARIABLE",
                 "PARAMETER_MARKER",
                 "SOLIDUS",
                 "CONCAT_OPERATOR",
                 "STATEMENT_TERMINATOR",
                 "PERIOD",
                 "LEFT_BRACKET",
                 "RIGHT_BRACKET",
                 "LEFT_BRACKET_TRIGRAPH",
                 "RIGHT_BRACKET_TRIGRAPH",
                 "EOF",
                 "DOUBLE_QUOTE",
                 "QUOTE",
                 "COLON",
                 "SEMICOLON",
                 "QUESTION_MARK",
                 "VERTICAL_BAR",
                 "DOUBLE_PERIOD",
                 "RIGHT_ARROW",
                 "EMBEDDED_VARIABLE_NAME",
                 "SUFFIXED_UNSIGNED_INTEGER",
                 "NATIONAL_CHAR_STRING_LITERAL",
                 "NATIONAL_HEX_STRING_LITERAL",
                 "BIT_STRING_LITERAL",
                 "COMMENT_STRING",
                 "DELIMITED_TYPE_IDENTIFIER",
                 "VERSION_IDENTIFIER",
                 "EOLN",
                 "PARSE_ERROR"
             };

    public final static boolean isValidForParser = true;
}
