/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.examples.podreader.views;

import org.eclipse.datatools.examples.podreader.parser.Song;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class SongSorter extends ViewerSorter {
	public static final int SONG_NAME = 0;
	public static final int SONG_ARTIST = 1;
	public static final int SONG_ALBUM = 2;
	public static final int SONG_GENRE = 3;
	
	private int column;
	
	public SongSorter(int col) {
		column = col;
	}

	public int compare(Viewer viewer, Object e1, Object e2) {
		Song s1 = (Song)e1;
		Song s2 = (Song)e2;
		int res = 0;
		switch (column) {
			case SONG_NAME:
				res = s1.getName().compareTo(s2.getName());
			break;
			case SONG_ARTIST:
				res = s1.getArtist().compareTo(s2.getArtist());
			break;
			case SONG_ALBUM:
				res = s1.getAlbum().compareTo(s2.getAlbum());
			break;
			case SONG_GENRE:
				res = s1.getGenre().compareTo(s2.getGenre());
			break;
		}
		return res;
	}
}
