/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
const yamlParser07_1 = require("../parser/yamlParser07");
class YAMLDocumentSymbols {
    constructor(jsonLanguageService) {
        this.jsonLanguageService = jsonLanguageService;
    }
    findDocumentSymbols(document) {
        const doc = yamlParser07_1.parse(document.getText());
        if (!doc || doc['documents'].length === 0) {
            return null;
        }
        let results = [];
        for (const yamlDoc of doc['documents']) {
            if (yamlDoc.root) {
                results = results.concat(this.jsonLanguageService.findDocumentSymbols(document, yamlDoc));
            }
        }
        return results;
    }
    findHierarchicalDocumentSymbols(document) {
        const doc = yamlParser07_1.parse(document.getText());
        if (!doc || doc['documents'].length === 0) {
            return null;
        }
        let results = [];
        for (const yamlDoc of doc['documents']) {
            if (yamlDoc.root) {
                results = results.concat(this.jsonLanguageService.findDocumentSymbols2(document, yamlDoc));
            }
        }
        return results;
    }
}
exports.YAMLDocumentSymbols = YAMLDocumentSymbols;
//# sourceMappingURL=documentSymbols.js.map