/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentPackage;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.InterfaceDefinitionPackage;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.project.ComponentReference;
import org.eclipse.comma.project.project.CompoundInterface;
import org.eclipse.comma.project.project.DocumentationGenerationTask;
import org.eclipse.comma.project.project.FilePath;
import org.eclipse.comma.project.project.GeneratorBlock;
import org.eclipse.comma.project.project.HomeState;
import org.eclipse.comma.project.project.HomeStateSet;
import org.eclipse.comma.project.project.InterfaceMappings;
import org.eclipse.comma.project.project.InterfaceModel;
import org.eclipse.comma.project.project.InterfaceReference;
import org.eclipse.comma.project.project.ModelQualityChecksGenerationTask;
import org.eclipse.comma.project.project.MonitoringTask;
import org.eclipse.comma.project.project.Project;
import org.eclipse.comma.project.project.ProjectDescription;
import org.eclipse.comma.project.project.ProjectPackage;
import org.eclipse.comma.project.project.ReachabilityGraphGenerationTask;
import org.eclipse.comma.project.project.SimulatorGenerationTask;
import org.eclipse.comma.project.project.Task;
import org.eclipse.comma.project.project.TestCasesGenerationTask;
import org.eclipse.comma.project.project.TestClientGenerationTask;
import org.eclipse.comma.project.project.TraceSource;
import org.eclipse.comma.project.project.TypeMapping;
import org.eclipse.comma.project.project.TypeMappings;
import org.eclipse.comma.project.validation.AbstractProjectValidator;
import org.eclipse.comma.testcases.TestCasesGenerator;
import org.eclipse.comma.types.types.FileImport;
import org.eclipse.comma.types.types.NamespaceImport;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ProjectValidator
extends AbstractProjectValidator {
    public final String WARNING_CODE_EMPTY_BLOCK = "warning_code_empty_block";
    public final String ERROR_CODE_DUPLICATE_BLOCK = "error_code_duplicate_block";
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IResourceValidator validator;

    @Check
    public void checkImportForValidity(FileImport imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((Resource)imp.eResource(), (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
        } else {
            Resource res = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            if (res == null) {
                this.error("Invalid resource", (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
            } else {
                boolean _not_1;
                boolean _isEmpty = res.getErrors().isEmpty();
                boolean bl2 = _not_1 = !_isEmpty;
                if (_not_1) {
                    this.error("Resource contains errors", (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
                }
            }
        }
    }

    @Check
    public void checkUniqueTaskName(Project project) {
        HashSet<Task> duplicates = new HashSet<Task>();
        HashMap<String, Task> knownTasks = new HashMap<String, Task>();
        List tasks = EcoreUtil2.getAllContentsOfType((EObject)project, Task.class);
        for (Task task : tasks) {
            Task duplicate = knownTasks.put(task.getName(), task);
            if (duplicate == null) continue;
            duplicates.add(task);
            duplicates.add(duplicate);
        }
        Consumer<Task> _function = new Consumer<Task>(){

            @Override
            public void accept(Task it) {
                ProjectValidator.this.error("Duplicate task name.", it, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
            }
        };
        duplicates.forEach(_function);
    }

    @Check
    public void checkBlocks(Project project) {
        HashSet<GeneratorBlock> duplicates = new HashSet<GeneratorBlock>();
        HashMap<String, GeneratorBlock> knownBlocks = new HashMap<String, GeneratorBlock>();
        EList<GeneratorBlock> _generatorBlocks = project.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            GeneratorBlock duplicate;
            boolean _isEmpty = IteratorExtensions.isEmpty((Iterator)block.eAllContents());
            if (_isEmpty) {
                this.warning("This block contains no tasks or elements.", block, null, "warning_code_empty_block", new String[0]);
            }
            if ((duplicate = knownBlocks.put(block.eClass().getName(), block)) == null) continue;
            duplicates.add(block);
            duplicates.add(duplicate);
        }
        Consumer<GeneratorBlock> _function = new Consumer<GeneratorBlock>(){

            @Override
            public void accept(GeneratorBlock it) {
                ProjectValidator.this.error("Duplicate block.", it, null, "error_code_duplicate_block", new String[0]);
            }
        };
        duplicates.forEach(_function);
    }

    @Check
    public void checkDuplicatedTypeMappingsNames(Project prj) {
        List<TypeMappings> typeMappings = ProjectUtility.getTypeMappings(prj);
        for (TypeMappings tm1 : typeMappings) {
            for (TypeMappings tm2 : typeMappings) {
                if (Objects.equal((Object)tm1, (Object)tm2) || !tm1.getName().equals(tm2.getName())) continue;
                this.error("Duplicate name of type mappings", tm1, null);
            }
        }
    }

    @Check
    public void checkDuplicatedCommonMappings(TypeMappings mappings) {
        EList<TypeMapping> _commonMappings = mappings.getCommonMappings();
        for (TypeMapping m1 : _commonMappings) {
            EList<TypeMapping> _commonMappings_1 = mappings.getCommonMappings();
            for (TypeMapping m2 : _commonMappings_1) {
                if (Objects.equal((Object)m1, (Object)m2) || !Objects.equal((Object)m1.getType(), (Object)m2.getType())) continue;
                this.error("Duplicate type mapping", (EStructuralFeature)ProjectPackage.Literals.TYPE_MAPPINGS__COMMON_MAPPINGS, mappings.getCommonMappings().indexOf((Object)m1));
            }
        }
    }

    @Check
    public void checkDuplicatedInterfaceMappings(TypeMappings mappings) {
        EList<InterfaceMappings> _interfaceMappings = mappings.getInterfaceMappings();
        for (InterfaceMappings m1 : _interfaceMappings) {
            EList<InterfaceMappings> _interfaceMappings_1 = mappings.getInterfaceMappings();
            for (InterfaceMappings m2 : _interfaceMappings_1) {
                if (Objects.equal((Object)m1, (Object)m2) || !Objects.equal((Object)m1.getInterface(), (Object)m2.getInterface())) continue;
                this.error("Duplicate interface mapping", (EStructuralFeature)ProjectPackage.Literals.TYPE_MAPPINGS__INTERFACE_MAPPINGS, mappings.getInterfaceMappings().indexOf((Object)m1));
            }
        }
    }

    @Check
    public void checkDuplicatedTypesInInterfaceMappings(InterfaceMappings mapping) {
        EList<TypeMapping> _mappings = mapping.getMappings();
        for (TypeMapping m1 : _mappings) {
            EList<TypeMapping> _mappings_1 = mapping.getMappings();
            for (TypeMapping m2 : _mappings_1) {
                if (Objects.equal((Object)m1, (Object)m2) || !Objects.equal((Object)m1.getType(), (Object)m2.getType())) continue;
                this.error("Duplicate type mapping", (EStructuralFeature)ProjectPackage.Literals.INTERFACE_MAPPINGS__MAPPINGS, mapping.getMappings().indexOf((Object)m1));
            }
        }
    }

    @Check
    public void checkReachabilityGenerationTaskParameters(ReachabilityGraphGenerationTask task) {
        boolean _tripleNotEquals;
        String _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            this.checkParamsResource(task, task.getParams(), (EStructuralFeature)ProjectPackage.Literals.REACHABILITY_GRAPH_GENERATION_TASK__PARAMS, 0);
        }
    }

    @Check
    public void checkTestCasesGenerationTaskParameters(TestCasesGenerationTask task) {
        boolean _tripleNotEquals;
        String _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            this.checkParamsResource(task, task.getParams(), (EStructuralFeature)ProjectPackage.Literals.TEST_CASES_GENERATION_TASK__PARAMS, 0);
        }
    }

    @Check
    public void checkSimulatorGenerationTaskParameters(SimulatorGenerationTask task) {
        boolean _tripleNotEquals;
        EList<String> _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            EList<String> _params_1 = task.getParams();
            for (String param : _params_1) {
                this.checkParamsResource(task, param, (EStructuralFeature)ProjectPackage.Literals.SIMULATOR_GENERATION_TASK__PARAMS, task.getParams().indexOf((Object)param));
            }
        }
    }

    @Check
    public void checkReachabilityGraphGenerationTaskParameters(ReachabilityGraphGenerationTask task) {
        boolean _tripleNotEquals;
        String _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            this.checkParamsResource(task, task.getParams(), (EStructuralFeature)ProjectPackage.Literals.REACHABILITY_GRAPH_GENERATION_TASK__PARAMS, 0);
        }
    }

    @Check
    public void checkModelQualityChecksGenerationTaskParameters(ModelQualityChecksGenerationTask task) {
        boolean _tripleNotEquals;
        String _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            this.checkParamsResource(task, task.getParams(), (EStructuralFeature)ProjectPackage.Literals.MODEL_QUALITY_CHECKS_GENERATION_TASK__PARAMS, 0);
        }
    }

    @Check
    public void checkTestClientGenerationTaskParameters(TestClientGenerationTask task) {
        boolean _tripleNotEquals;
        EList<String> _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            EList<String> _params_1 = task.getParams();
            for (String param : _params_1) {
                this.checkParamsResource(task, param, (EStructuralFeature)ProjectPackage.Literals.TEST_CLIENT_GENERATION_TASK__PARAMS, task.getParams().indexOf((Object)param));
            }
        }
    }

    public void checkParamsResource(EObject resource, String param, EStructuralFeature feature, int index) {
        Resource ipres = EcoreUtil2.getResource((Resource)resource.eResource(), (String)param);
        if (ipres == null || !(IterableExtensions.head((Iterable)ipres.getContents()) instanceof Parameters)) {
            this.error("Invalid resource", feature, index);
        } else {
            boolean _not;
            boolean _isEmpty = this.validator.validate(ipres, CheckMode.ALL, null).isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                this.error("Errors found in .params file", feature, index);
            }
        }
    }

    @Check
    public void checkHomeStates(final ModelQualityChecksGenerationTask task) {
        boolean _tripleNotEquals;
        EList<HomeStateSet> _homeStateSets = task.getHomeStateSets();
        boolean bl = _tripleNotEquals = _homeStateSets != null;
        if (_tripleNotEquals) {
            Consumer<HomeStateSet> _function = new Consumer<HomeStateSet>(){

                @Override
                public void accept(HomeStateSet set) {
                    boolean _not;
                    Functions.Function1<StateMachine, String> _function = new Functions.Function1<StateMachine, String>(){

                        public String apply(StateMachine m) {
                            return m.getName();
                        }
                    };
                    final Set missingMachines = IterableExtensions.toSet((Iterable)ListExtensions.map((List)task.getTarget().getInterface().getMachines(), (Functions.Function1)_function));
                    final ArrayList machines = new ArrayList();
                    Consumer<HomeState> _function_1 = new Consumer<HomeState>(){

                        @Override
                        public void accept(HomeState state) {
                            EObject _eContainer = state.getHs().eContainer();
                            String name = ((StateMachine)_eContainer).getName();
                            boolean _contains = machines.contains(name);
                            if (_contains) {
                                String error = String.format("Home state set contains multiple states from machine %s", String.join((CharSequence)", ", name));
                                ProjectValidator.this.error(error, state, (EStructuralFeature)ProjectPackage.Literals.HOME_STATE__HS);
                            }
                            machines.add(name);
                            missingMachines.remove(name);
                        }
                    };
                    set.getStates().forEach((Consumer)_function_1);
                    boolean _isEmpty = missingMachines.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        String error = String.format("Home state set is missing state from machine(s): %s", String.join((CharSequence)", ", missingMachines));
                        ProjectValidator.this.error(error, set, (EStructuralFeature)ProjectPackage.Literals.HOME_STATE_SET__STATES);
                    }
                }
            };
            task.getHomeStateSets().forEach((Consumer)_function);
        }
    }

    @Check
    public void checkReachabilityGenerationTaskMissingParameters(ReachabilityGraphGenerationTask task) {
        InterfaceReference _target = task.getTarget();
        List<String> _xifexpression = null;
        String _params = task.getParams();
        boolean _tripleNotEquals = _params != null;
        _xifexpression = _tripleNotEquals ? Arrays.asList(task.getParams()) : null;
        this.checkParametersMissing(_target, _xifexpression, task, false);
    }

    @Check
    public void checkTestCasesGenerationTaskMissingParameters(TestCasesGenerationTask task) {
        InterfaceReference _target = task.getTarget();
        List<String> _xifexpression = null;
        String _params = task.getParams();
        boolean _tripleNotEquals = _params != null;
        _xifexpression = _tripleNotEquals ? Arrays.asList(task.getParams()) : null;
        this.checkParametersMissing(_target, _xifexpression, task, false);
    }

    @Check
    public void checkTestCasesGenerationTaskMissingTemplate(TestCasesGenerationTask task) {
        File projectFile = ProjectUtility.uriToFile(task.eResource().getURI());
        if (task.getTemplate() != null && TestCasesGenerator.getTemplate((File)projectFile, (String)task.getTemplate()) == null) {
            String error = String.format("Template file '%s' does not exist", task.getTemplate());
            this.error(error, task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        }
    }

    @Check
    public void checkTestClientGenerationTaskMissingParameters(TestClientGenerationTask task) {
        this.checkParametersMissing(task.getTarget(), (List<String>)task.getParams(), task, true);
    }

    @Check
    public void checkSimulatorGenerationTaskMissingParameters(SimulatorGenerationTask sTask) {
        this.checkParametersMissing(sTask.getTarget(), (List<String>)sTask.getParams(), sTask, true);
    }

    @Check
    public void checkModelQualityChecksGenerationTaskMissingParameters(ModelQualityChecksGenerationTask task) {
        InterfaceReference _target = task.getTarget();
        List<String> _xifexpression = null;
        String _params = task.getParams();
        boolean _tripleNotEquals = _params != null;
        _xifexpression = _tripleNotEquals ? Arrays.asList(task.getParams()) : null;
        this.checkParametersMissing(_target, _xifexpression, task, false);
    }

    public void checkParametersMissing(Object target, List<String> params, EObject task, final boolean requiredPorts) {
        boolean _isEmpty;
        boolean _not;
        final ArrayList<Interface> interfaces = new ArrayList<Interface>();
        if (target instanceof InterfaceReference) {
            interfaces.add(((InterfaceReference)target).getInterface());
        } else if (target instanceof ComponentReference) {
            Component comp = ((ComponentReference)target).getComponent();
            final List compInterfaces = ComponentUtilities.getAllInterfaces((EObject)comp, (IScopeProvider)this.scopeProvider);
            Consumer<Port> _function = new Consumer<Port>(){

                @Override
                public void accept(final Port p) {
                    if (p instanceof ProvidedPort || requiredPorts) {
                        Functions.Function1<Interface, Boolean> _function = new Functions.Function1<Interface, Boolean>(){

                            public Boolean apply(Interface i) {
                                return i.getName().equals(p.getInterface().getName());
                            }
                        };
                        Interface itf = (Interface)IterableExtensions.findFirst((Iterable)compInterfaces, (Functions.Function1)_function);
                        interfaces.add(itf);
                    }
                }
            };
            comp.getPorts().forEach((Consumer)_function);
        }
        Functions.Function1<Interface, Boolean> _function_1 = new Functions.Function1<Interface, Boolean>(){

            public Boolean apply(Interface itf) {
                return ProjectValidator.this.hasOpenEvents(itf);
            }
        };
        List missing = IterableExtensions.toList((Iterable)IterableExtensions.filter(interfaces, (Functions.Function1)_function_1));
        Functions.Function1<Interface, String> _function_2 = new Functions.Function1<Interface, String>(){

            public String apply(Interface i) {
                return i.getName();
            }
        };
        List missingByName = IterableExtensions.toList((Iterable)ListExtensions.map(new ArrayList(missing), (Functions.Function1)_function_2));
        if (params != null) {
            for (String file : params) {
                Resource param = EcoreUtil2.getResource((Resource)task.eResource(), (String)file);
                if (param == null || !(IterableExtensions.head((Iterable)param.getContents()) instanceof Parameters)) continue;
                EObject _head = (EObject)IterableExtensions.head((Iterable)param.getContents());
                Parameters p = (Parameters)_head;
                missing.remove(p.getInterface());
                missingByName.remove(p.getInterface().getName());
            }
        }
        boolean bl = _not = !(_isEmpty = missingByName.isEmpty());
        if (_not) {
            String error = String.format("Missing parameters for %s", String.join((CharSequence)", ", missingByName));
            this.error(error, task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        } else {
            boolean _not_1;
            boolean _isEmpty_1 = missing.isEmpty();
            boolean bl2 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                Functions.Function1<Interface, String> _function_3 = new Functions.Function1<Interface, String>(){

                    public String apply(Interface i) {
                        return i.getName();
                    }
                };
                String error_1 = String.format("Provided parameters for %s are for different .interface", String.join((CharSequence)", ", ListExtensions.map((List)missing, (Functions.Function1)_function_3)));
                this.error(error_1, task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
            }
        }
    }

    public boolean hasOpenEvents(Interface itf) {
        Functions.Function1<StateMachine, EList<State>> _function = new Functions.Function1<StateMachine, EList<State>>(){

            public EList<State> apply(StateMachine it) {
                return it.getStates();
            }
        };
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return !StateMachineUtilities.getAllOpenTriggers((State)s).isEmpty() || !StateMachineUtilities.getAllOpenNotifications((State)s).isEmpty() || !StateMachineUtilities.getAllCommandsWithOpenReply((State)s).isEmpty();
            }
        };
        return IterableExtensions.exists((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)itf.getMachines(), (Functions.Function1)_function)), (Functions.Function1)_function_1);
    }

    @Check
    public void checkMonitoringTask(MonitoringTask task) {
        this.validateTraceSources((List<TraceSource>)task.getTraces());
        this.validateDirectories((List<FilePath>)task.getTracedirs(), task);
    }

    public void validateTraceSources(List<TraceSource> sources) {
        Functions.Function1<FilePath, Boolean> _function = new Functions.Function1<FilePath, Boolean>(){

            public Boolean apply(FilePath s) {
                String _path = s.getPath();
                return _path != null;
            }
        };
        List filteredSources = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(sources, FilePath.class), (Functions.Function1)_function));
        ProjectUtility.TraceResources resources = ProjectUtility.getTraceResourcesFromFiles(filteredSources);
        for (FilePath invalid : resources.invalidTraceSources) {
            this.error("Invalid resource", invalid, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        for (FilePath wrongNamed : resources.wrongnamedTraceSources) {
            this.error("Trace file name must start with a letter and may contain letters, digits and _", wrongNamed, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        for (FilePath duplicate : resources.duplicateTraceSources) {
            this.error("File with the same name is already used", duplicate, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
    }

    @Check
    public void checkDuplicatedInterfaces(CompoundInterface compInterface) {
        EList<InterfaceModel> _interfaces = compInterface.getInterfaces();
        for (InterfaceModel i1 : _interfaces) {
            EList<InterfaceModel> _interfaces_1 = compInterface.getInterfaces();
            for (InterfaceModel i2 : _interfaces_1) {
                if (Objects.equal((Object)i1, (Object)i2) || !Objects.equal((Object)i1.getInterfaceModel(), (Object)i2.getInterfaceModel())) continue;
                this.error("Duplicate interface", i1, null);
            }
        }
    }

    @Check
    public void checkCompoundName(CompoundInterface compound) {
        List _allInterfaces = ComponentUtilities.getAllInterfaces((EObject)compound, (IScopeProvider)this.scopeProvider);
        for (Interface interface_ : _allInterfaces) {
            boolean _equals = interface_.getName().equals(compound.getName());
            if (!_equals) continue;
            this.error("Compound interface names are not allowed to be equal to an imported interface.", (EStructuralFeature)ProjectPackage.Literals.COMPOUND_INTERFACE__NAME);
        }
    }

    public void validateDirectories(List<FilePath> filePaths, Task task) {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        ProjectUtility.TraceResources resources = ProjectUtility.getTraceResourcesFromDirs(filePaths);
        for (FilePath dir : resources.nonexistentDirectories) {
            this.error("Directory does not exist", dir, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        for (FilePath dir_1 : resources.duplicateDirectories) {
            this.error("Directory is already listed", dir_1, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        boolean _isEmpty = resources.duplicateTraceFiles.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.error("Trace directories contain files with duplicate names", task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = resources.wrongnamedTraceFiles.isEmpty());
        if (_not_1) {
            this.error("Trace directories contain files with wrong names", task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        }
    }

    @Check
    public void validateDocGenerationTask(DocumentationGenerationTask task) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((Resource)task.eResource(), (URI)URI.createURI((String)task.getTemplate()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Template not found", (EStructuralFeature)ProjectPackage.Literals.DOCUMENTATION_GENERATION_TASK__TEMPLATE);
        }
    }

    @Check
    public void checkDuplications(ProjectDescription prj) {
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)prj.getImports(), NamespaceImport.class));
        if (_isEmpty) {
            return;
        }
        Multimap multiMap = this.getGlobalDeclarations((EObject)prj, TypesPackage.eINSTANCE.getTypeDecl());
        this.placePredefinedTypes(multiMap);
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry.getKey()).toString();
            String _plus = "Duplicate imported type " + _string;
            this.error(_plus, prj.getProject(), (EStructuralFeature)ProjectPackage.Literals.PROJECT__NAME);
        }
        multiMap = this.getGlobalDeclarations((EObject)prj, InterfaceDefinitionPackage.Literals.INTERFACE);
        Set _entrySet_1 = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet_1) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry.getKey()).toString();
            String _plus = "Duplicate imported interface " + _string;
            this.error(_plus, prj.getProject(), (EStructuralFeature)ProjectPackage.Literals.PROJECT__NAME);
        }
        multiMap = this.getGlobalDeclarations((EObject)prj, ComponentPackage.Literals.COMPONENT);
        Set set = multiMap.asMap().entrySet();
        for (Map.Entry entry_2 : set) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry_2.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry_2.getKey()).toString();
            String _plus = "Duplicate imported component " + _string;
            this.error(_plus, prj.getProject(), (EStructuralFeature)ProjectPackage.Literals.PROJECT__NAME);
        }
    }
}

