from typing import Any, List, Optional, Union, Tuple as TTuple, Dict
from reachability_graph import Edge

Mode = dict[str, Any]
Marking = dict[str, Mode]
InputToken = Union[Value, Variable, Tuple]
OutputToken = Union[Value, Variable, Tuple, Expression]

class Value:
    def __init__(self, value: Any) -> None: ...

class Expression:
    def __init__(self, expr: str) -> None: ...

class Variable:
    def __init__(self, name: str) -> None: ...

class Tuple:
    def __init__(self, value: List[Union[Value, Variable, Expression]]) -> None: ...

class Transition:
    name: str
    edge: Optional[Edge]
    meta: Dict[str, Any]
    guard: Optional[Expression]
    def __init__(self, name: str, guard: Optional[Expression]=...) -> None: ...
    def modes(self) -> List[Mode]: ...
    def fire(self, mode: Mode) -> None: ...
    def input(self) -> List[TTuple[Place, InputToken]]: ...
    def output(self) -> List[TTuple[Place, OutputToken]]: ...
    def remove_output(self, place: str) -> None: ...
    def remove_input(self, place: str) -> None: ...
    def add_output(self, place: str, label: OutputToken) -> None: ...
    def add_input(self, place: str, label: InputToken) -> None: ...

class PetriNet:
    _trans: dict[str, Transition]
    _place: dict[str, Place]
    def __init__(self, name: str) -> None: ...
    def get_marking(self) -> Marking: ...
    def set_marking(self, marking: Marking) -> None: ...
    def transition(self) -> List[Transition]: ...
    def add_place(self, place: Place) -> None: ...
    def add_transition(self, transition: Transition) -> None: ...
    def place(self) -> List[Place]: ...
    def add_input(self, place: str, transition: str, label: InputToken) -> None: ...
    def add_output(self, place: str, transition: str, label: OutputToken) -> None: ...
    def draw(self, file: str) -> None: ...
    def remove_output(self, place: str, transition: str) -> None: ...
    def remove_input(self, place: str, transition: str) -> None: ...

class MultiSet:
    def items(self) -> List[Any]: ... 

class Place:
    name: str
    meta: Dict[str, Any]
    tokens: MultiSet
    def __init__(self, name: str, token: Optional[List[Any]] = ...) -> None: ...
