/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.testgeneration;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.evaluator.EArgument;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.EConnection;
import org.eclipse.comma.evaluator.ENotification;
import org.eclipse.comma.evaluator.EReply;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableType;
import org.eclipse.comma.reachabilitygraph.DeterministicScenarios;
import org.eclipse.comma.reachabilitygraph.ReachabilityGraph;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class JavaTestCases {
    public static String getValue(Object o) {
        String _xblockexpression;
        block6: {
            try {
                _xblockexpression = null;
                if (o != null) break block6;
                return "null";
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        EVariable variable = (EVariable)o;
        String _xifexpression = null;
        if (Objects.equal((Object)variable.type, (Object)EVariableType.REAL) || Objects.equal((Object)variable.type, (Object)EVariableType.INT)) {
            _xifexpression = variable.value.toString();
        } else {
            String _xifexpression_1 = null;
            if (!Objects.equal((Object)variable.type, (Object)EVariableType.STRING) && !Objects.equal((Object)variable.type, (Object)EVariableType.ENUM)) {
                throw new Exception("Not supported");
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\"");
            String _string = variable.value.toString();
            _builder.append(_string);
            _builder.append("\"");
            _xifexpression_1 = _builder.toString();
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static String generate(ReachabilityGraph graph, String interfaceName) {
        int scenarioCount = 1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package test.");
        _builder.append(interfaceName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.junit.jupiter.api.AfterAll;");
        _builder.newLine();
        _builder.append("import org.junit.jupiter.api.AfterEach;");
        _builder.newLine();
        _builder.append("import org.junit.jupiter.api.BeforeAll;");
        _builder.newLine();
        _builder.append("import org.junit.jupiter.api.BeforeEach;");
        _builder.newLine();
        _builder.append("import org.junit.jupiter.api.Test;");
        _builder.newLine();
        _builder.append("import org.junit.jupiter.api.Assertions;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@SuppressWarnings(\"unused\")");
        _builder.newLine();
        _builder.append("public class TestCases {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("private static final Adapter adapter = new Adapter();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@BeforeAll");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public static void beforeAll() {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("adapter.beforeAll();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@BeforeEach");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public void beforeEach() {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("adapter.beforeEach();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@AfterEach");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public void afterEach() {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("adapter.afterEach();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@AfterAll");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public static void afterAll() {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("adapter.afterAll();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        List _scenariosEntries = DeterministicScenarios.fromGraph((ReachabilityGraph)graph).getScenariosEntries();
        boolean _hasElements = false;
        for (List scenario : _scenariosEntries) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "    ");
            }
            _builder.append("    ");
            _builder.append("@Test");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("public void testScenario");
            int _plusPlus = scenarioCount++;
            _builder.append((Object)_plusPlus, "    ");
            _builder.append("() throws InterruptedException {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            ArrayList<Object> _arrayList = new ArrayList<Object>(scenario);
            CharSequence _generateTestCase = JavaTestCases.generateTestCase(_arrayList);
            _builder.append((Object)_generateTestCase, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public static String callAdapter(EConnection connection, String method) {
        String _xifexpression = null;
        if (connection != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\"");
            _builder.append(method);
            _builder.append("\", \"");
            _builder.append(connection.port);
            _builder.append("\", \"");
            _builder.append(connection.id);
            _builder.append("\"");
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\"");
            _builder_1.append(method);
            _builder_1.append("\"");
            _xifexpression = _builder_1.toString();
        }
        return _xifexpression;
    }

    public static String callDescription(EConnection connection, String method) {
        String _xifexpression = null;
        if (connection != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(connection.port);
            _builder.append("[");
            _builder.append(connection.id);
            _builder.append("].");
            _builder.append(method);
            _xifexpression = _builder.toString();
        } else {
            _xifexpression = method;
        }
        return _xifexpression;
    }

    public static CharSequence generateTestCase(final ArrayList<Object> scenario) {
        try {
            String[] _split;
            StringConcatenation _xblockexpression = null;
            String body = "";
            String description = "";
            final List scenarioReversed = ListExtensions.reverse(new ArrayList<Object>(scenario));
            for (final Object entry : scenario) {
                if (entry instanceof ECommand || entry instanceof ESignal) {
                    String _description = description;
                    description = String.valueOf(_description) + "\n";
                    String _body = body;
                    body = String.valueOf(_body) + "\n";
                }
                if (entry instanceof ECommand) {
                    boolean _not;
                    Functions.Function1<EArgument, Boolean> _function = new Functions.Function1<EArgument, Boolean>(){

                        public Boolean apply(EArgument e) {
                            return !Objects.equal((Object)e.direction, (Object)"out");
                        }
                    };
                    Functions.Function1<EArgument, String> _function_1 = new Functions.Function1<EArgument, String>(){

                        public String apply(EArgument e) {
                            return JavaTestCases.getValue(e);
                        }
                    };
                    String arguments = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)((ECommand)entry).arguments, (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)", ");
                    Iterable<Object> notifications = JavaTestCases.getNotifications(scenario, entry);
                    int index = scenario.indexOf(entry);
                    Functions.Function1<Object, Boolean> _function_2 = new Functions.Function1<Object, Boolean>(){

                        public Boolean apply(Object e) {
                            return scenario.indexOf(e) > scenario.indexOf(entry) && e instanceof EReply;
                        }
                    };
                    Object _findFirst = IterableExtensions.findFirst(scenario, (Functions.Function1)_function_2);
                    EReply reply = (EReply)_findFirst;
                    String _body_1 = body;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("var result");
                    _builder.append((Object)index);
                    _builder.append(" = adapter.call(");
                    String _callAdapter = JavaTestCases.callAdapter(((ECommand)entry).connection, ((ECommand)entry).method);
                    _builder.append(_callAdapter);
                    _builder.append(", ");
                    String _value = JavaTestCases.getValue(reply.returnValue);
                    _builder.append(_value);
                    boolean _isBlank = arguments.isBlank();
                    boolean bl = _not = !_isBlank;
                    if (_not) {
                        _builder.append(", ");
                        _builder.append(arguments);
                    }
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    body = String.valueOf(_body_1) + _builder;
                    String _description_1 = description;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    if (Objects.equal((Object)((ECommand)entry).type, (Object)"void") && IterableExtensions.isEmpty(notifications)) {
                        _builder_1.append("Call command ");
                        String _callDescription = JavaTestCases.callDescription(((ECommand)entry).connection, ((ECommand)entry).method);
                        _builder_1.append(_callDescription);
                        _builder_1.append("(");
                        _builder_1.append(arguments);
                        _builder_1.append(")");
                        _builder_1.newLineIfNotEmpty();
                    } else {
                        _builder_1.append("When calling command ");
                        String _callDescription_1 = JavaTestCases.callDescription(((ECommand)entry).connection, ((ECommand)entry).method);
                        _builder_1.append(_callDescription_1);
                        _builder_1.append("(");
                        _builder_1.append(arguments);
                        _builder_1.append(") we should get:");
                        _builder_1.newLineIfNotEmpty();
                    }
                    description = String.valueOf(_description_1) + _builder_1;
                    continue;
                }
                if (entry instanceof ESignal) {
                    Iterable<Object> notifications_1 = JavaTestCases.getNotifications(scenario, entry);
                    String _body_2 = body;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("adapter.call(");
                    String _callAdapter_1 = JavaTestCases.callAdapter(((ESignal)entry).connection, ((ESignal)entry).method);
                    _builder_2.append(_callAdapter_1);
                    _builder_2.append(", null);");
                    _builder_2.newLineIfNotEmpty();
                    body = String.valueOf(_body_2) + _builder_2;
                    String _description_2 = description;
                    StringConcatenation _builder_3 = new StringConcatenation();
                    boolean _isEmpty = IterableExtensions.isEmpty(notifications_1);
                    if (_isEmpty) {
                        _builder_3.append("Calling signal ");
                        String _callDescription_2 = JavaTestCases.callDescription(((ESignal)entry).connection, ((ESignal)entry).method);
                        _builder_3.append(_callDescription_2);
                        _builder_3.newLineIfNotEmpty();
                    } else {
                        _builder_3.append("When calling signal ");
                        String _callDescription_3 = JavaTestCases.callDescription(((ESignal)entry).connection, ((ESignal)entry).method);
                        _builder_3.append(_callDescription_3);
                        _builder_3.append(" we should get:");
                        _builder_3.newLineIfNotEmpty();
                    }
                    description = String.valueOf(_description_2) + _builder_3;
                    continue;
                }
                if (entry instanceof EReply) {
                    Functions.Function1<Object, Boolean> _function_3 = new Functions.Function1<Object, Boolean>(){

                        public Boolean apply(Object e) {
                            return scenarioReversed.indexOf(e) > scenarioReversed.indexOf(entry) && e instanceof ECommand;
                        }
                    };
                    Object command = IterableExtensions.findFirst((Iterable)scenarioReversed, (Functions.Function1)_function_3);
                    int commandIndex = scenario.indexOf(command);
                    Functions.Function1<EArgument, Boolean> _function_4 = new Functions.Function1<EArgument, Boolean>(){

                        public Boolean apply(EArgument e) {
                            return !Objects.equal((Object)e.direction, (Object)"in") && !Objects.equal((Object)e.type, (Object)EVariableType.ANY);
                        }
                    };
                    Iterable arguments_1 = IterableExtensions.filter((Iterable)((EReply)entry).arguments, (Functions.Function1)_function_4);
                    boolean checkReturnValue = ((EReply)entry).returnValue != null && !Objects.equal((Object)((EReply)entry).returnValue.type, (Object)EVariableType.ANY);
                    String _body_3 = body;
                    StringConcatenation _builder_4 = new StringConcatenation();
                    for (EArgument argument : arguments_1) {
                        _builder_4.append("Assertions.assertEquals(");
                        String _value_1 = JavaTestCases.getValue(argument);
                        _builder_4.append(_value_1);
                        _builder_4.append(", result");
                        _builder_4.append((Object)commandIndex);
                        _builder_4.append(".arguments.get(");
                        int _indexOf = ((EReply)entry).arguments.indexOf(argument);
                        _builder_4.append((Object)_indexOf);
                        _builder_4.append("));");
                        _builder_4.newLineIfNotEmpty();
                    }
                    if (checkReturnValue) {
                        _builder_4.append("Assertions.assertEquals(");
                        String _value_2 = JavaTestCases.getValue(((EReply)entry).returnValue);
                        _builder_4.append(_value_2);
                        _builder_4.append(", result");
                        _builder_4.append((Object)commandIndex);
                        _builder_4.append(".returnValue);");
                        _builder_4.newLineIfNotEmpty();
                    }
                    body = String.valueOf(_body_3) + _builder_4;
                    String _description_3 = description;
                    StringConcatenation _builder_5 = new StringConcatenation();
                    for (EArgument argument_1 : arguments_1) {
                        _builder_5.append("- Parameter ");
                        int _indexOf_1 = ((EReply)entry).arguments.indexOf(argument_1);
                        int _plus = _indexOf_1 + 1;
                        _builder_5.append((Object)_plus);
                        _builder_5.append(": ");
                        _builder_5.append(argument_1.value);
                        _builder_5.newLineIfNotEmpty();
                    }
                    if (checkReturnValue) {
                        _builder_5.append("- Return value: ");
                        _builder_5.append(((EReply)entry).returnValue.value);
                        _builder_5.newLineIfNotEmpty();
                    }
                    description = String.valueOf(_description_3) + _builder_5;
                    continue;
                }
                if (entry instanceof ENotification) {
                    boolean _not_2;
                    boolean _not_1;
                    Functions.Function1<EArgument, String> _function_5 = new Functions.Function1<EArgument, String>(){

                        public String apply(EArgument v) {
                            return JavaTestCases.getValue(v);
                        }
                    };
                    String arguments_2 = IterableExtensions.join((Iterable)ListExtensions.map((List)((ENotification)entry).arguments, (Functions.Function1)_function_5), (CharSequence)", ");
                    int index_1 = scenario.indexOf(entry);
                    String _body_4 = body;
                    StringConcatenation _builder_6 = new StringConcatenation();
                    _builder_6.append("var result");
                    _builder_6.append((Object)index_1);
                    _builder_6.append(" = adapter.waitForNotification(");
                    String _callAdapter_2 = JavaTestCases.callAdapter(((ENotification)entry).connection, ((ENotification)entry).method);
                    _builder_6.append(_callAdapter_2);
                    boolean _isEmpty_1 = arguments_2.isEmpty();
                    boolean bl = _not_1 = !_isEmpty_1;
                    if (_not_1) {
                        _builder_6.append(", ");
                        _builder_6.append(arguments_2);
                    }
                    _builder_6.append(");");
                    _builder_6.newLineIfNotEmpty();
                    _builder_6.append("Assertions.assertTrue(result");
                    _builder_6.append((Object)index_1);
                    _builder_6.append(");");
                    _builder_6.newLineIfNotEmpty();
                    body = String.valueOf(_body_4) + _builder_6;
                    String _description_4 = description;
                    StringConcatenation _builder_7 = new StringConcatenation();
                    _builder_7.append("- Notification ");
                    String _callDescription_4 = JavaTestCases.callDescription(((ENotification)entry).connection, ((ENotification)entry).method);
                    _builder_7.append(_callDescription_4);
                    boolean _isEmpty_2 = arguments_2.isEmpty();
                    boolean bl2 = _not_2 = !_isEmpty_2;
                    if (_not_2) {
                        _builder_7.append(" with value ");
                        _builder_7.append(arguments_2);
                    }
                    _builder_7.newLineIfNotEmpty();
                    description = String.valueOf(_description_4) + _builder_7;
                    continue;
                }
                throw new Exception("Not supported");
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/*");
            _builder.newLine();
            String[] stringArray = _split = description.trim().split("\n");
            int n = _split.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                _builder.append(" ");
                _builder.append("* ");
                _builder.append(line);
                _builder.newLineIfNotEmpty();
                ++n2;
            }
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.newLine();
            String _trim = body.trim();
            _builder.append(_trim);
            _builder.newLineIfNotEmpty();
            _xblockexpression = _builder;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Iterable<Object> getNotifications(final ArrayList<Object> scenario, final Object entry) {
        Functions.Function1<Object, Boolean> _function = new Functions.Function1<Object, Boolean>(){

            public Boolean apply(Object e) {
                return scenario.indexOf(e) > scenario.indexOf(entry) && (e instanceof ESignal || e instanceof ECommand);
            }
        };
        Object nextTrigger = IterableExtensions.findFirst(scenario, (Functions.Function1)_function);
        int _xifexpression = 0;
        _xifexpression = nextTrigger == null ? ((Object[])Conversions.unwrapArray(scenario, Object.class)).length : scenario.indexOf(nextTrigger);
        final int nextTriggerIndex = _xifexpression;
        Functions.Function1<Object, Boolean> _function_1 = new Functions.Function1<Object, Boolean>(){

            public Boolean apply(Object e) {
                return e instanceof ENotification && scenario.indexOf(e) > scenario.indexOf(entry) && scenario.indexOf(e) < nextTriggerIndex;
            }
        };
        return IterableExtensions.filter(scenario, (Functions.Function1)_function_1);
    }
}

