/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.source;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SQLCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension {
    public static final int PROPOSAL_TYPE_UNSPECIFIED = 0;
    public static final int PROPOSAL_TYPE_SYNTAX = 1;
    public static final int PROPOSAL_TYPE_SCHEMA = 2;
    public static final int PROPOSAL_TYPE_TABLE = 3;
    public static final int PROPOSAL_TYPE_COLUMN = 4;
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fDocumentOffset = -1;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private int fContextInformationPosition;
    private char[] fTriggerCharacters;
    private String fAdditionalProposalInfo;
    private int fProposalType;

    public SQLCompletionProposal(String replacementString, int replacementOffset, int documentOffset, int replacementLength, Image image, String displayString, IContextInformation contextInformation) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((documentOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fDocumentOffset = documentOffset;
        this.fReplacementLength = replacementLength;
        this.fImage = image;
        this.fDisplayString = displayString != null ? displayString : replacementString;
        this.fCursorPosition = replacementString.length();
        this.fContextInformation = contextInformation;
        this.fTriggerCharacters = null;
        this.fAdditionalProposalInfo = null;
        this.fProposalType = 0;
    }

    public SQLCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fDocumentOffset = this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.fProposalType = 0;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformation = contextInformation;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    public void setTriggerCharacters(char[] triggerCharacters) {
        this.fTriggerCharacters = triggerCharacters;
    }

    public void setCursorPosition(int cursorPosition) {
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = cursorPosition;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            int delta = offset - (this.fDocumentOffset + this.fReplacementLength);
            if (delta > 0) {
                this.fReplacementLength += delta;
            }
            if (trigger == '\u0000') {
                this.replace(document, this.fDocumentOffset, this.fReplacementLength, this.fReplacementString);
            } else {
                StringBuffer buffer = new StringBuffer(this.fReplacementString);
                if (this.fReplacementLength < buffer.length() && buffer.charAt(this.fReplacementLength) != trigger) {
                    buffer.insert(this.fCursorPosition, trigger);
                    ++this.fCursorPosition;
                }
                this.replace(document, this.fDocumentOffset, this.fReplacementLength, buffer.toString());
            }
            int oldLen = document.getLength();
            this.fDocumentOffset += document.getLength() - oldLen;
        }
        catch (BadLocationException badLocationException) {}
    }

    private void replace(IDocument document, int offset, int length, String string) throws BadLocationException {
        if (!document.get(offset, length).equals(string)) {
            document.replace(offset, length, string);
        }
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', this.fDocumentOffset + this.fReplacementLength);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fDocumentOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public int getContextInformationPosition() {
        return this.fReplacementOffset + this.fContextInformationPosition;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public void setReplacementOffset(int replacementOffset) {
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        this.fReplacementOffset = replacementOffset;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementLength = replacementLength;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public void setReplacementString(String replacementString) {
        this.fReplacementString = replacementString;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public boolean isValidFor(IDocument document, int offset) {
        int replacementLength;
        if (offset < this.fReplacementOffset) {
            return false;
        }
        int n = replacementLength = this.fReplacementString == null ? 0 : this.fReplacementString.length();
        if (offset >= this.fReplacementOffset + replacementLength) {
            return false;
        }
        try {
            int length = offset - this.fReplacementOffset;
            String start = document.get(this.fReplacementOffset, length);
            return this.fReplacementString.substring(0, length).equalsIgnoreCase(start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public int getProposalType() {
        return this.fProposalType;
    }

    public void setProposalType(int proposalType) {
        this.fProposalType = proposalType;
    }
}

