/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Font;
import java.io.IOException;

public enum StandardFonts {
    COURIER(0, 0),
    COURIER_ITALIC(0, 2),
    COURIER_BOLD(0, 1),
    COURIER_BOLDITALIC(0, 3),
    LIBERATION_MONO("font-fallback/LiberationMono-Regular.ttf"),
    LIBERATION_MONO_ITALIC("font-fallback/LiberationMono-Italic.ttf"),
    LIBERATION_MONO_BOLD("font-fallback/LiberationMono-Bold.ttf"),
    LIBERATION_MONO_BOLDITALIC("font-fallback/LiberationMono-BoldItalic.ttf"),
    HELVETICA(1, 0),
    HELVETICA_ITALIC(1, 2),
    HELVETICA_BOLD(1, 1),
    HELVETICA_BOLDITALIC(1, 3),
    LIBERATION_SANS("font-fallback/LiberationSans-Regular.ttf"),
    LIBERATION_SANS_ITALIC("font-fallback/LiberationSans-Italic.ttf"),
    LIBERATION_SANS_BOLD("font-fallback/LiberationSans-Bold.ttf"),
    LIBERATION_SANS_BOLDITALIC("font-fallback/LiberationSans-BoldItalic.ttf"),
    TIMES(2, 0),
    TIMES_ITALIC(2, 2),
    TIMES_BOLD(2, 1),
    TIMES_BOLDITALIC(2, 3),
    LIBERATION_SERIF("font-fallback/LiberationSerif-Regular.ttf"),
    LIBERATION_SERIF_ITALIC("font-fallback/LiberationSerif-Italic.ttf"),
    LIBERATION_SERIF_BOLD("font-fallback/LiberationSerif-Bold.ttf"),
    LIBERATION_SERIF_BOLDITALIC("font-fallback/LiberationSerif-BoldItalic.ttf"),
    SYMBOL(3, -1),
    ZAPFDINGBATS(4, -1);

    private int family;
    private int style;
    @Deprecated
    private String trueTypeFile;

    private StandardFonts(int family, int style) {
        this.family = family;
        this.style = style;
    }

    @Deprecated
    private StandardFonts(String trueTypeFile) {
        this.trueTypeFile = trueTypeFile;
    }

    public Font create() throws IOException {
        return this.create(12);
    }

    public Font create(int size) throws IOException {
        if (this.trueTypeFile != null) {
            String message = String.format("%s: Please use fonts from openpdf-fonts-extra (Liberation)", new Object[]{this});
            throw new IOException(message);
        }
        Font font = this.style == -1 ? new Font(this.family, (float)size) : new Font(this.family, (float)size, this.style);
        return font;
    }

    public boolean isDeprecated() {
        return this.trueTypeFile != null;
    }
}

