/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableCorrelation;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.helper.JoinHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ColumnEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ISQLEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.SQLRootEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.figures.TableFrameBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LabeledBorder;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;

public class TableEditPart
extends AbstractGraphicalEditPart
implements ISQLEditPart {
    private static Font titleFont = JFaceResources.getTextFont();
    private SQLDomainModel domainModel;

    public TableEditPart(SQLDomainModel model) {
        this.domainModel = model;
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
    }

    public DragTracker getDragTracker(Request req) {
        return super.getDragTracker(req);
    }

    @Override
    public SQLQueryObject getStatement() {
        return (SQLQueryObject)this.getMyRoot().getModel();
    }

    public EditPart getMyRoot() {
        EditPart part = this.getParent();
        while (!(part instanceof SQLRootEditPart) && part != null) {
            part = this.getParent();
        }
        return part;
    }

    protected void createEditPolicies() {
        ResizableEditPolicy policy = new ResizableEditPolicy();
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)policy);
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)policy);
    }

    public IFigure getContentPane() {
        return ((ScrollPane)this.getFigure()).getContents();
    }

    protected IFigure createFigure() {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(13, 13));
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(13, 13));
        scrollPane.getVerticalScrollBar().setStepIncrement(17);
        TableFrameBorder frameBorder = new TableFrameBorder();
        frameBorder.setFont(titleFont);
        scrollPane.setBorder((Border)frameBorder);
        Panel contents = new Panel();
        contents.setBorder((Border)new MarginBorder(new Insets(2, 2, 0, 0)));
        contents.setBackgroundColor(ColorConstants.white);
        FlowLayout flowLayout = new FlowLayout(false);
        flowLayout.setMajorSpacing(1);
        flowLayout.setMinorSpacing(0);
        flowLayout.setStretchMinorAxis(true);
        contents.setLayoutManager((LayoutManager)flowLayout);
        scrollPane.setContents((IFigure)contents);
        this.refreshTitleBar((IFigure)scrollPane);
        return scrollPane;
    }

    protected List getModelChildren() {
        TableExpression tableExpr;
        EList colList;
        ArrayList columnList = new ArrayList();
        Object model = this.getModel();
        if (model instanceof TableExpression && (colList = (tableExpr = (TableExpression)model).getColumnList()) != null) {
            columnList.addAll(colList);
        }
        return columnList;
    }

    protected EditPart createChild(Object model) {
        ColumnEditPart part = new ColumnEditPart(model, this, this.domainModel);
        part.setModel(model);
        return part;
    }

    public Table getTable() {
        Object model = this.getModel();
        Table table = null;
        if (model instanceof Table) {
            table = (Table)model;
        } else if (model instanceof TableExpression) {
            TableExpression tableExpr = (TableExpression)model;
            table = TableHelper.getTableForTableExpression((TableExpression)tableExpr);
        }
        return table;
    }

    String getTableAliasName() {
        String name = this.getTableAlias().getName();
        if (name == null) {
            return "";
        }
        return name;
    }

    public TableCorrelation getTableAlias() {
        TableExpression tableExpr = (TableExpression)this.getModel();
        return tableExpr.getTableCorrelation();
    }

    List getLeftJoinTables() {
        Object model = this.getModel();
        List list = new ArrayList();
        if (model instanceof TableExpression) {
            TableExpression tableExpr = (TableExpression)model;
            list = JoinHelper.getLeftJoinsForTable((TableExpression)tableExpr);
        }
        return list;
    }

    List getRightJoinTables() {
        Object model = this.getModel();
        List list = new ArrayList();
        if (model instanceof TableExpression) {
            TableExpression tableExpr = (TableExpression)model;
            list = JoinHelper.getRightJoinsForTable((TableExpression)tableExpr);
        }
        return list;
    }

    public void update(Object child) {
        List childList = this.getChildren();
        int i = 0;
        while (i < childList.size()) {
            ColumnEditPart editPart = (ColumnEditPart)childList.get(i);
            editPart.update(child);
            ++i;
        }
        if (child == null || child.equals(this.getModel())) {
            this.refreshTitleBar();
        }
    }

    private void refreshTitleBar() {
        this.refreshTitleBar(this.getFigure());
    }

    private void refreshTitleBar(IFigure fig) {
        String name = "";
        Object model = this.getModel();
        if (model instanceof Table) {
            name = ((Table)model).getName();
        } else if (model instanceof TableExpression) {
            TableExpression tableExpr = (TableExpression)model;
            name = TableHelper.getExposedTableName((TableExpression)tableExpr);
        }
        if (fig.getBorder() instanceof LabeledBorder) {
            ((LabeledBorder)fig.getBorder()).setLabel(name);
            fig.repaint();
        }
    }

    protected IFigure getLayer(Object layer) {
        return super.getLayer(layer);
    }
}

