/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.ui.preferences.dialog;

import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeySequenceText;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class KeyBindingFieldEditor
extends StringFieldEditor {
    private KeySequenceText m_keySequenceText;

    public KeyBindingFieldEditor(String i_name, String i_label, Composite i_parent) {
        super(i_name, i_label, i_parent);
    }

    protected void doFillIntoGrid(Composite i_parent, int i_numColumns) {
        super.doFillIntoGrid(i_parent, i_numColumns);
        this.m_keySequenceText = new KeySequenceText(this.getTextControl(i_parent));
    }

    protected void doLoad() {
        String name = this.getPreferenceName();
        String string = this.getPreferenceStore().getString(name);
        this.loadKeySequence(string);
    }

    protected void doLoadDefault() {
        String name = this.getPreferenceName();
        String string = this.getPreferenceStore().getDefaultString(name);
        this.loadKeySequence(string);
    }

    protected void doStore() {
        KeySequence keySequence = this.m_keySequenceText.getKeySequence();
        String name = this.getPreferenceName();
        this.getPreferenceStore().setValue(name, keySequence.toString());
    }

    private void loadKeySequence(String string) {
        try {
            KeySequence keySequence = KeySequence.getInstance((String)string);
            this.m_keySequenceText.setKeySequence(keySequence);
        }
        catch (ParseException ex) {
            throw new RuntimeException("Unable to parse key sequence for preference " + this.getPreferenceName() + ": " + string, ex);
        }
    }

    public void setKeyStrokeLimit(int i_keyStrokeLimit) {
        this.m_keySequenceText.setKeyStrokeLimit(i_keyStrokeLimit);
    }
}

