/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import org.eclipse.draw3d.geometry.Host3D;
import org.eclipse.draw3d.geometry.IHost3D;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Matrix4fImpl;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Position3DImpl;
import org.eclipse.draw3d.geometry.Transformable;

public class Position3DUtil {
    public static Position3D createAbsolutePosition() {
        return new Position3DImpl();
    }

    public static Position3D createRelativePosition(IHost3D parent) {
        if (parent == null) {
            throw new NullPointerException("parent must not be null");
        }
        return new Host3D(parent).getPosition3D();
    }

    public static IMatrix4f getParentRotationLocationMatrix(IPosition3D i_position3D) {
        Position3D parentPosition3D;
        IHost3D parent;
        if (i_position3D == null) {
            throw new NullPointerException("i_position3D must not be null");
        }
        IHost3D host = i_position3D.getHost();
        if (host != null && (parent = host.getParentHost3D()) != null && (parentPosition3D = parent.getPosition3D()) != null) {
            return parentPosition3D.getRotationLocationMatrix();
        }
        return IMatrix4f.IDENTITY;
    }

    public static void transformFromParent(IPosition3D position3D, Transformable i_transformable) {
        IVector3f location3D = position3D.getLocation3D();
        float dX = -location3D.getX();
        float dY = -location3D.getY();
        float dZ = -location3D.getZ();
        i_transformable.translate(dX, dY, dZ);
    }

    public static void transformToAbsolute(IPosition3D position3D, Transformable io_transformable) {
        float xAngle;
        float zAngle;
        IVector3f v = position3D.getRotation3D();
        Matrix4fImpl u = new Matrix4fImpl(IMatrix4f.IDENTITY);
        float yAngle = v.getY();
        if (yAngle != 0.0f) {
            Math3D.rotate(yAngle, IVector3f.Y_AXIS, u, u);
        }
        if ((zAngle = v.getZ()) != 0.0f) {
            Math3D.rotate(zAngle, IVector3f.Z_AXIS, u, u);
        }
        if ((xAngle = v.getX()) != 0.0f) {
            Math3D.rotate(xAngle, IVector3f.X_AXIS, u, u);
        }
        Position3DUtil.transformFromParent(position3D, io_transformable);
        io_transformable.transform(u);
        Position3DUtil.transformToParent(position3D, io_transformable);
        io_transformable.transform(Position3DUtil.getParentRotationLocationMatrix(position3D));
    }

    public static void transformToParent(IPosition3D position3D, Transformable io_transformable) {
        IVector3f location3D = position3D.getLocation3D();
        float dX = location3D.getX();
        float dY = location3D.getY();
        float dZ = location3D.getZ();
        io_transformable.translate(dX, dY, dZ);
    }

    public static void transformToRelative(IPosition3D position3D, Transformable io_transformable) {
        float yAngle;
        float zAngle;
        Matrix4f inverted = Math3D.invert(Position3DUtil.getParentRotationLocationMatrix(position3D), null);
        if (inverted == null) {
            throw new IllegalStateException("loation matrix cannot be inverted");
        }
        io_transformable.transform(inverted);
        IVector3f v = position3D.getRotation3D();
        Matrix4fImpl u = new Matrix4fImpl(IMatrix4f.IDENTITY);
        float xAngle = v.getX();
        if (xAngle != 0.0f) {
            Math3D.rotate(-xAngle, IVector3f.X_AXIS, u, u);
        }
        if ((zAngle = v.getZ()) != 0.0f) {
            Math3D.rotate(-zAngle, IVector3f.Z_AXIS, u, u);
        }
        if ((yAngle = v.getY()) != 0.0f) {
            Math3D.rotate(-yAngle, IVector3f.Y_AXIS, u, u);
        }
        Position3DUtil.transformToParent(position3D, io_transformable);
        io_transformable.transform(u);
        Position3DUtil.transformFromParent(position3D, io_transformable);
    }
}

