/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.testing.ares.presentation;

import org.eclipse.amp.amf.testing.aTest.Model;
import org.eclipse.amp.amf.testing.ares.Run;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class OpenATestHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (element instanceof Model) {
                    Model test = (Model)element;
                    this.openTest(test);
                    continue;
                }
                if (!(element instanceof Run)) continue;
                Run run = (Run)element;
                this.openTest(run.getTest());
            }
        }
        return null;
    }

    private void openTest(Model test) {
        IFile testFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(test.eResource().getURI().toPlatformString(true));
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(testFile), "org.eclipse.amp.amf.testing.ATest");
        }
        catch (PartInitException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

