/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.validation;

import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.structuredtextalgorithm.Messages;
import org.eclipse.fordiac.ide.structuredtextalgorithm.resource.STAlgorithmResource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmBody;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmSource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmSourceElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethodBody;
import org.eclipse.fordiac.ide.structuredtextalgorithm.validation.AbstractSTAlgorithmValidator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreControlFlowValidator;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionPackage;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class STAlgorithmValidator
extends AbstractSTAlgorithmValidator {
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IContainer.Manager containerManager;
    public static final String ISSUE_CODE_PREFIX = "org.eclipse.fordiac.ide.structuredtextalgorithm.";
    public static final String DUPLICATE_METHOD_OR_ALGORITHM_NAME = "org.eclipse.fordiac.ide.structuredtextalgorithm.duplicateAlgorithmOrMethodName";
    public static final String NO_ALGORITHM_FOR_INPUT_EVENT = "org.eclipse.fordiac.ide.structuredtextalgorithm.noAlgorithmForInputEvent";
    public static final String NO_INPUT_EVENT_FOR_ALGORITHM = "org.eclipse.fordiac.ide.structuredtextalgorithm.noInputEventForAlgorithm";
    public static final String VARIABLE_NAME_IN_USE_ON_INTERFACE = "org.eclipse.fordiac.ide.structuredtextalgorithm.variableNameInUseOnInterface";

    @Check
    public void checkControlFlow(STAlgorithmBody body) {
        STCoreControlFlowValidator controlFlowValidator = new STCoreControlFlowValidator((ValidationMessageAcceptor)this);
        controlFlowValidator.validateVariableBlocks((List)body.getVarTempDeclarations());
        controlFlowValidator.validateStatements((List)body.getStatements());
    }

    @Check
    public void checkControlFlow(STMethodBody body) {
        STCoreControlFlowValidator controlFlowValidator = new STCoreControlFlowValidator((ValidationMessageAcceptor)this);
        controlFlowValidator.validateVariableBlocks((List)body.getVarDeclarations());
        controlFlowValidator.validateStatements((List)body.getStatements());
    }

    @Check
    public void checkUniquenessOfVariableNamesInAFunctionBlock(STVarDeclaration varDeclaration) {
        STAlgorithmResource resource;
        LibraryElement libraryElement;
        Resource resource2 = varDeclaration.eResource();
        if (resource2 instanceof STAlgorithmResource && (libraryElement = (resource = (STAlgorithmResource)resource2).getInternalLibraryElement()) instanceof BaseFBType) {
            BaseFBType baseFBType = (BaseFBType)libraryElement;
            String name = varDeclaration.getName();
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInterfaceList().getEventInputs(), Messages.STAlgorithmValidator_NameUsedAsEventInput);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInterfaceList().getInputVars(), Messages.STAlgorithmValidator_NameUsedAsDataInput);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInterfaceList().getEventOutputs(), Messages.STAlgorithmValidator_NameUsedAsEventOutput);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInterfaceList().getOutputVars(), Messages.STAlgorithmValidator_NameUsedAsDataOutput);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInternalVars(), Messages.STAlgorithmValidator_NameUsedAsVariable);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInternalConstVars(), Messages.STAlgorithmValidator_NameUsedAsConstant);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInternalFbs(), Messages.STAlgorithmValidator_NameUsedAsFunctionBlockVariable);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getAlgorithm(), Messages.STAlgorithmValidator_NameUsedAsAlgorithm);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getMethods(), Messages.STAlgorithmValidator_NameUsedAsMethod);
        }
    }

    private void checkUniquenessOfVariableNamesInAFunctionBlock(String name, Collection<? extends INamedElement> list, String message) {
        if (list.stream().anyMatch(it -> it.getName().equalsIgnoreCase(name))) {
            this.error(MessageFormat.format(message, name), (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, VARIABLE_NAME_IN_USE_ON_INTERFACE, new String[]{name});
        }
    }

    @Check
    public void checkUniqunessOfSTAlgorithmSourceElementNames(STAlgorithmSourceElement sourceElement) {
        EObject eObject = sourceElement.eContainer();
        if (eObject instanceof STAlgorithmSource) {
            STAlgorithmSource source = (STAlgorithmSource)eObject;
            String name = sourceElement.getName();
            if (source.getElements().stream().anyMatch(it -> it != sourceElement && it.getName().equalsIgnoreCase(name))) {
                this.error(MessageFormat.format(Messages.STAlgorithmValidator_DuplicateMethodOrAlgorithmName, name), (EObject)sourceElement, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, DUPLICATE_METHOD_OR_ALGORITHM_NAME, new String[]{name});
            }
        }
    }

    @Check
    public void checkUniquenessOfSTAlgorithmSourceElementNamesAndFunctionNames(STFeatureExpression featureExpression) {
        if (featureExpression.getFeature() instanceof STMethod) {
            IResourceDescriptions resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions(featureExpression.getFeature().eResource());
            IResourceDescription resourceDescription = resourceDescriptions.getResourceDescription(featureExpression.getFeature().eResource().getURI());
            for (IContainer container : this.containerManager.getVisibleContainers(resourceDescription, resourceDescriptions)) {
                for (IEObjectDescription description : container.getExportedObjectsByType(STFunctionPackage.Literals.ST_FUNCTION)) {
                    if (!featureExpression.getFeature().getName().equalsIgnoreCase(description.getQualifiedName().toString()) || description.getEObjectURI().equals(EcoreUtil.getURI((EObject)featureExpression))) continue;
                    this.warning(MessageFormat.format(Messages.STAlgorithmValidator_UnqualifiedMethodOrAlgorithmShadowingFunction, featureExpression.getFeature().getName(), description.getEObjectURI().toPlatformString(true)), (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE);
                }
            }
        }
    }

    @Check
    public void checkAlgorithmForSimpleECAction(STAlgorithmSource source) {
        STAlgorithmResource resource;
        LibraryElement libraryElement;
        Resource resource2 = source.eResource();
        if (resource2 instanceof STAlgorithmResource && (libraryElement = (resource = (STAlgorithmResource)resource2).getInternalLibraryElement()) instanceof SimpleFBType) {
            SimpleFBType simpleFBType = (SimpleFBType)libraryElement;
            simpleFBType.getSimpleECStates().stream().flatMap(state -> state.getSimpleECActions().stream()).filter(action -> {
                if (!simpleFBType.getAlgorithm().stream().noneMatch(alg -> alg.getName().equalsIgnoreCase(action.getAlgorithm()))) return false;
                if (!source.getElements().stream().filter(STAlgorithm.class::isInstance).noneMatch(alg -> alg.getName().equalsIgnoreCase(action.getAlgorithm()))) return false;
                return true;
            }).forEach(action -> this.acceptError(MessageFormat.format(Messages.STAlgorithmValidator_MissingAlgorithmForECState, action.getAlgorithm(), action.getSimpleECState().getName()), (EObject)source, 0, 0, NO_ALGORITHM_FOR_INPUT_EVENT, new String[]{action.getSimpleECState().getName()}));
        }
    }

    @Check
    public void checkUnusedAlgorithm(STAlgorithm algorithm) {
        SimpleFBType simpleFBType;
        STAlgorithmResource resource;
        LibraryElement libraryElement;
        Resource resource2 = algorithm.eResource();
        if (resource2 instanceof STAlgorithmResource && (libraryElement = (resource = (STAlgorithmResource)resource2).getInternalLibraryElement()) instanceof SimpleFBType && (simpleFBType = (SimpleFBType)libraryElement).getSimpleECStates().stream().flatMap(state -> state.getSimpleECActions().stream()).noneMatch(action -> action.getAlgorithm().equalsIgnoreCase(algorithm.getName()))) {
            this.warning(MessageFormat.format(Messages.STAlgorithmValidator_UnusedAlgorithm, algorithm.getName()), (EObject)algorithm, (EStructuralFeature)LibraryElementPackage.eINSTANCE.getINamedElement_Name(), NO_INPUT_EVENT_FOR_ALGORITHM, new String[]{algorithm.getName()});
        }
    }
}

