/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.ui.quickfix;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.model.commands.create.AddNewImportCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateInternalVariableCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateVarInOutCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.structuredtextalgorithm.resource.STAlgorithmResource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmFactory;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmSource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.Messages;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.STAlgorithmEditorUtils;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCoreFactory;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarTempDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.VarDeclarationKind;
import org.eclipse.fordiac.ide.structuredtextcore.ui.quickfix.STCoreQuickfixProvider;
import org.eclipse.gef.commands.Command;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class STAlgorithmQuickfixProvider
extends STCoreQuickfixProvider {
    @Fix(value="org.eclipse.fordiac.ide.structuredtextalgorithm.noAlgorithmForInputEvent")
    public static void fixNoAlgorithmForInputEvent(Issue issue, IssueResolutionAcceptor acceptor) {
        String eventName = issue.getData()[0];
        acceptor.accept(issue, MessageFormat.format(Messages.STAlgorithmQuickfixProvider_Add_missing_algorithm, eventName), MessageFormat.format(Messages.STAlgorithmQuickfixProvider_Add_missing_algorithm_for_input_event, eventName), null, (element, context) -> {
            if (element instanceof STAlgorithmSource) {
                STAlgorithmSource source = (STAlgorithmSource)element;
                STAlgorithm algorithm = STAlgorithmFactory.eINSTANCE.createSTAlgorithm();
                algorithm.setName(eventName);
                algorithm.setBody(STAlgorithmFactory.eINSTANCE.createSTAlgorithmBody());
                source.getElements().add((Object)algorithm);
            }
        });
    }

    @Fix(value="org.eclipse.fordiac.ide.structuredtextalgorithm.noInputEventForAlgorithm")
    public static void fixNoInputEventForAlgorithm(Issue issue, IssueResolutionAcceptor acceptor) {
        String name = issue.getData()[0];
        acceptor.accept(issue, MessageFormat.format(Messages.STAlgorithmQuickfixProvider_Remove_unused_algorithm, name), MessageFormat.format(Messages.STAlgorithmQuickfixProvider_Remove_unused_algorithm_for_input_event, name), null, (element, context) -> {
            EObject eObject = element.eContainer();
            if (eObject instanceof STAlgorithmSource) {
                STAlgorithmSource source = (STAlgorithmSource)eObject;
                source.getElements().remove((Object)element);
            }
        });
        acceptor.accept(issue, Messages.STAlgorithmQuickfixProvider_Remove_all_unused_algorithms, Messages.STAlgorithmQuickfixProvider_Remove_all_unused_algorithms, null, (element, context) -> {
            STAlgorithmResource resource;
            LibraryElement libraryElement;
            STAlgorithmSource source;
            Resource resource2;
            EObject eObject = element.eContainer();
            if (eObject instanceof STAlgorithmSource && (resource2 = (source = (STAlgorithmSource)eObject).eResource()) instanceof STAlgorithmResource && (libraryElement = (resource = (STAlgorithmResource)resource2).getLibraryElement()) instanceof SimpleFBType) {
                SimpleFBType fbType = (SimpleFBType)libraryElement;
                source.getElements().removeIf(sourceElement -> sourceElement instanceof STAlgorithm && fbType.getInterfaceList().getEventInputs().stream().noneMatch(event -> Objects.equals(sourceElement.getName(), event.getName())));
            }
        });
    }

    @Fix(value="org.eclipse.xtext.diagnostics.Diagnostic.Linking")
    public void createMissingVariable(Issue issue, IssueResolutionAcceptor acceptor) {
        super.createMissingVariable(issue, acceptor);
        acceptor.accept(issue, Messages.STAlgorithmQuickfixProvider_CreateMissingInternalVariable, Messages.STAlgorithmQuickfixProvider_CreateMissingInternalVariable, null, (element, context) -> this.createMissingVariable(element, VarDeclarationKind.PLAIN));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void createMissingVariable(ICallable callable, String name, INamedElement type, VarDeclarationKind kind) {
        if (callable instanceof STAlgorithm) {
            STAlgorithm algorithm = (STAlgorithm)callable;
            if (kind == VarDeclarationKind.TEMP) {
                STAlgorithmQuickfixProvider.createSTVarTempDeclaration((EList<STVarTempDeclarationBlock>)algorithm.getBody().getVarTempDeclarations(), name, type);
                return;
            }
        }
        if (callable instanceof STMethod) {
            STMethod method = (STMethod)callable;
            if (kind != VarDeclarationKind.PLAIN) {
                STAlgorithmQuickfixProvider.createSTVarDeclaration((EList)method.getBody().getVarDeclarations(), (String)name, (INamedElement)type, (VarDeclarationKind)kind);
                return;
            }
        }
        STAlgorithmQuickfixProvider.createVarDeclaration(callable, name, type, kind);
    }

    protected static void createVarDeclaration(ICallable callable, String name, INamedElement type, VarDeclarationKind kind) {
        LibraryElementXtextResource resource;
        LibraryElement libraryElement;
        Resource resource2 = callable.eResource();
        if (resource2 instanceof LibraryElementXtextResource && (libraryElement = (resource = (LibraryElementXtextResource)resource2).getLibraryElement()) instanceof BaseFBType) {
            BaseFBType baseFBType = (BaseFBType)libraryElement;
            if (type instanceof DataType) {
                DataType dataType = (DataType)type;
                URI uRI = resource.getURI();
                STAlgorithmEditorUtils.executeCommand(uRI, (Command)(switch (kind) {
                    case VarDeclarationKind.INPUT -> new CreateInterfaceElementCommand(dataType, name, baseFBType.getInterfaceList(), true, -1);
                    case VarDeclarationKind.INOUT -> new CreateVarInOutCommand(dataType, name, baseFBType.getInterfaceList(), -1);
                    case VarDeclarationKind.OUTPUT -> new CreateInterfaceElementCommand(dataType, name, baseFBType.getInterfaceList(), false, -1);
                    case VarDeclarationKind.PLAIN -> new CreateInternalVariableCommand(baseFBType, -1, name, dataType);
                    default -> null;
                }));
            }
        }
    }

    protected static void createSTVarTempDeclaration(EList<STVarTempDeclarationBlock> blocks, String name, INamedElement type) {
        STVarTempDeclarationBlock block = STAlgorithmQuickfixProvider.getOrCreateSTVarTempDeclarationBlock(blocks);
        STVarDeclaration varDeclaration = STAlgorithmQuickfixProvider.createSTVarDeclaration((String)name, (INamedElement)type);
        block.getVarDeclarations().add((Object)varDeclaration);
    }

    protected static STVarTempDeclarationBlock getOrCreateSTVarTempDeclarationBlock(EList<STVarTempDeclarationBlock> blocks) {
        return blocks.stream().filter(Predicate.not(STVarDeclarationBlock::isConstant)).findFirst().orElseGet(() -> {
            STVarTempDeclarationBlock block = STCoreFactory.eINSTANCE.createSTVarTempDeclarationBlock();
            blocks.add((Object)block);
            return block;
        });
    }

    protected void createImportProposal(Issue issue, String label, String importedNamespace, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, label, label, null, (element, context) -> {
            Resource resource = element.eResource();
            if (resource instanceof STAlgorithmResource) {
                STAlgorithmResource resource2 = (STAlgorithmResource)resource;
                STAlgorithmEditorUtils.executeCommand(resource2.getURI(), (Command)new AddNewImportCommand(resource2.getLibraryElement(), importedNamespace));
            }
        }, 100);
    }
}

