/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.transport.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import java.util.List;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfig;
import org.eclipse.milo.opcua.stack.client.transport.UaTransportRequest;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcClientHttpCodec
extends MessageToMessageCodec<HttpResponse, UaTransportRequest> {
    private static final AttributeKey<UaTransportRequest> KEY_PENDING_REQUEST = AttributeKey.newInstance((String)"pendingRequest");
    private static final String UABINARY_CONTENT_TYPE = HttpHeaderValues.APPLICATION_OCTET_STREAM.toString();
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final UaStackClientConfig config;
    private final EndpointDescription endpoint;
    private final TransportProfile transportProfile;
    private final UaStackClient client;

    OpcClientHttpCodec(UaStackClient client) {
        this.client = client;
        this.config = client.getConfig();
        this.endpoint = this.config.getEndpoint();
        this.transportProfile = TransportProfile.fromUri((String)this.endpoint.getTransportProfileUri());
    }

    protected void encode(ChannelHandlerContext ctx, UaTransportRequest transportRequest, List<Object> out) throws Exception {
        this.logger.debug("encoding: " + transportRequest.getRequest());
        ctx.channel().attr(KEY_PENDING_REQUEST).set((Object)transportRequest);
        ByteBuf content = Unpooled.buffer();
        switch (this.transportProfile) {
            case HTTPS_UABINARY: {
                OpcUaBinaryStreamEncoder encoder = new OpcUaBinaryStreamEncoder(this.client.getStaticSerializationContext());
                encoder.setBuffer(content);
                encoder.writeMessage(null, (UaMessage)transportRequest.getRequest());
                break;
            }
            case HTTPS_UAXML: {
                throw new UaException(0x80020000L, "no encoder for transport: " + this.transportProfile);
            }
            default: {
                throw new UaException(0x80020000L, "no encoder for transport: " + this.transportProfile);
            }
        }
        String endpointUrl = this.endpoint.getEndpointUrl();
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, EndpointUtil.getPath((String)endpointUrl), content);
        httpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)EndpointUtil.getHost((String)endpointUrl));
        httpRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        httpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)UABINARY_CONTENT_TYPE);
        httpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        httpRequest.headers().set("OPCUA-SecurityPolicy", (Object)this.config.getEndpoint().getSecurityPolicyUri());
        out.add(httpRequest);
    }

    protected void decode(ChannelHandlerContext ctx, HttpResponse httpResponse, List<Object> out) throws Exception {
        this.logger.trace("channelRead0: " + httpResponse);
        UaTransportRequest transportRequest = (UaTransportRequest)ctx.channel().attr(KEY_PENDING_REQUEST).getAndSet(null);
        if (httpResponse instanceof FullHttpResponse) {
            UaResponseMessage responseMessage;
            String contentType = httpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            FullHttpResponse fullHttpResponse = (FullHttpResponse)httpResponse;
            ByteBuf content = fullHttpResponse.content();
            switch (this.transportProfile) {
                case HTTPS_UABINARY: {
                    if (!UABINARY_CONTENT_TYPE.equalsIgnoreCase(contentType)) {
                        throw new UaException(0x80070000L, "unexpected content-type: " + contentType);
                    }
                    OpcUaBinaryStreamDecoder decoder = new OpcUaBinaryStreamDecoder(this.client.getStaticSerializationContext());
                    decoder.setBuffer(content);
                    responseMessage = (UaResponseMessage)decoder.readMessage(null);
                    break;
                }
                case HTTPS_UAXML: {
                    throw new UaException(0x80020000L, "no decoder for transport: " + this.transportProfile);
                }
                default: {
                    throw new UaException(0x80020000L, "no decoder for transport: " + this.transportProfile);
                }
            }
            transportRequest.getFuture().complete(responseMessage);
        } else {
            HttpResponseStatus status = httpResponse.status();
            if (status.equals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE)) {
                transportRequest.getFuture().completeExceptionally(new UaException(2159607808L));
            } else {
                transportRequest.getFuture().completeExceptionally(new UaException(0x80010000L, String.format("%s: %s", status.code(), status.reasonPhrase())));
            }
        }
    }
}

