/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.security.KeyPair;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.client.auth.password.PasswordAuthenticationReporter;
import org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.eclipse.jgit.internal.transport.sshd.CachingKeyPairProvider;
import org.eclipse.jgit.internal.transport.sshd.GssApiWithMicAuthenticationReporter;
import org.eclipse.jgit.internal.transport.sshd.SshdText;

public class AuthenticationLogger {
    private final List<String> messages = new ArrayList<String>();
    private final PublicKeyAuthenticationReporter pubkeyLogger = new PublicKeyAuthenticationReporter(){
        private boolean hasAttempts;

        public void signalAuthenticationAttempt(ClientSession session, String service, KeyPair identity, String signature) throws Exception {
            this.hasAttempts = true;
            String message = identity.getPrivate() == null ? MessageFormat.format(SshdText.get().authPubkeyAttemptAgent, "publickey", KeyUtils.getKeyType((KeyPair)identity), CachingKeyPairProvider.getKeyId(session, identity), signature) : MessageFormat.format(SshdText.get().authPubkeyAttempt, "publickey", KeyUtils.getKeyType((KeyPair)identity), CachingKeyPairProvider.getKeyId(session, identity), signature);
            AuthenticationLogger.this.messages.add(message);
        }

        public void signalAuthenticationExhausted(ClientSession session, String service) throws Exception {
            String message = this.hasAttempts ? MessageFormat.format(SshdText.get().authPubkeyExhausted, "publickey") : MessageFormat.format(SshdText.get().authPubkeyNoKeys, "publickey");
            AuthenticationLogger.this.messages.add(message);
            this.hasAttempts = false;
        }

        public void signalAuthenticationFailure(ClientSession session, String service, KeyPair identity, boolean partial, List<String> serverMethods) throws Exception {
            String message = partial ? MessageFormat.format(SshdText.get().authPubkeyPartialSuccess, "publickey", KeyUtils.getKeyType((KeyPair)identity), CachingKeyPairProvider.getKeyId(session, identity), serverMethods) : MessageFormat.format(SshdText.get().authPubkeyFailure, "publickey", KeyUtils.getKeyType((KeyPair)identity), CachingKeyPairProvider.getKeyId(session, identity));
            AuthenticationLogger.this.messages.add(message);
        }
    };
    private final PasswordAuthenticationReporter passwordLogger = new PasswordAuthenticationReporter(){
        private int attempts;

        public void signalAuthenticationAttempt(ClientSession session, String service, String oldPassword, boolean modified, String newPassword) throws Exception {
            ++this.attempts;
            String message = modified ? MessageFormat.format(SshdText.get().authPasswordChangeAttempt, "password", this.attempts) : MessageFormat.format(SshdText.get().authPasswordAttempt, "password", this.attempts);
            AuthenticationLogger.this.messages.add(message);
        }

        public void signalAuthenticationExhausted(ClientSession session, String service) throws Exception {
            String message = this.attempts > 0 ? MessageFormat.format(SshdText.get().authPasswordExhausted, "password") : MessageFormat.format(SshdText.get().authPasswordNotTried, "password");
            AuthenticationLogger.this.messages.add(message);
            this.attempts = 0;
        }

        public void signalAuthenticationFailure(ClientSession session, String service, String password, boolean partial, List<String> serverMethods) throws Exception {
            String message = partial ? MessageFormat.format(SshdText.get().authPasswordPartialSuccess, "password", serverMethods) : MessageFormat.format(SshdText.get().authPasswordFailure, "password");
            AuthenticationLogger.this.messages.add(message);
        }
    };
    private final GssApiWithMicAuthenticationReporter gssLogger = new GssApiWithMicAuthenticationReporter(){
        private boolean hasAttempts;

        @Override
        public void signalAuthenticationAttempt(ClientSession session, String service, String mechanism) {
            this.hasAttempts = true;
            String message = MessageFormat.format(SshdText.get().authGssApiAttempt, "gssapi-with-mic", mechanism);
            AuthenticationLogger.this.messages.add(message);
        }

        @Override
        public void signalAuthenticationExhausted(ClientSession session, String service) {
            String message = this.hasAttempts ? MessageFormat.format(SshdText.get().authGssApiExhausted, "gssapi-with-mic") : MessageFormat.format(SshdText.get().authGssApiNotTried, "gssapi-with-mic");
            AuthenticationLogger.this.messages.add(message);
            this.hasAttempts = false;
        }

        @Override
        public void signalAuthenticationFailure(ClientSession session, String service, String mechanism, boolean partial, List<String> serverMethods) {
            String message = partial ? MessageFormat.format(SshdText.get().authGssApiPartialSuccess, "gssapi-with-mic", mechanism, serverMethods) : MessageFormat.format(SshdText.get().authGssApiFailure, "gssapi-with-mic", mechanism);
            AuthenticationLogger.this.messages.add(message);
        }
    };

    public AuthenticationLogger(ClientSession session) {
        session.setPublicKeyAuthenticationReporter(this.pubkeyLogger);
        session.setPasswordAuthenticationReporter(this.passwordLogger);
        session.setAttribute(GssApiWithMicAuthenticationReporter.GSS_AUTHENTICATION_REPORTER, (Object)this.gssLogger);
    }

    public List<String> getLog() {
        return Collections.unmodifiableList(this.messages);
    }

    public void clear() {
        this.messages.clear();
    }
}

