/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SGUtils;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.util.SubsetGenerator;

public class SGImprovementCalculator {
    private final Map<SGDescription, SG> cache = new HashMap<SGDescription, SG>();

    public double calculateMinImprovement(SG sg) {
        double minImprovement = Double.MAX_VALUE;
        List<List<SGSelector>> subDescriptions = SubsetGenerator.generateSubset(sg.getSGDescription().getSelectors());
        for (List<SGSelector> selList : subDescriptions) {
            if (selList.size() >= sg.getSGDescription().size()) continue;
            SGDescription sgDescr = new SGDescription();
            sgDescr.addAll(selList);
            SG subSG = this.cache.get(sgDescr);
            if (subSG == null) {
                subSG = new SG(sg.getPopulation(), sg.getTarget(), sgDescr);
                subSG.createStatistics(null);
                this.cache.put(sgDescr, subSG);
            }
            double improvement = sg.getStatistics().getDeviation() - subSG.getStatistics().getDeviation();
            minImprovement = Math.min(minImprovement, improvement);
        }
        return minImprovement;
    }

    public double calculateMaxPValueToSubsets(SG sg) {
        if (sg.getTarget().isNumeric()) {
            throw new IllegalArgumentException("Not applicable for numeric target " + sg.getTarget());
        }
        double maxPValue = Double.MIN_VALUE;
        List<List<SGSelector>> subDescriptions = SubsetGenerator.generateSubset(sg.getSGDescription().getSelectors());
        for (List<SGSelector> selList : subDescriptions) {
            if (selList.size() >= sg.getSGDescription().size()) continue;
            SGDescription sgDescr = new SGDescription();
            sgDescr.addAll(selList);
            SG subSG = this.cache.get(sgDescr);
            if (subSG == null) {
                subSG = new SG(sg.getPopulation(), sg.getTarget(), sgDescr);
                subSG.createStatistics(null);
                this.cache.put(sgDescr, subSG);
            }
            SGStatisticsBinary sgStats = (SGStatisticsBinary)sg.getStatistics();
            SGStatisticsBinary sg2Stats = (SGStatisticsBinary)subSG.getStatistics();
            double a = sgStats.getTp();
            double b = sg2Stats.getTp() - a;
            double c = sgStats.getFp();
            double d = sg2Stats.getFp() - c;
            double significanceOfDifference = SGUtils.getChi2SignificanceNiveau(a, b, c, d);
            maxPValue = Math.max(maxPValue, significanceOfDifference);
        }
        return maxPValue;
    }
}

