/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import java.util.HashSet;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.quality.AbstractQFStatisticBased;

public class DyadicLiftQF
extends AbstractQFStatisticBased {
    private static final String ID = "DyadicLiftQF";
    private static final String NAME = "DyadicLift";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AbstractQFStatisticBased clone() {
        return new DyadicLiftQF();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return true;
    }

    @Override
    public double evaluate(SGStatistics statistics) {
        SG subgroup = statistics.getSubgroup();
        double observedDyads = statistics.getSubgroupSize();
        HashSet<Double> nodes = new HashSet<Double>();
        for (DataRecord record : subgroup) {
            double valSrc = record.getValue(0);
            double valDst = record.getValue(1);
            nodes.add(valSrc);
            nodes.add(valDst);
        }
        int count = nodes.size();
        double expectedDyads = (double)count * (double)(count - 1) / 2.0;
        return Math.abs(observedDyads / expectedDyads);
    }

    public String getDyads(SGStatistics statistics) {
        SG subgroup = statistics.getSubgroup();
        double observedDyads = statistics.getSubgroupSize();
        HashSet<Double> nodes = new HashSet<Double>();
        for (DataRecord record : subgroup) {
            double valSrc = record.getValue(0);
            double valDst = record.getValue(1);
            nodes.add(valSrc);
            nodes.add(valDst);
        }
        int count = nodes.size();
        double expectedDyads = (double)count * (double)(count - 1) / 2.0;
        return String.valueOf(observedDyads) + "\t" + expectedDyads;
    }
}

