/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl.lazyness;

import java.util.ArrayList;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.impl.IntVarLazyLit;
import org.chocosolver.solver.variables.impl.lazyness.ILazyBound;

public class StrongBound
implements ILazyBound {
    final ArrayList<Node> ld = new ArrayList();
    final IStateInt li;
    final IStateInt hi;

    public StrongBound(Model model, int lb, int ub) {
        this.ld.add(new Node(0, lb - 1, -1, 1));
        this.ld.add(new Node(1, ub, 0, -1));
        this.li = model.getEnvironment().makeInt(0);
        this.hi = model.getEnvironment().makeInt(1);
    }

    @Override
    public int currentMinVar() {
        return this.ld.get((int)this.li.get()).var;
    }

    @Override
    public int currentMaxVar() {
        return this.ld.get((int)this.hi.get()).var;
    }

    @Override
    public int getSATVar(int value, IntVarLazyLit cvar, MiniSat sat) {
        int ni = this.getNi(value);
        if (this.ld.get((int)ni).val == value) {
            return this.ld.get((int)ni).var;
        }
        Node node = this.getNode(value, ni, cvar, sat);
        return node.var;
    }

    @Override
    public void channelMin(int value, MiniSat sat, Reason r) {
        int ni = this.ld.get((int)this.li.get()).next;
        while (this.ld.get((int)ni).val < value) {
            sat.cEnqueue(MiniSat.makeLiteral(this.ld.get((int)ni).var, true), r);
            ni = this.ld.get((int)ni).next;
        }
        assert (this.ld.get((int)ni).val == value);
        this.li.set(ni);
    }

    @Override
    public void channelMax(int value, MiniSat sat, Reason r) {
        int ni = this.ld.get((int)this.hi.get()).prev;
        while (this.ld.get((int)ni).val > value) {
            sat.cEnqueue(MiniSat.makeLiteral(this.ld.get((int)ni).var, false), r);
            ni = this.ld.get((int)ni).prev;
        }
        assert (this.ld.get((int)ni).val == value);
        this.hi.set(ni);
    }

    private Node getNode(int value, int ni, IntVarLazyLit cvar, MiniSat sat) {
        int mi = this.getLitNode();
        Node node = this.ld.get(mi);
        node.var = sat.newVariable(new MiniSat.ChannelInfo(cvar, 1, 1, value));
        node.val = value;
        node.next = ni;
        node.prev = this.ld.get((int)ni).prev;
        this.ld.get((int)ni).prev = mi;
        this.ld.get((int)node.prev).next = mi;
        return node;
    }

    private int getNi(int prev) {
        int ni = this.li.get();
        while (this.ld.get((int)ni).val < prev) {
            ni = this.ld.get((int)ni).next;
            assert (0 <= ni && ni < this.ld.size());
        }
        return ni;
    }

    private int getLitNode() {
        this.ld.add(new Node(-1, -1, -1, -1));
        return this.ld.size() - 1;
    }

    private static class Node {
        int var;
        int val;
        int prev;
        int next;

        public Node(int var, int val, int prev, int next) {
            this.var = var;
            this.val = val;
            this.prev = prev;
            this.next = next;
        }
    }
}

