/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.stml;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntArray;
import org.xmlcml.euclid.JodaDate;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.Util;
import org.xmlcml.stml.STMLAttribute;
import org.xmlcml.stml.STMLElement;
import org.xmlcml.stml.STMLScalar;
import org.xmlcml.stml.STMLType;
import org.xmlcml.stml.attribute.DelimiterAttribute;
import org.xmlcml.stml.attribute.NamespaceRefAttribute;
import org.xmlcml.stml.interfacex.HasArraySize;
import org.xmlcml.stml.interfacex.HasDataType;
import org.xmlcml.stml.interfacex.HasDelimiter;
import org.xmlcml.stml.interfacex.HasDictRef;
import org.xmlcml.stml.interfacex.HasUnits;

public class STMLArray
extends STMLElement
implements HasUnits,
HasArraySize,
HasDataType,
HasDictRef,
HasDelimiter {
    private static Logger logger = Logger.getLogger(STMLArray.class);
    public static final String TAG = "array";
    private DelimiterAttribute delimiterAttribute;

    public STMLArray() {
        super(TAG);
        this.init();
    }

    private void init() {
    }

    public STMLArray(STMLArray old) {
        super(old);
        this.init();
    }

    @Override
    public Element copy() {
        return new STMLArray(this);
    }

    public STMLArray(String[] array) throws RuntimeException {
        this.setArray(array);
    }

    public STMLArray(String[] array, String delimiter) throws RuntimeException {
        this.setDelimiter(delimiter);
        this.setArray(array);
    }

    public STMLArray(RealArray array) {
        this.setArray(array.getArray());
    }

    public STMLArray(double[] array) {
        this.setArray(array);
    }

    public STMLArray(boolean[] array) {
        this.setArray(array);
    }

    public STMLArray(double[] array, String delimiter) throws RuntimeException {
        this.setDelimiter(delimiter);
        this.setArray(array);
    }

    public STMLArray(DateTime[] array) {
        this.setArray(array);
    }

    public STMLArray(int[] array) {
        this.setArray(array);
    }

    public STMLArray(int[] array, String delimiter) {
        this.setDelimiter(delimiter);
        this.setArray(array);
    }

    public STMLArray(String dataType) {
        this();
        this.resetDataType(dataType);
    }

    public static STMLArray createArray(List<STMLScalar> scalarList) {
        STMLArray array = null;
        if (scalarList != null && scalarList.size() > 0) {
            STMLScalar scalar = scalarList.get(0);
            if (scalar == null) {
                throw new RuntimeException("Null scalar in list: " + scalarList.size());
            }
            array = STMLArray.createArrayWithAttributes(scalar);
        }
        for (STMLScalar scalar : scalarList) {
            array.append(scalar);
        }
        array.removeWhitespaceDelimiterAttribute();
        return array;
    }

    public static STMLArray createArrayWithAttributes(HasDataType hasDataType) {
        String units;
        String dataType = hasDataType.getDataType();
        if (dataType == null) {
            throw new RuntimeException("Null data type");
        }
        STMLArray array = new STMLArray(dataType);
        String dictRef = hasDataType.getDictRef();
        if (dictRef != null) {
            array.setDictRef(dictRef);
        }
        if ((units = ((HasUnits)((Object)hasDataType)).getUnits()) != null) {
            array.setUnits(units);
        }
        array.removeWhitespaceDelimiterAttribute();
        return array;
    }

    private void setUnits(String units) {
    }

    public STMLArray createEmptyArray(STMLScalar scalar) {
        STMLArray array = null;
        if (scalar != null && scalar.getDataType() != null) {
            array = new STMLArray(scalar.getDataType());
        }
        array.removeWhitespaceDelimiterAttribute();
        return array;
    }

    public STMLArray createSubArray(int start, int end) throws IllegalArgumentException {
        int size = this.getSize();
        if (start < 0 || end >= size || end < start) {
            throw new IllegalArgumentException("bad array slice indexes " + start + "/" + end + " in " + size);
        }
        String dataType = this.getDataType();
        STMLArray subArray = null;
        if (dataType == null || dataType.equals("xsd:string")) {
            String[] sout = new String[end - start + 1];
            String[] ss = this.getStrings();
            for (int i = start; i <= end; ++i) {
                sout[i - start] = ss[i];
            }
            String delimiter = this.getDelimiter();
            subArray = delimiter == null ? new STMLArray(sout) : new STMLArray(sout, delimiter);
        } else if (dataType.equals("xsd:double")) {
            RealArray realArray = new RealArray(this.getDoubles());
            subArray = new STMLArray(realArray.getSubArray(start, end));
        } else if (dataType.equals("xsd:integer")) {
            IntArray intArray = new IntArray(this.getInts());
            subArray = new STMLArray(intArray.getSubArray(start, end).getArray());
        }
        String dictRef = this.getDictRef();
        if (dictRef != null) {
            subArray.setDictRef(dictRef);
        }
        return subArray;
    }

    @Override
    public int getArraySize() {
        return this.getSize();
    }

    public Object getPrimitiveArray() {
        Object[] primitiveArray = null;
        primitiveArray = "xsd:double".equals(this.getDataType()) ? this.getDoubles() : ("xsd:boolean".equals(this.getDataType()) ? (Object[])this.getBooleans() : ("xsd:date".equals(this.getDataType()) ? (Object[])this.getDates() : ("xsd:integer".equals(this.getDataType()) ? (Object[])this.getInts() : ("xsd:string".equals(this.getDataType()) ? (Object[])this.getStrings() : (Object[])this.getStrings()))));
        return primitiveArray;
    }

    public String[] getStrings() {
        String[] ss = null;
        if (this.getDataType().equals("xsd:string")) {
            ss = this.getSplitContent();
        }
        return ss;
    }

    private String[] getSplitContent() throws RuntimeException {
        String[] ss = new String[]{};
        String content = this.getXMLContent();
        if (content != null) {
            content = content.trim();
            this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
            ss = this.delimiterAttribute.getSplitContent(content);
            int size = -1;
            if (this.getSizeAttribute() == null || ss.length != (size = this.getSize())) {
                // empty if block
            }
        }
        this.removeWhitespaceDelimiterAttribute();
        return ss;
    }

    public boolean[] getBooleans() throws RuntimeException {
        boolean[] dd = null;
        String dataType = this.getDataType();
        if (dataType != null && "xsd:boolean".equals(STMLType.getNormalizedValue(dataType))) {
            String[] ss = this.getSplitContent();
            dd = new boolean[ss.length];
            for (int i = 0; i < dd.length; ++i) {
                dd[i] = Boolean.parseBoolean(ss[i]);
            }
        }
        return dd;
    }

    @Override
    public double[] getDoubles() throws RuntimeException {
        double[] dd = null;
        String dataType = this.getDataType();
        if (dataType != null && "xsd:double".equals(STMLType.getNormalizedValue(dataType))) {
            String[] ss = this.getSplitContent();
            dd = new double[ss.length];
            for (int i = 0; i < dd.length; ++i) {
                try {
                    dd[i] = Util.parseFlexibleDouble(ss[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Bad double :" + ss[i] + " at position: " + i, nfe);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Bad double : " + ss[i] + "at position " + i, e);
                }
            }
        }
        return dd;
    }

    public double[] getNumbersAsDoubles() {
        int[] integers;
        double[] doubles = this.getDoubles();
        if (doubles == null && (integers = this.getInts()) != null) {
            RealArray realArray = RealArray.createRealArray(integers);
            doubles = realArray == null ? null : realArray.getArray();
        }
        return doubles;
    }

    public DateTime[] getDates() throws RuntimeException {
        DateTime[] dd = null;
        String dataType = this.getDataType();
        if (dataType != null && "xsd:date".equals(STMLType.getNormalizedValue(dataType))) {
            String[] ss = this.getSplitContent();
            dd = new DateTime[ss.length];
            for (int i = 0; i < dd.length; ++i) {
                dd[i] = JodaDate.parseDate(ss[i]);
            }
        }
        return dd;
    }

    @Override
    public int[] getInts() throws RuntimeException {
        int[] ii = null;
        String dataType = this.getDataType();
        if ("xsd:integer".equals(dataType)) {
            String[] ss = this.getSplitContent();
            ii = new int[ss.length];
            for (int i = 0; i < ii.length; ++i) {
                try {
                    ii[i] = new Integer(ss[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Bad int (" + ss[i] + ") at position: " + i);
                }
            }
        }
        return ii;
    }

    public STMLScalar getElementAt(int i) {
        STMLScalar scalar = null;
        if (i >= 0 && i < this.getSize()) {
            String dataType = this.getDataType();
            if (dataType == null) {
                dataType = "xsd:string";
            }
            if (dataType.equals("xsd:string")) {
                String s = this.getStrings()[i];
                scalar = new STMLScalar(s);
            } else if (dataType.equals("xsd:boolean")) {
                Boolean b = this.getBooleans()[i];
                scalar = new STMLScalar(b);
            } else if (dataType.equals("xsd:date")) {
                DateTime d = this.getDates()[i];
                scalar = new STMLScalar(d);
            } else if (dataType.equals("xsd:double")) {
                Double d = this.getDoubles()[i];
                scalar = new STMLScalar(d);
            } else if (dataType.equals("xsd:integer")) {
                Integer ii = this.getInts()[i];
                scalar = new STMLScalar(ii);
            }
            STMLArray.copyAttributesFromTo(this, scalar);
        }
        return scalar;
    }

    public static void copyAttributesFromTo(Element from, Element to) {
        STMLArray.copyAttributeTo(from, to, "constantToSI");
        STMLArray.copyAttributeTo(from, to, "convention");
        STMLArray.copyAttributeTo(from, to, "dictRef");
        STMLArray.copyAttributeTo(from, to, "id");
        STMLArray.copyAttributeTo(from, to, "multiplierToSI");
        STMLArray.copyAttributeTo(from, to, "title");
        STMLArray.copyAttributeTo(from, to, "units");
    }

    private static void copyAttributeTo(Element from, Element to, String attName) {
        String attVal = from.getAttributeValue(attName);
        if (attVal != null) {
            to.addAttribute(new Attribute(attName, attVal));
        }
    }

    @Override
    public List<String> getStringValues() {
        ArrayList<String> values;
        block4: {
            double[] doubles;
            String dataType;
            block5: {
                int[] ints;
                block3: {
                    String[] strings;
                    values = new ArrayList<String>();
                    dataType = this.getDataType();
                    if (dataType != null && !dataType.equals("xsd:string")) break block3;
                    for (String s : strings = this.getStrings()) {
                        values.add(s);
                    }
                    break block4;
                }
                if (!"xsd:integer".equals(dataType)) break block5;
                for (int i : ints = this.getInts()) {
                    values.add("" + i);
                }
                break block4;
            }
            if (!"xsd:double".equals(dataType)) break block4;
            for (double d : doubles = this.getDoubles()) {
                values.add("" + d);
            }
        }
        return values;
    }

    public void setArray(String[] array) throws RuntimeException {
        this.resetDataType("xsd:string");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        for (String s : array) {
            this.delimiterAttribute.checkDelimiter(s);
        }
        this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(array));
        this.resetSize(array.length);
        this.removeWhitespaceDelimiterAttribute();
    }

    private void resetDataType(String type) {
        Attribute a = this.getAttribute("dataType");
        if (a != null) {
            this.removeAttribute(a);
        }
        super.setDataType(type);
    }

    private void resetSize(int size) {
        Attribute a = this.getAttribute("size");
        if (a != null) {
            this.removeAttribute(a);
        }
        super.setSize(size);
    }

    public void setArray(DateTime[] array) {
        this.resetDataType("xsd:date");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        this.resetSize(array.length);
        throw new RuntimeException("dates in array not fully implemented");
    }

    public void setArray(boolean[] array) {
        this.resetDataType("xsd:boolean");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(array));
        this.resetSize(array.length);
        this.removeWhitespaceDelimiterAttribute();
    }

    public void setArray(double[] array) {
        this.resetDataType("xsd:double");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(array));
        this.resetSize(array.length);
        this.removeWhitespaceDelimiterAttribute();
    }

    public void setArray(int[] array) {
        this.resetDataType("xsd:integer");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(array));
        this.resetSize(array.length);
        this.removeWhitespaceDelimiterAttribute();
    }

    @Override
    public int getSize() {
        int size = -1;
        if (this.getSizeAttribute() != null) {
            size = this.getSize();
        } else {
            String[] array = this.getSplitContent();
            size = array.length;
        }
        return size;
    }

    @Override
    public String getDelimiter() {
        String delimiter = super.getDelimiter();
        if (delimiter == null) {
            this.ensureDelimiterAttribute(DelimiterAttribute.Action.RESET);
            delimiter = this.delimiterAttribute.getValue();
        }
        this.removeWhitespaceDelimiterAttribute();
        return delimiter;
    }

    @Override
    public void setDelimiter(String value) {
        String[] old = this.getSplitContent();
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.RESET);
        this.setDelimiter(value);
        this.delimiterAttribute = (DelimiterAttribute)this.getDelimiterAttribute();
        if (old.length > 0) {
            for (String s : old) {
                this.delimiterAttribute.checkDelimiter(s);
            }
            this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(old));
        }
        this.removeWhitespaceDelimiterAttribute();
    }

    @Override
    public String getDataType() {
        String dataType = this.getDataType();
        if (dataType == null) {
            dataType = "xsd:string";
            super.setDataType(dataType);
        }
        return STMLType.getNormalizedValue(dataType);
    }

    @Override
    public void setDataType(String dType) {
        if (this.getDataTypeAttribute() != null) {
            throw new RuntimeException("Cannot reset dataType");
        }
        super.setDataType(dType);
    }

    @Override
    public void setSize(int s) {
        if (this.getSizeAttribute() != null) {
            throw new RuntimeException("user cannot reset size");
        }
        super.setSize(s);
    }

    public void checkNumericConformability(STMLArray array) {
        String thisDataType = this.getDataType();
        String arrayDataType = array.getDataType();
        if (thisDataType.equals("xsd:string") || !thisDataType.equals(arrayDataType) || this.getSize() != array.getSize()) {
            throw new RuntimeException("Unsuitable dataTypes for numeric operations / " + this.getDataType() + "/" + this.getSize() + "/" + array.getDataType() + "/" + array.getSize());
        }
    }

    public STMLArray subtract(STMLArray array) {
        this.checkNumericConformability(array);
        STMLArray resultArray = null;
        try {
            if (this.getDataType().equals("xsd:double")) {
                RealArray result = new RealArray(array.getDoubles()).subtract(new RealArray(this.getDoubles()));
                resultArray = new STMLArray(result.getArray());
            } else if (this.getDataType().equals("xsd:integer")) {
                IntArray result = new IntArray(array.getInts()).subtract(new IntArray(this.getInts()));
                resultArray = new STMLArray(result.getArray());
            }
        }
        catch (EuclidRuntimeException je) {
            throw new RuntimeException("" + je);
        }
        return resultArray;
    }

    public STMLArray plus(STMLArray array) {
        this.checkNumericConformability(array);
        STMLArray resultArray = null;
        try {
            if (this.getDataType().equals("xsd:double")) {
                RealArray result = new RealArray(this.getDoubles()).plus(new RealArray(array.getDoubles()));
                resultArray = new STMLArray(result.getArray());
            } else if (this.getDataType().equals("xsd:integer")) {
                IntArray result = new IntArray(this.getInts()).plus(new IntArray(array.getInts()));
                resultArray = new STMLArray(result.getArray());
            }
        }
        catch (EuclidRuntimeException je) {
            throw new RuntimeException("" + je);
        }
        return resultArray;
    }

    public void append(String s) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:string".equals(dataType)) {
            throw new RuntimeException("Cannot add string (" + s + ") to array of: " + dataType);
        }
        this.appendXML(s, 1);
    }

    public void append(boolean b) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:boolean".equals(dataType)) {
            throw new RuntimeException("Cannot add boolean to array of: " + dataType);
        }
        this.appendXML("" + b, 1);
    }

    public void append(double d) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:double".equals(dataType)) {
            throw new RuntimeException("Cannot add double to array of: " + dataType);
        }
        this.appendXML(Double.toString(d), 1);
    }

    public void append(int i) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:integer".equals(dataType)) {
            throw new RuntimeException("Cannot add int to array of: " + dataType);
        }
        this.appendXML("" + i, 1);
    }

    public void append(STMLArray array) {
        if (!this.getDataType().equals(array.getDataType())) {
            throw new RuntimeException("Cannot append array of different type: " + this.getDataType() + " != " + array.getDataType());
        }
        if (!this.getDelimiter().equals(array.getDelimiter())) {
            throw new RuntimeException("Cannot append array with different delimiter: " + this.getDelimiter() + " != " + array.getDelimiter());
        }
        if (this.getUnits() != null && !this.getUnits().equals(array.getUnits())) {
            throw new RuntimeException("Cannot append array with different units: " + this.getDelimiter() + " != " + array.getUnits());
        }
        String arrayString = array.getXMLContent();
        String delimiter = this.getDelimiter().trim();
        if (delimiter.length() > 0) {
            arrayString = arrayString.substring(1, arrayString.length() - 1);
        }
        this.appendXML(arrayString, array.getSize());
    }

    private void appendXML(String s, int toAdd) {
        int size = this.getSizeAttribute() == null ? 0 : this.getSize();
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        if (toAdd <= 1) {
            this.delimiterAttribute.checkDelimiter(s);
        }
        String xmlContent = this.getXMLContent();
        String delimitedContent = this.delimiterAttribute.appendXMLContent(xmlContent, s);
        this.setXMLContent(delimitedContent);
        this.resetSize(size + toAdd);
        this.removeWhitespaceDelimiterAttribute();
    }

    public void append(STMLScalar scalar) {
        if (scalar != null) {
            String dataType = this.getDataType();
            if (!dataType.equals(scalar.getDataType())) {
                throw new RuntimeException("Cannot append scalar of different type: " + dataType + " != " + scalar.getDataType());
            }
            if (this.getUnits() != null && !this.getUnits().equals(scalar.getUnits())) {
                throw new RuntimeException("Cannot append scalar with different units: " + this.getDelimiter() + " != " + scalar.getUnits());
            }
            this.append(scalar.getXMLContent(), dataType);
            this.removeWhitespaceDelimiterAttribute();
        }
    }

    private void append(String content, String dataType) {
        if ("xsd:string".equals(dataType)) {
            this.append(content);
        } else if ("xsd:boolean".equals(dataType)) {
            this.append(Boolean.parseBoolean(content));
        } else if ("xsd:date".equals(dataType)) {
            this.append(JodaDate.parseDate(content).toString());
        } else if ("xsd:double".equals(dataType)) {
            this.append(new Double(content));
        } else if ("xsd:integer".equals(dataType)) {
            this.append(new Integer(content));
        }
    }

    public void append(HasDictRef hasDictRef) {
        if (hasDictRef instanceof STMLScalar) {
            this.append((STMLScalar)hasDictRef);
        } else if (hasDictRef instanceof STMLArray) {
            this.append((STMLArray)hasDictRef);
        } else {
            throw new RuntimeException("Cannot add HasDictRef: " + ((STMLElement)((Object)hasDictRef)).getLocalName());
        }
        this.removeWhitespaceDelimiterAttribute();
    }

    @Override
    public void setUnits(String prefix, String id, String namespaceURI) {
        NamespaceRefAttribute.setUnits(this, prefix, id, namespaceURI);
    }

    public void append(DateTime d) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:date".equals(dataType)) {
            throw new RuntimeException("Cannot add date to array of: " + dataType);
        }
        this.appendXML(d.toString(), 1);
    }

    @Override
    public void removeWhitespaceDelimiterAttribute() {
        STMLArray.removeWhitespaceDelimiterAttribute(this);
    }

    public static void removeWhitespaceDelimiterAttribute(HasDelimiter hasDelimiter) {
        Attribute delimiter = hasDelimiter.getDelimiterAttribute();
        if (delimiter != null && delimiter.getValue().trim().length() == 0) {
            delimiter.detach();
        }
    }

    public static List<STMLArray> extractArrays(List<Element> elements) {
        ArrayList<STMLArray> arrayList = new ArrayList<STMLArray>();
        for (Element element : elements) {
            if (!(element instanceof STMLArray)) continue;
            arrayList.add((STMLArray)element);
        }
        return arrayList;
    }

    @Override
    public STMLAttribute getDictRefAttribute() {
        return null;
    }

    @Override
    public String getDictRef() {
        return null;
    }

    @Override
    public void setDictRef(String dictRef) {
    }

    @Override
    public String getXMLContent() {
        return null;
    }

    @Override
    public void setXMLContent(String content) {
    }

    @Override
    public String getUnits() {
        return null;
    }

    public void ensureDelimiterAttribute(DelimiterAttribute.Action action) {
        if (action.equals((Object)DelimiterAttribute.Action.RESET)) {
            this.delimiterAttribute = null;
        }
        this.delimiterAttribute = (DelimiterAttribute)this.getDelimiterAttribute();
        if (this.delimiterAttribute == null) {
            this.delimiterAttribute = new DelimiterAttribute(" ");
            super.setDelimiter(" ");
        }
    }

    @Override
    public STMLAttribute getDataTypeAttribute() {
        return (STMLAttribute)this.getAttribute("dataType");
    }
}

