/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;
import opennlp.tools.coref.resolver.ResolverUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefiniteNounResolver
extends MaxentResolver {
    public DefiniteNounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "defmodel", m, 80);
    }

    public DefiniteNounResolver(String projectName, ResolverMode m, NonReferentialResolver nrr) throws IOException {
        super(projectName, "defmodel", m, 80, nrr);
    }

    @Override
    public boolean canResolve(MentionContext mention) {
        Object[] mtokens = mention.getTokens();
        String firstTok = mention.getFirstTokenText().toLowerCase();
        boolean rv = mtokens.length > 1 && !mention.getHeadTokenTag().startsWith("NNP") && ResolverUtils.definiteArticle(firstTok, mention.getFirstTokenTag());
        return rv;
    }

    @Override
    protected List<String> getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            features.addAll(ResolverUtils.getContextFeatures(mention));
            features.addAll(ResolverUtils.getStringMatchFeatures(mention, entity));
            features.addAll(ResolverUtils.getDistanceFeatures(mention, entity));
        }
        return features;
    }
}

