/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.util.ArrayUnenforcedSet;

public class Subgraph<V, E, G extends Graph<V, E>>
extends AbstractGraph<V, E>
implements Serializable {
    private static final long serialVersionUID = 3208313055169665387L;
    private static final String NO_SUCH_EDGE_IN_BASE = "no such edge in base graph";
    private static final String NO_SUCH_VERTEX_IN_BASE = "no such vertex in base graph";
    Set<E> edgeSet = new LinkedHashSet();
    Set<V> vertexSet = new LinkedHashSet<V>();
    private transient Set<E> unmodifiableEdgeSet = null;
    private transient Set<V> unmodifiableVertexSet = null;
    private G base;
    private boolean isInduced = false;

    public Subgraph(G base, Set<V> vertexSubset, Set<E> edgeSubset) {
        this.base = base;
        if (edgeSubset == null) {
            this.isInduced = true;
        }
        if (base instanceof ListenableGraph) {
            ((ListenableGraph)base).addGraphListener(new BaseGraphListener());
        }
        this.addVerticesUsingFilter(base.vertexSet(), vertexSubset);
        this.addEdgesUsingFilter(base.edgeSet(), edgeSubset);
    }

    public Subgraph(G base, Set<V> vertexSubset) {
        this(base, vertexSubset, null);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        ArrayUnenforcedSet edges = null;
        if (this.containsVertex(sourceVertex) && this.containsVertex(targetVertex)) {
            edges = new ArrayUnenforcedSet();
            Set baseEdges = this.base.getAllEdges(sourceVertex, targetVertex);
            for (Object e : baseEdges) {
                if (!this.edgeSet.contains(e)) continue;
                edges.add(e);
            }
        }
        return edges;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        Set<E> edges = this.getAllEdges(sourceVertex, targetVertex);
        if (edges == null || edges.isEmpty()) {
            return null;
        }
        return edges.iterator().next();
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.base.getEdgeFactory();
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!this.base.containsEdge(sourceVertex, targetVertex)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        Set edges = this.base.getAllEdges(sourceVertex, targetVertex);
        for (Object e : edges) {
            if (this.containsEdge(e)) continue;
            this.edgeSet.add(e);
            return e;
        }
        return null;
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsEdge(e)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        assert (this.base.getEdgeSource(e) == sourceVertex);
        assert (this.base.getEdgeTarget(e) == targetVertex);
        if (this.containsEdge(e)) {
            return false;
        }
        this.edgeSet.add(e);
        return true;
    }

    @Override
    public boolean addVertex(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsVertex(v)) {
            throw new IllegalArgumentException(NO_SUCH_VERTEX_IN_BASE);
        }
        if (this.containsVertex(v)) {
            return false;
        }
        this.vertexSet.add(v);
        return true;
    }

    @Override
    public boolean containsEdge(E e) {
        return this.edgeSet.contains(e);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.vertexSet.contains(v);
    }

    @Override
    public Set<E> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeSet);
        }
        return this.unmodifiableEdgeSet;
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        this.assertVertexExist(vertex);
        ArrayUnenforcedSet edges = new ArrayUnenforcedSet();
        Set baseEdges = this.base.edgesOf(vertex);
        for (Object e : baseEdges) {
            if (!this.containsEdge(e)) continue;
            edges.add(e);
        }
        return edges;
    }

    @Override
    public boolean removeEdge(E e) {
        return this.edgeSet.remove(e);
    }

    @Override
    public E removeEdge(V sourceVertex, V targetVertex) {
        E e = this.getEdge(sourceVertex, targetVertex);
        return (E)(this.edgeSet.remove(e) ? e : null);
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v) && this.base.containsVertex(v)) {
            this.removeAllEdges(this.edgesOf(v));
        }
        return this.vertexSet.remove(v);
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.vertexSet);
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public V getEdgeSource(E e) {
        return this.base.getEdgeSource(e);
    }

    @Override
    public V getEdgeTarget(E e) {
        return this.base.getEdgeTarget(e);
    }

    private void addEdgesUsingFilter(Set<E> edgeSet, Set<E> filter) {
        for (E e : edgeSet) {
            boolean edgeIncluded;
            Object sourceVertex = this.base.getEdgeSource(e);
            Object targetVertex = this.base.getEdgeTarget(e);
            boolean containsVertices = this.containsVertex(sourceVertex) && this.containsVertex(targetVertex);
            boolean bl = edgeIncluded = filter == null || filter.contains(e);
            if (!containsVertices || !edgeIncluded) continue;
            this.addEdge(sourceVertex, targetVertex, e);
        }
    }

    private void addVerticesUsingFilter(Set<V> vertexSet, Set<V> filter) {
        for (V v : vertexSet) {
            if (filter != null && !filter.contains(v)) continue;
            this.addVertex(v);
        }
    }

    public G getBase() {
        return this.base;
    }

    @Override
    public double getEdgeWeight(E e) {
        return this.base.getEdgeWeight(e);
    }

    public void setEdgeWeight(E e, double weight2) {
        ((WeightedGraph)this.base).setEdgeWeight(e, weight2);
    }

    private class BaseGraphListener
    implements GraphListener<V, E>,
    Serializable {
        private static final long serialVersionUID = 4343535244243546391L;

        private BaseGraphListener() {
        }

        @Override
        public void edgeAdded(GraphEdgeChangeEvent<V, E> e) {
            if (Subgraph.this.isInduced) {
                Object edge = e.getEdge();
                Object source = e.getEdgeSource();
                Object target = e.getEdgeTarget();
                if (Subgraph.this.containsVertex(source) && Subgraph.this.containsVertex(target)) {
                    Subgraph.this.addEdge(source, target, edge);
                }
            }
        }

        @Override
        public void edgeRemoved(GraphEdgeChangeEvent<V, E> e) {
            Object edge = e.getEdge();
            Subgraph.this.removeEdge(edge);
        }

        @Override
        public void vertexAdded(GraphVertexChangeEvent<V> e) {
        }

        @Override
        public void vertexRemoved(GraphVertexChangeEvent<V> e) {
            Object vertex = e.getVertex();
            Subgraph.this.removeVertex(vertex);
        }
    }
}

