### some further examples:
require(distrMod)
options("newDevice"=TRUE)

### Poisson Family
P <- PoisFamily(3)
# generate data
x <- r(P)(40)
MLEstimator(x,P)

#Evaluations of Maximum likelihood estimate:
#-------------------------------------------
#An object of class Estimate
#generated by call
#  MLEstimator(x = x, ParamFamily = P)
#samplesize:   40
#estimate:
#
#  3.2000000
# (0.2828427)
#asymptotic (co)variance (multiplied with samplesize):
#[1] 3.2
#Criterion:
#negative log-likelihood
#               78.23019

MDEstimator(x,P)

#Evaluations of Minimum Kolmogorov distance estimate:
#----------------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = P)
#samplesize:   40
#estimate:
#  lambda
#3.265427
#Criterion:
#Kolmogorov distance
#         0.03800172

MDEstimator(x,P, distance = CvMDist, asvar.fct = distrMod:::.CvMMDCovariance)

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = P, distance = CvMDist, asvar.fct = distrMod:::.CvMMDCovariance)
#samplesize:   40
#estimate:
#    lambda
#  3.3311598
# (0.4070559)
#asymptotic (co)variance (multiplied with samplesize):
#[1] 6.627779
#Criterion:
#CvM distance
#  0.02660172

MDEstimator(x,P, distance = CvMDist, mu = Norm())

#Evaluations of Minimum CvM distance estimate:
#---------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = P, distance = CvMDist, mu = Norm())
#samplesize:   40
#estimate:
#  lambda
#3.067493
#Criterion:
#CvM distance
#  0.00967911

MDEstimator(x,P, distance = TotalVarDist)

#Evaluations of Minimum total variation distance estimate:
#---------------------------------------------------------
#An object of class Estimate
#generated by call
#  MDEstimator(x = x, ParamFamily = P, distance = TotalVarDist)
#samplesize:   40
#estimate:
#  lambda
#3.113106
#Criterion:
#total variation distance
#               0.1097785


