/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet;

import java.util.ArrayList;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ILayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuralNet;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.InputLayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.InputNeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.Link;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedLayer;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class AbstractNeuralNet
implements INeuralNet {
    protected static final XmlFormat<AbstractNeuralNet> XML = new XmlFormat<AbstractNeuralNet>(AbstractNeuralNet.class){

        @Override
        public void format(AbstractNeuralNet source, XmlElement xml) {
            xml.add(source.inputLayer, "input-layer");
            xml.add(source.hiddenLayers, "hidden-layers");
            xml.add(source.outputLayer, "output-layer");
        }

        @Override
        public AbstractNeuralNet parse(XmlElement xml) {
            AbstractNeuralNet result = (AbstractNeuralNet)xml.object();
            result.inputLayer = (InputLayer)xml.get("input-layer");
            result.hiddenLayers = (ArrayList)xml.get("hidden-layers");
            ILayer<InputNeuron> previousLayer = result.inputLayer;
            for (LinkedLayer hiddenLayer : result.hiddenLayers) {
                for (int i = 0; i < hiddenLayer.getNofneurons(); ++i) {
                    Link[] links = hiddenLayer.getNeuron(i).getLinks();
                    for (int j = 0; j < links.length; ++j) {
                        links[j].setTarget(hiddenLayer.getNeuron(i));
                        if (!links[j].isBroken() && j < previousLayer.getMaxnofneurons()) {
                            links[j].setOrigin(previousLayer.getNeuron(j));
                            continue;
                        }
                        links[j].setOrigin(null);
                    }
                }
                previousLayer = hiddenLayer;
            }
            result.outputLayer = (LinkedLayer)xml.get("output-layer");
            for (int i = 0; i < result.outputLayer.getNofneurons(); ++i) {
                Link[] links = result.outputLayer.getNeuron(i).getLinks();
                for (int j = 0; j < links.length; ++j) {
                    links[j].setTarget(result.outputLayer.getNeuron(i));
                    if (!links[j].isBroken() && j < previousLayer.getMaxnofneurons()) {
                        links[j].setOrigin(previousLayer.getNeuron(j));
                        continue;
                    }
                    links[j].setOrigin(null);
                }
            }
            return result;
        }

        @Override
        public String defaultName() {
            return "neural-net";
        }
    };
    private static final long serialVersionUID = -5162585162983545056L;
    protected InputLayer inputLayer;
    protected ArrayList<LinkedLayer> hiddenLayers = new ArrayList();
    protected LinkedLayer outputLayer;

    @Override
    public int getNofhlayers() {
        return this.hiddenLayers.size();
    }

    @Override
    public InputLayer getInputLayer() {
        return this.inputLayer;
    }

    @Override
    public void setInputLayer(InputLayer inputLayer) {
        this.inputLayer = inputLayer;
    }

    @Override
    public void addHlayer(LinkedLayer layer) {
        this.hiddenLayers.add(layer);
    }

    @Override
    public LinkedLayer getHlayer(int index) {
        return this.hiddenLayers.get(index);
    }

    @Override
    public LinkedLayer getOutputLayer() {
        return this.outputLayer;
    }

    @Override
    public void setOutputLayer(LinkedLayer outputLayer) {
        this.outputLayer = outputLayer;
    }

    @Override
    public boolean equals(INeuralNet other) {
        return this.hashCode() == other.hashCode();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(61, 67);
        hcb.append(this.outputLayer);
        return hcb.toHashCode();
    }

    @Override
    public boolean neuronsFull() {
        for (LinkedLayer layer : this.hiddenLayers) {
            if (layer.neuronsFull()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean neuronsEmpty() {
        for (LinkedLayer layer : this.hiddenLayers) {
            if (layer.neuronsEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean linksFull() {
        if (this.hiddenLayers.size() == 0) {
            if (!this.outputLayer.linksFull(this.inputLayer)) {
                return false;
            }
        } else {
            if (!this.hiddenLayers.get(0).linksFull(this.inputLayer)) {
                return false;
            }
            for (int i = 1; i < this.hiddenLayers.size(); ++i) {
                if (this.hiddenLayers.get(i).linksFull(this.hiddenLayers.get(i - 1))) continue;
                return false;
            }
            if (!this.outputLayer.linksFull(this.hiddenLayers.get(this.hiddenLayers.size() - 1))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean linksEmpty() {
        for (LinkedLayer layer : this.hiddenLayers) {
            if (layer.linksEmpty()) continue;
            return false;
        }
        return this.outputLayer.linksEmpty();
    }

    @Override
    public int getNofhneurons() {
        int nofhneurons = 0;
        for (LinkedLayer layer : this.hiddenLayers) {
            nofhneurons += layer.getNofneurons();
        }
        return nofhneurons;
    }

    @Override
    public int getNoflinks() {
        int noflinks = 0;
        for (LinkedLayer layer : this.hiddenLayers) {
            noflinks += layer.getNoflinks();
        }
        return noflinks += this.outputLayer.getNoflinks();
    }

    @Override
    public void keepRelevantLinks(double significativeWeight) {
        for (LinkedLayer layer : this.hiddenLayers) {
            layer.keepRelevantLinks(significativeWeight);
        }
        this.outputLayer.keepRelevantLinks(significativeWeight);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.outputLayer.getNofneurons(); ++i) {
            String neuron = this.outputLayer.getNeuron(i).toString();
            neuron = neuron.replace("+-", "-");
            neuron = neuron.replace("-+", "-");
            neuron = neuron.replace("--", "+");
            neuron = neuron + " ";
            int count = 0;
            for (int j = 0; j < neuron.length(); ++j) {
                if (neuron.charAt(j) == '(') {
                    ++count;
                }
                if (neuron.charAt(j) != ')' || --count != 0) continue;
                neuron = neuron.substring(0, j + 1) + "\n" + neuron.substring(j + 2, neuron.length());
            }
            sb.append(neuron);
        }
        return sb.toString();
    }

    @Override
    public INeuralNet copy() {
        AbstractNeuralNet result = null;
        try {
            result = (AbstractNeuralNet)this.getClass().newInstance();
            ILayer<InputNeuron> lastCopiedLayer = result.inputLayer = this.inputLayer.copy();
            for (LinkedLayer hl : this.hiddenLayers) {
                LinkedLayer hlr = hl.copy(lastCopiedLayer);
                result.addHlayer(hlr);
                lastCopiedLayer = hlr;
            }
            result.outputLayer = this.outputLayer.copy(lastCopiedLayer);
        }
        catch (InstantiationException e) {
            System.out.println("Instantiation Error " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println("Illegal Access Error " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        return result;
    }
}

