/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.syntaxtree.rec;

import java.util.Comparator;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.syntaxtree.IRecombineSyntaxTree;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class SelectiveCrossover
implements IRecombineSyntaxTree,
IConfigure {
    private static final long serialVersionUID = -6447244450691681809L;
    protected int maximumDerivSize;
    protected NonTerminalNode[] selectedSymbols;
    protected Comparator<SyntaxTreeNode> symbolsComparator = new Comparator<SyntaxTreeNode>(){

        @Override
        public int compare(SyntaxTreeNode o1, SyntaxTreeNode o2) {
            if (o1 instanceof NonTerminalNode && o2 instanceof NonTerminalNode) {
                NonTerminalNode co1 = (NonTerminalNode)o1;
                NonTerminalNode co2 = (NonTerminalNode)o2;
                EqualsBuilder eb = new EqualsBuilder();
                eb.append(co1.getSymbol(), co2.getSymbol());
                if (eb.isEquals()) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    };

    public NonTerminalNode[] getSelectedSymbols() {
        return this.selectedSymbols;
    }

    public void setSelectedSymbols(NonTerminalNode[] selectedSymbols) {
        this.selectedSymbols = selectedSymbols;
    }

    @Override
    public void configure(Configuration settings) {
        int selSymDimension = settings.getInt("selected-symbols[@selected-dimension]", 0);
        if (selSymDimension != 0) {
            this.selectedSymbols = new NonTerminalNode[selSymDimension];
            int i = 0;
            while (i < selSymDimension) {
                NonTerminalNode element = new NonTerminalNode();
                String header = "selected-symbols.dimension(" + i + ")";
                String selName = settings.getString(String.valueOf(header) + ".name");
                element.setSymbol(selName);
                this.selectedSymbols[i] = element;
                ++i;
            }
            this.setSelectedSymbols(this.selectedSymbols);
        }
    }

    @Override
    public void recombine(SyntaxTree ptree0, SyntaxTree ptree1, SyntaxTree stree0, SyntaxTree stree1, SyntaxTreeSchema schema, IRandGen randgen) {
        SyntaxTreeNode node;
        boolean cond1;
        int numberOfSelectedSymbols;
        NonTerminalNode selectedSymbol;
        int p0_branchStart;
        if (this.selectedSymbols == null) {
            this.selectedSymbols = schema.getNonTerminals();
        }
        if ((p0_branchStart = this.searchSymbolIn(selectedSymbol = this.selectedSymbols[randgen.choose(0, numberOfSelectedSymbols = this.selectedSymbols.length)], ptree0, randgen)) == -1) {
            int i = 0;
            while (i < ptree0.size()) {
                stree0.addNode(ptree0.getNode(i).copy());
                ++i;
            }
            i = 0;
            while (i < ptree1.size()) {
                stree1.addNode(ptree1.getNode(i).copy());
                ++i;
            }
            return;
        }
        int p0_branchEnd = ptree0.subTree(p0_branchStart);
        int p0_branchDepth = ptree0.derivSize();
        int p0_swapBranch = 0;
        int i = p0_branchStart;
        while (i < p0_branchEnd) {
            if (ptree0.getNode(i).arity() != 0) {
                ++p0_swapBranch;
            }
            ++i;
        }
        int p1_branchStart = this.searchSymbolIn(selectedSymbol, ptree1, randgen);
        if (p1_branchStart == -1) {
            int i2 = 0;
            while (i2 < ptree0.size()) {
                stree0.addNode(ptree0.getNode(i2).copy());
                ++i2;
            }
            i2 = 0;
            while (i2 < ptree1.size()) {
                stree1.addNode(ptree1.getNode(i2).copy());
                ++i2;
            }
            return;
        }
        int p1_branchEnd = ptree1.subTree(p1_branchStart);
        int p1_branchDepth = ptree1.derivSize();
        int p1_swapBranch = 0;
        int i3 = p1_branchStart;
        while (i3 < p1_branchEnd) {
            if (ptree1.getNode(i3).arity() != 0) {
                ++p1_swapBranch;
            }
            ++i3;
        }
        int maxDerivSize = schema.getMaxDerivSize();
        boolean cond0 = p0_branchDepth - p0_swapBranch + p1_swapBranch > maxDerivSize;
        boolean bl = cond1 = p1_branchDepth - p1_swapBranch + p0_swapBranch > maxDerivSize;
        if (cond0 || cond1) {
            int i4 = 0;
            while (i4 < ptree0.size()) {
                stree0.addNode(ptree0.getNode(i4));
                ++i4;
            }
            i4 = 0;
            while (i4 < ptree1.size()) {
                stree1.addNode(ptree1.getNode(i4));
                ++i4;
            }
            return;
        }
        int i5 = 0;
        while (i5 < p0_branchStart) {
            stree0.addNode(ptree0.getNode(i5).copy());
            ++i5;
        }
        i5 = 0;
        while (i5 < p1_branchStart) {
            stree1.addNode(ptree1.getNode(i5).copy());
            ++i5;
        }
        i5 = p0_branchStart;
        while (i5 < p0_branchEnd) {
            node = ptree0.getNode(i5).copy();
            stree1.addNode(node);
            ++i5;
        }
        i5 = p1_branchStart;
        while (i5 < p1_branchEnd) {
            node = ptree1.getNode(i5).copy();
            stree0.addNode(node);
            ++i5;
        }
        int p0_length = ptree0.size();
        int i6 = p0_branchEnd;
        while (i6 < p0_length) {
            stree0.addNode(ptree0.getNode(i6).copy());
            ++i6;
        }
        int p1_length = ptree1.size();
        int i7 = p1_branchEnd;
        while (i7 < p1_length) {
            stree1.addNode(ptree1.getNode(i7).copy());
            ++i7;
        }
    }

    private final int searchSymbolIn(NonTerminalNode symbol, SyntaxTree tree, IRandGen randgen) {
        int startPos;
        int treeLength = tree.size();
        int actPos = startPos = randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (this.symbolsComparator.compare(symbol, tree.getNode(actPos)) == 0) {
                return actPos;
            }
            ++i;
        }
        return -1;
    }
}

