/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.GMCA;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.GMCA.Cluster;
import keel.Algorithms.Instance_Generation.GMCA.PairOfClusters;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import keel.Algorithms.Instance_Generation.utilities.Pair;

public class ClusterSet {
    ArrayList<Cluster> clusters = new ArrayList();
    HashMap<Prototype, Cluster> assignment = new HashMap();
    Cluster mixed = null;
    Cluster a = null;
    Cluster b = null;

    public ClusterSet clone() {
        ClusterSet copy = new ClusterSet();
        copy.clusters = new ArrayList();
        copy.assignment = new HashMap();
        for (Cluster c : this.clusters) {
            copy.clusters.add(c);
        }
        ArrayList<Prototype> ps = new ArrayList<Prototype>(this.assignment.keySet());
        for (Prototype p : ps) {
            copy.assignment.put(p, this.assignment.get(p));
        }
        return copy;
    }

    public Cluster get(int i) {
        return this.clusters.get(i);
    }

    void test(PrototypeSet s) {
        for (Prototype p : s) {
            if (this.assignment.containsKey(p)) continue;
            Debug.errorln("OJJJJJJOOOOOOO Prototipo " + p.getIndex() + " no tiene cluster");
        }
    }

    public Cluster get(Prototype p) {
        return this.assignment.get(p);
    }

    public Cluster merge(Cluster Ca, Cluster Cb) {
        Cluster CmixAB = Ca.mix(Cb);
        this.assignment.put(CmixAB.getRepresentative(), CmixAB);
        this.add(CmixAB);
        this.remove(Ca);
        this.remove(Cb);
        this.mixed = CmixAB;
        this.a = Ca;
        this.b = Cb;
        return CmixAB;
    }

    public boolean remove(Cluster c) {
        for (Prototype p : c.set) {
            if (this.assignment.get(p) != c) continue;
            this.assignment.remove(p);
        }
        return this.clusters.remove(c);
    }

    public void add(Cluster c) {
        this.clusters.add(c);
        for (Prototype p : c.set) {
            this.assignment.put(p, c);
        }
        this.assignment.put(c.getRepresentative(), c);
    }

    public ArrayList<Pair<Cluster, Cluster>> nearestClustersWithSameClass() {
        ArrayList<PairOfClusters> unsorted = new ArrayList<PairOfClusters>(this.clusters.size());
        int _size = this.clusters.size();
        for (int i = 0; i < _size; ++i) {
            for (int j = i + 1; j < _size; ++j) {
                Cluster ci = this.get(i);
                Cluster cj = this.get(j);
                double dij = ci.d(cj);
                unsorted.add(new PairOfClusters(ci, cj, dij));
            }
        }
        Collections.sort(unsorted);
        ArrayList<Pair<Cluster, Cluster>> sorted = new ArrayList<Pair<Cluster, Cluster>>(unsorted.size());
        for (PairOfClusters c : unsorted) {
            sorted.add(c.getPair());
        }
        ArrayList<Pair<Cluster, Cluster>> editedSorted = new ArrayList<Pair<Cluster, Cluster>>(sorted.size());
        int sortedSize = sorted.size();
        HashSet<Object> chosen = new HashSet<Object>();
        for (int i = 0; i < sortedSize; ++i) {
            Pair ci = (Pair)sorted.get(i);
            if (chosen.contains(ci.first()) || chosen.contains(ci.second())) continue;
            chosen.add(ci.first());
            chosen.add(ci.second());
            editedSorted.add(ci);
        }
        return editedSorted;
    }

    public ArrayList<Cluster> getClusters() {
        return this.clusters;
    }

    public double maxRadiusLength() {
        double rMax = Double.NEGATIVE_INFINITY;
        for (Cluster c : this.clusters) {
            double cR = c.getRadiusLength();
            if (!(rMax < cR)) continue;
            rMax = cR;
        }
        return rMax;
    }

    public double maxRadiusLengthOfClass(double k) {
        double rMax = Double.NEGATIVE_INFINITY;
        for (Cluster c : this.clusters) {
            double cR;
            if (c.getRepresentative().label() != k || !(rMax < (cR = c.getRadiusLength()))) continue;
            rMax = cR;
        }
        return rMax;
    }

    public void moveTo(Prototype p, Cluster c) {
        Cluster clusterOfP = this.assignment.get(p);
        clusterOfP.remove(p);
        if (clusterOfP.isEmpty()) {
            this.remove(clusterOfP);
        }
        c.add(p);
        this.assignment.put(p, c);
    }

    public Cluster getClusterOf(Prototype p) {
        return this.assignment.get(p);
    }

    public int size() {
        return this.getClusters().size();
    }
}

