/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;

public class PropertyPath {
    protected static PropertyContainer find(Object object, Path path) {
        PropertyContainer propertyContainer;
        PropertyDescriptor propertyDescriptor;
        PathElement pathElement = path.get(0);
        try {
            propertyDescriptor = new PropertyDescriptor(pathElement.getName(), object.getClass());
        }
        catch (Exception exception) {
            propertyDescriptor = null;
            exception.printStackTrace();
        }
        if (propertyDescriptor == null) {
            return null;
        }
        if (path.size() == 1) {
            propertyContainer = new PropertyContainer(propertyDescriptor, object);
        } else {
            try {
                Method method = propertyDescriptor.getReadMethod();
                Object object2 = method.invoke(object, (Object[])null);
                Object object3 = pathElement.hasIndex() ? Array.get(object2, pathElement.getIndex()) : object2;
                propertyContainer = PropertyPath.find(object3, path.subpath(1));
            }
            catch (Exception exception) {
                propertyContainer = null;
                exception.printStackTrace();
            }
        }
        return propertyContainer;
    }

    public static PropertyDescriptor getPropertyDescriptor(Object object, Path path) {
        PropertyContainer propertyContainer = PropertyPath.find(object, path);
        if (propertyContainer == null) {
            return null;
        }
        return propertyContainer.getDescriptor();
    }

    public static PropertyDescriptor getPropertyDescriptor(Object object, String string) {
        return PropertyPath.getPropertyDescriptor(object, new Path(string));
    }

    public static Object getValue(Object object, Path path) {
        Object object2 = null;
        PropertyContainer propertyContainer = PropertyPath.find(object, path);
        if (propertyContainer == null) {
            return null;
        }
        try {
            PathElement pathElement = path.get(path.size() - 1);
            Method method = propertyContainer.getDescriptor().getReadMethod();
            Object object3 = method.invoke(propertyContainer.getObject(), (Object[])null);
            object2 = pathElement.hasIndex() ? Array.get(object3, pathElement.getIndex()) : object3;
        }
        catch (Exception exception) {
            object2 = null;
            exception.printStackTrace();
        }
        return object2;
    }

    public static Object getValue(Object object, String string) {
        return PropertyPath.getValue(object, new Path(string));
    }

    public static boolean setValue(Object object, Path path, Object object2) {
        boolean bl = false;
        PropertyContainer propertyContainer = PropertyPath.find(object, path);
        if (propertyContainer == null) {
            return bl;
        }
        try {
            PathElement pathElement = path.get(path.size() - 1);
            Method method = propertyContainer.getDescriptor().getReadMethod();
            Method method2 = propertyContainer.getDescriptor().getWriteMethod();
            if (pathElement.hasIndex()) {
                Object object3 = method.invoke(propertyContainer.getObject(), (Object[])null);
                Array.set(object3, pathElement.getIndex(), object2);
                method2.invoke(propertyContainer.getObject(), object3);
            } else {
                method2.invoke(propertyContainer.getObject(), object2);
            }
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        return bl;
    }

    public static void setValue(Object object, String string, Object object2) {
        PropertyPath.setValue(object, new Path(string), object2);
    }

    public static void main(String[] stringArray) throws Exception {
        Path path = new Path("hello.world[2].nothing");
        System.out.println("Path: " + path);
        System.out.println(" -size: " + path.size());
        System.out.println(" -elements:");
        for (int i = 0; i < path.size(); ++i) {
            System.out.println("  " + i + ". " + path.get(i).getName() + " -> " + path.get(i).getIndex());
        }
    }

    protected static class PropertyContainer {
        protected PropertyDescriptor m_Descriptor;
        protected Object m_Object;

        public PropertyContainer(PropertyDescriptor propertyDescriptor, Object object) {
            this.m_Descriptor = propertyDescriptor;
            this.m_Object = object;
        }

        public PropertyDescriptor getDescriptor() {
            return this.m_Descriptor;
        }

        public Object getObject() {
            return this.m_Object;
        }
    }

    public static class Path {
        protected Vector m_Elements = new Vector();

        protected Path() {
        }

        public Path(String string) {
            this();
            this.m_Elements = this.breakUp(string);
        }

        public Path(Vector vector) {
            this();
            for (int i = 0; i < vector.size(); ++i) {
                this.m_Elements.add(((PathElement)vector.get(i)).clone());
            }
        }

        public Path(String[] stringArray) {
            this();
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_Elements.add(new PathElement(stringArray[i]));
            }
        }

        protected Vector breakUp(String string) {
            Vector<PathElement> vector = new Vector<PathElement>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(new PathElement(stringTokenizer.nextToken()));
            }
            return vector;
        }

        public PathElement get(int n) {
            return (PathElement)this.m_Elements.get(n);
        }

        public int size() {
            return this.m_Elements.size();
        }

        public static Path parsePath(String string) {
            return new Path(string);
        }

        public Path subpath(int n) {
            return this.subpath(n, this.size());
        }

        public Path subpath(int n, int n2) {
            Vector<PathElement> vector = new Vector<PathElement>();
            for (int i = n; i < n2; ++i) {
                vector.add(this.get(i));
            }
            return new Path(vector);
        }

        public String toString() {
            String string = "";
            for (int i = 0; i < this.m_Elements.size(); ++i) {
                if (i > 0) {
                    string = string + ".";
                }
                string = string + this.m_Elements.get(i);
            }
            return string;
        }
    }

    public static class PathElement
    implements Cloneable {
        protected String m_Name;
        protected int m_Index;

        public PathElement(String string) {
            if (string.indexOf("[") > -1) {
                this.m_Name = string.replaceAll("\\[.*$", "");
                this.m_Index = Integer.parseInt(string.replaceAll(".*\\[", "").replaceAll("\\].*", ""));
            } else {
                this.m_Name = string;
                this.m_Index = -1;
            }
        }

        public Object clone() {
            return new PathElement(this.toString());
        }

        public String getName() {
            return this.m_Name;
        }

        public boolean hasIndex() {
            return this.getIndex() > -1;
        }

        public int getIndex() {
            return this.m_Index;
        }

        public String toString() {
            String string = this.getName();
            if (this.hasIndex()) {
                string = string + "[" + this.getIndex() + "]";
            }
            return string;
        }
    }
}

