/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.core.Instance;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class BayesNetEstimator
implements OptionHandler,
Serializable {
    static final long serialVersionUID = 2184330197666253884L;
    protected double m_fAlpha = 0.5;

    public void estimateCPTs(BayesNet bayesNet) throws Exception {
        throw new Exception("Incorrect BayesNetEstimator: use subclass instead.");
    }

    public void updateClassifier(BayesNet bayesNet, Instance instance) throws Exception {
        throw new Exception("Incorrect BayesNetEstimator: use subclass instead.");
    }

    public double[] distributionForInstance(BayesNet bayesNet, Instance instance) throws Exception {
        throw new Exception("Incorrect BayesNetEstimator: use subclass instead.");
    }

    public void initCPTs(BayesNet bayesNet) throws Exception {
        throw new Exception("Incorrect BayesNetEstimator: use subclass instead.");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tInitial count (alpha)\n", "A", 1, "-A <alpha>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('A', stringArray);
        this.m_fAlpha = string.length() != 0 ? (double)new Float(string).floatValue() : 0.5;
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        stringArray[n++] = "-A";
        stringArray[n++] = "" + this.m_fAlpha;
        return stringArray;
    }

    public void setAlpha(double d) {
        this.m_fAlpha = d;
    }

    public double getAlpha() {
        return this.m_fAlpha;
    }

    public String alphaTipText() {
        return "Alpha is used for estimating the probability tables and can be interpreted as the initial count on each value.";
    }

    public String globalInfo() {
        return "BayesNetEstimator is the base class for estimating the conditional probability tables of a Bayes network once the structure has been learned.";
    }
}

