## ----eval = F-----------------------------------------------------------------
# install.packages("ProfileLadder")

## ----eval = T, message = F----------------------------------------------------
library("ProfileLadder")
library("ChainLadder")

## ----eval = F-----------------------------------------------------------------
# data(package = "ProfileLadder")

## ----eval = T-----------------------------------------------------------------
help("CameronMutual") ## output omitted
(cameron <- CameronMutual)

## ----eval = T-----------------------------------------------------------------
help("CZ.casco") ## output omitted
(casco <- CZ.casco$GrossPaid)

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
par(mfrow = c(1,2))

### S3 class 'triangle' from the ChainLadder pkg
plot(as.triangle(casco))

### S3 class 'profileLadder' from the ProfileLadder pkg
plot(as.profileLadder(casco))

## ----eval = T, fig.width=12, fig.height=3, out.width="98%"--------------------
par(mfrow = c(1,3))
### S3 class 'triangle' from the ChainLadder pkg
plot(as.triangle(cameron))

### S3 class 'profileLadder' from the ProfileLadder pkg 
plot(as.profileLadder(observed(cameron)))

### S3 class 'profileLadder' (run-off triangle with future profiles)
plot(as.profileLadder(cameron))

## ----eval = T-----------------------------------------------------------------
observed(cameron)

## ----eval = F-----------------------------------------------------------------
# options(profileLadder.fancy = TRUE)
# set.fancy.print() ## custom-defined colors

## ----eval = T-----------------------------------------------------------------
(parallax.cameron <- parallelReserve(cameron))

## ----eval = T-----------------------------------------------------------------
summary(parallax.cameron)

## ----eval = T-----------------------------------------------------------------
summary(glmReserve(observed(cameron)))

## ----eval = T, fig.width=12, fig.height=5-------------------------------------
parallax.casco <- parallelReserve(casco)
summary(parallax.casco)

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
par(mfrow = c(1,2))
plot(parallax.cameron)
plot(parallax.casco)

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
react.cameron <- parallelReserve(cameron, method = "react", residuals = TRUE)
summary(react.cameron, plotOption = TRUE)

## ----eval = T, fig.width=12, fig.height=5-------------------------------------
react.cameron$residuals

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
summary(parallelReserve(cameron, method = "react"), plotOption = TRUE)

## ----eval = F, fig.width=12, fig.height=5-------------------------------------
# ### standard residuals for a fully observed square
# parallelReserve(cameron, method = "react", residuals = TRUE)$residuals
# 
# ### backfitted residuals for the observed run-off triangle only
# parallelReserve(observed(cameron), method = "react", residuals = TRUE)$residuals

## ----eval = T, fig.width=12, fig.height=5-------------------------------------
(macrame.cameron <- mcReserve(cameron))

## ----eval = T, fig.width=12, fig.height=3.5, out.width="98%"------------------
par(mfrow = c(1,3))

### PARALLAX reserve prediction and run-off completion
plot(parallelReserve(cameron))

### REACT reserve prediction and run-off completion
plot(parallelReserve(cameron, method = "react"))

### MACRAME reserve prediction and run-off completion
plot(mcReserve(cameron))

## ----eval = F, fig.width=12, fig.height=5-------------------------------------
# help("mcReserve")

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
(exploratory.casco <- incrExplor(casco))

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
summary(exploratory.casco)
plot(exploratory.casco)

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
plot(modification.1 <- incrExplor(casco, states = c(0, 230, 420, 716, 1645, 3863, 116245, 172120)))

## ----eval = F, fig.width=12, fig.height=5-------------------------------------
# mcReserve(casco, states = c(0, 230, 420, 716, 1645, 3863, 116245, 172120))

## ----eval = F, fig.width=12, fig.height=5-------------------------------------
# mcReserve(casco, states = mcStates(modification.1))

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
plot(incrExplor(casco, states = 5))

## ----eval = T, fig.width=12, fig.height=5-------------------------------------
macrame.s5.casco <- mcReserve(casco, states = 5)
mcStates(macrame.s5.casco)

## ----eval = T, fig.width=12, fig.height=5-------------------------------------
mcBreaks(macrame.s5.casco)

## ----eval = T, fig.width=12, fig.height=5-------------------------------------
mcTrans(macrame.s5.casco)

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
plot(modification.2 <- incrExplor(casco, breaks = c(0, 100, 500, 5000)))

## ----eval = F, fig.width=12, fig.height=5, out.width="98%"--------------------
# incrExplor(casco, breaks = c(-Inf, 0, 100, 500, 5000))
# incrExplor(casco, breaks = c(0, 100, 500, 5000, Inf))
# incrExplor(casco, breaks = c(-Inf, 0, 100, 500, 5000, Inf))

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
mcStates(modification.2)

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
summary(mcReserve(casco, breaks = c(0, 100, 500, 5000)))

## ----eval = T, fig.width=12, fig.height=5, out.width="98%"--------------------
new.breaks <- c(0, 100, 500, 5000)
exploratory.casco2 <- incrExplor(casco, breaks = new.breaks, method = "max")
plot(exploratory.casco2)

## ----eval = F, fig.width=12, fig.height=5-------------------------------------
# mcReserve(casco, breaks = mew.breaks, states = mcStates(exploratory.casco2))

## ----eval = F, fig.width=12, fig.height=5-------------------------------------
# help("incrExplor")
# help("mcReserve")

## ----eval = T, fig.width=12, fig.height=8-------------------------------------
incrExplor(cameron, out = 0)

## ----eval = T, fig.width=12, fig.height=4, out.width="98%"--------------------
par(mfrow = c(1,2))
plot(incrExplor(cameron, out = 0))

## ----eval = T, fig.width=12, fig.height=10, out.width="98%"-------------------
par(mfrow = c(3,2))

plot(mcReserve(cameron)) ### default setting with 10 MC states
plot(mcReserve(cameron, states = 4)) ### four states (otherwise default)
plot(mcReserve(cameron, states = c(50, 500, 1500, 3000))) ### explicit states
plot(mcReserve(cameron, breaks = c(500, 1000, 1500, 2000))) ### explicit breaks
     
user.breaks <- c(500, 1000, 1500, 2000)
user.method <- incrExplor(cameron, breaks = user.breaks, method = "max")
final.states <- mcStates(user.method)
### explicit breaks and Markov states as maximma 
plot(mcReserve(cameron, breaks = user.breaks, states = final.states))

### explicit breaks and explicit states
plot(mcReserve(cameron, breaks = c(500, 1000, 1500), states = c(100, 999, 1001, 3000))) 

## ----eval = T, fig.width=8, fig.height=6--------------------------------------
permute.cameron <- permuteReserve(mcReserve(cameron), B = 100)

## ----eval = T, fig.width=16, fig.height=10, out.width="98%"-------------------
summary(permute.cameron)
plot(permute.cameron)

## ----eval = T, fig.width=12, fig.height=8, out.width="98%"--------------------
summary(glmReserve(observed(cameron)))

## ----eval = T, fig.width=12, fig.height=8, out.width="98%"--------------------
plot(BootChainLadder(observed(cameron)))

## ----eval = T, fig.width=12, fig.height=8-------------------------------------
cameron.glm <- glmReserve(observed(cameron))
cameron.boot <- glmReserve(observed(cameron), mse.method = "bootstrap", nsim = 100)
cameron.permute <- permuteReserve(glmReserve(observed(cameron)), B = 100)

## ----eval = T, fig.width=12, fig.height=8-------------------------------------
summary(cameron.glm)
summary(cameron.boot)
summary(cameron.permute)

## ----eval = T, fig.width=12, fig.height=8-------------------------------------
(diag.cameron <- predict(parallelReserve(cameron)))

## ----eval = T, fig.width=12, fig.height=6, out.width="98%"--------------------
plot(diag.cameron)

