/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.dsiext.dataengine.metadata;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.filters.IFilter;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.DSITypeUtilities;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.Nullable;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.amazon.sqlengine.dsiext.dataengine.Identifier;
import com.amazon.sqlengine.dsiext.dataengine.ProcedureParameterMetadata;
import com.amazon.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.amazon.sqlengine.dsiext.dataengine.StoredProcedure;
import com.amazon.sqlengine.dsiext.dataengine.metadata.DSIExtPartiallyFilteredMetadataSource;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DSIExtProcedureColumnsMetadataSource
extends DSIExtPartiallyFilteredMetadataSource {
    private ILogger m_logger;
    private StoredProcedure m_curProcedure = null;
    private SqlDataEngine m_dataEngine;
    private ParamOrColumnIterator m_curRow;
    private boolean nextRowLoaded = false;

    @Deprecated
    public DSIExtProcedureColumnsMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, SqlDataEngine sqlDataEngine) {
        super(map, iMetadataHelper, MetadataSourceColumnTag.PROCEDURE_NAME, sqlDataEngine.getIsODBC2());
        this.init(iLogger, map, sqlDataEngine);
    }

    public DSIExtProcedureColumnsMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, SqlDataEngine sqlDataEngine, List<IFilter> list) {
        super(iMetadataHelper, MetadataSourceColumnTag.PROCEDURE_NAME, sqlDataEngine.getIsODBC2(), list);
        this.init(iLogger, map, sqlDataEngine);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_dataEngine = null;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curProcedure.getCatalogName(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curProcedure.getSchemaName(), dataWrapper, l, l2);
            }
            case PROCEDURE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curProcedure.getProcedureName(), dataWrapper, l, l2);
            }
            case COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getName(), dataWrapper, l, l2);
            }
            case PROCEDURE_COLUMN_TYPE: {
                dataWrapper.setSmallInt(this.m_curRow.getType());
                break;
            }
            case DATA_TYPE: {
                dataWrapper.setSmallInt(this.m_curRow.getDataType());
                break;
            }
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getTypeName(), dataWrapper, l, l2);
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger(TypeUtilities.getColumnSize(this.m_curRow.m_meta, this.m_curRow.getLength()));
                break;
            }
            case BUFFER_LENGTH: {
                dataWrapper.setInteger(this.m_curRow.getBufferLength());
                break;
            }
            case DECIMAL_DIGITS: {
                dataWrapper.setSmallInt(this.m_curRow.getDecimalDigits());
                break;
            }
            case NUM_PREC_RADIX: {
                dataWrapper.setSmallInt(this.m_curRow.getNumPrecRadix());
                break;
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(this.m_curRow.getNullable().ordinal());
                break;
            }
            case REMARKS: {
                dataWrapper.setVarChar(this.m_curRow.getRemarks());
                break;
            }
            case COLUMN_DEF: {
                dataWrapper.setVarChar(this.m_curRow.getColumnDef());
                break;
            }
            case SQL_DATA_TYPE: {
                dataWrapper.setSmallInt(TypeUtilities.getVerboseTypeFromConciseType(this.m_curRow.getSqlDataType()));
                break;
            }
            case SQL_DATETIME_SUB: {
                dataWrapper.setSmallInt(this.m_curRow.getSqlDateTimeSub());
                break;
            }
            case CHAR_OCTET_LENGTH: {
                dataWrapper.setInteger(this.m_curRow.getCharOctetLength());
                break;
            }
            case ORDINAL_POSITION: {
                dataWrapper.setInteger(this.m_curRow.getOrdinal());
                break;
            }
            case IS_NULLABLE: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getNullable().isNullable(), dataWrapper, l, l2);
            }
            case IS_RESULT_SET: {
                dataWrapper.setBoolean(this.m_curRow.m_isParam);
                break;
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                break;
            }
            case SPECIFIC_NAME: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
            default: {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
            }
        }
        return false;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Identifier identifier = null;
        if (this.nextRowLoaded || this.m_curRow.moveToNext()) {
            this.nextRowLoaded = true;
            return true;
        }
        if (this.m_curRow.m_isParam) {
            assert (null != this.m_curProcedure);
            List<IColumn> list = this.m_curProcedure.getCurrentResultMetadata();
            this.m_curRow.fromColumns(list);
            return this.hasMoreRows();
        }
        this.m_curProcedure = null;
        while (null == this.m_curProcedure) {
            identifier = super.getNextProcedureOrTable();
            if (null == identifier) {
                return false;
            }
            this.m_curProcedure = this.m_dataEngine.openProcedure(identifier.getCatalog(), identifier.getSchema(), identifier.getName());
        }
        List<ProcedureParameterMetadata> list = this.m_curProcedure.getParameters();
        this.m_curRow.fromParams(list);
        return this.hasMoreRows();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl = this.nextRowLoaded;
        if (!bl) {
            while (true) {
                try {
                    bl = this.hasMoreRows();
                }
                catch (ErrorException errorException) {
                    LogUtilities.logError(errorException, this.m_logger);
                    continue;
                }
                break;
            }
        }
        this.nextRowLoaded = false;
        return bl;
    }

    private void init(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, SqlDataEngine sqlDataEngine) {
        this.m_logger = iLogger;
        this.m_dataEngine = sqlDataEngine;
        this.m_curRow = new ParamOrColumnIterator(map.get((Object)MetadataSourceColumnTag.COLUMN_NAME));
    }

    private final class ParamOrColumnIterator {
        boolean m_isParam = false;
        Iterator<?> m_iterator = null;
        IColumn m_col = null;
        ProcedureParameterMetadata m_param = null;
        TypeMetadata m_meta = null;
        int m_ordinal = -1;
        String m_filter;

        ParamOrColumnIterator(String string) {
            this.m_filter = string;
        }

        void fromColumns(List<IColumn> list) {
            this.m_iterator = null == list ? null : list.iterator();
            this.m_isParam = false;
            this.m_ordinal = 0;
            this.m_param = null;
        }

        void fromParams(List<ProcedureParameterMetadata> list) {
            this.m_iterator = null == list ? null : list.iterator();
            this.m_isParam = true;
            if (null != list && !list.isEmpty() && list.get(0).getParameterType() == ParameterType.RETURN_VALUE) {
                this.m_ordinal = -1;
            }
            this.m_ordinal = 0;
            this.m_col = null;
        }

        boolean moveToNext() {
            while (null != this.m_iterator && this.m_iterator.hasNext()) {
                if (this.m_isParam) {
                    this.m_param = (ProcedureParameterMetadata)this.m_iterator.next();
                    this.m_meta = this.m_param.getTypeMetadata();
                } else {
                    this.m_col = (IColumn)this.m_iterator.next();
                    this.m_meta = this.m_col.getTypeMetadata();
                }
                ++this.m_ordinal;
                if (null != this.m_filter && !this.m_filter.equals(this.getName())) continue;
                return true;
            }
            this.m_iterator = null;
            this.m_col = null;
            this.m_param = null;
            this.m_meta = null;
            return false;
        }

        String getName() {
            return this.m_isParam ? this.m_param.getName() : this.m_col.getName();
        }

        short getType() {
            return this.m_isParam ? (short)this.m_param.getParameterType().getIntValue() : (short)3;
        }

        int getDataType() {
            return this.m_meta.getType();
        }

        String getTypeName() {
            return this.m_meta.getTypeName();
        }

        int getPrecision() {
            return this.m_meta.getPrecision();
        }

        long getLength() {
            return this.m_isParam ? this.m_param.getColumnLength() : this.m_col.getColumnLength();
        }

        int getSize() throws ErrorException {
            return (int)TypeUtilities.getColumnSize(this.m_meta, this.getLength());
        }

        long getBufferLength() {
            if (this.m_meta.isCharacterOrBinaryType()) {
                return this.getCharOctetLength();
            }
            return TypeUtilities.getSizeInBytes(this.m_meta.getType());
        }

        Integer getDecimalDigits() {
            int n = -1;
            if (this.m_meta.isIntervalType() || 92 == this.m_meta.getType() || 93 == this.m_meta.getType()) {
                n = this.m_meta.getPrecision();
            } else if (this.m_meta.isExactNumericType()) {
                n = this.m_meta.getScale();
            } else if (this.m_meta.isIntegerType()) {
                n = 0;
            }
            return n < 0 ? null : Integer.valueOf(n);
        }

        Integer getNumPrecRadix() {
            int n = -1;
            if (this.m_meta.isIntegerType() || this.m_meta.isExactNumericType()) {
                n = 10;
            } else if (this.m_meta.isApproximateNumericType()) {
                n = 2;
            }
            return n < 0 ? null : Integer.valueOf(n);
        }

        long getScale() {
            return this.m_meta.getScale();
        }

        Nullable getNullable() {
            return this.m_isParam ? this.m_param.getNullable() : this.m_col.getNullable();
        }

        String getRemarks() {
            return null;
        }

        String getColumnDef() {
            return null;
        }

        int getSqlDataType() {
            return this.getDataType();
        }

        Integer getSqlDateTimeSub() {
            short s = TypeUtilities.getIntervalCodeFromConciseType(this.getDataType());
            return s == 0 ? null : Integer.valueOf(s);
        }

        Long getCharOctetLength() {
            short s;
            long l = -1L;
            if (this.m_meta.isCharacterOrBinaryType()) {
                l = this.getLength();
            }
            if (-8 == (s = this.m_meta.getType()) || -9 == s || -10 == s) {
                l *= 2L;
            }
            return l < 0L ? null : Long.valueOf(l);
        }

        int getOrdinal() {
            return this.m_ordinal;
        }
    }
}

