/*
 * Decompiled with CFR 0.152.
 */
package com.github.javacliparser;

import com.github.javacliparser.ClassOption;
import com.github.javacliparser.Configurable;
import com.github.javacliparser.Option;
import com.github.javacliparser.Options;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class JavaCLIParser
implements Serializable {
    public Object handler;
    private static final long serialVersionUID = 1L;
    protected Options options;
    protected Map<String, Object> classOptionNamesToPreparedObjects;

    public JavaCLIParser(Object c, String cliString) {
        this.handler = c;
    }

    public String getPurposeString() {
        return "Anonymous object: purpose undocumented.";
    }

    public Options getOptions() {
        if (this.options == null) {
            Option[] myOptions;
            this.options = new Options();
            for (Option option : myOptions = this.discoverOptionsViaReflection()) {
                this.options.addOption(option);
            }
        }
        return this.options;
    }

    public Option[] discoverOptionsViaReflection() {
        Class<?> c = this.handler.getClass();
        Field[] fields = c.getFields();
        LinkedList<Option> optList = new LinkedList<Option>();
        for (Field field : fields) {
            String fName = field.getName();
            Class<?> fType = field.getType();
            if (!fType.getName().endsWith("Option") || !Option.class.isAssignableFrom(fType)) continue;
            Option oVal = null;
            try {
                field.setAccessible(true);
                oVal = (Option)field.get(this.handler);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (oVal == null) continue;
            optList.add(oVal);
        }
        return optList.toArray(new Option[optList.size()]);
    }

    public void prepareClassOptions() {
        Option[] optionArray;
        this.classOptionNamesToPreparedObjects = null;
        for (Option option : optionArray = this.getOptions().getOptionArray()) {
            if (!(option instanceof ClassOption)) continue;
            ClassOption classOption = (ClassOption)option;
            Object optionObj = classOption.materializeObject();
            if (optionObj instanceof Configurable) {
                JavaCLIParser javaCLIParser = new JavaCLIParser(optionObj, "");
            }
            if (this.classOptionNamesToPreparedObjects == null) {
                this.classOptionNamesToPreparedObjects = new HashMap<String, Object>();
            }
            this.classOptionNamesToPreparedObjects.put(option.getName(), optionObj);
        }
    }
}

