### Signal Tandmobiel analysis
### for SMMR paper
###
### * emergence of permanent premolars 14 and 15
### * models with T**.DMF (of primary molars)
###
### 14/07/2004
### ================================================
#setwd("~/")
paperdir <- getwd()
library(smoothSurv)

data <- read.table(paste("./", "tandmob2.dat", sep = ""), skip = 65, header = TRUE, 
                 as.is = c(T, F, T, T, rep(F, 3), rep(T, 149)))

  ## Subtract 5.0 from all time variables:
  ##   (i.e. time 0 in the analyzes = 5 years of age)
startage <- 5.0
data[,21:132] <- data[,21:132] - startage

  ## Load previouslu stored results
  ## (you do not have to do it provided you continue with R directly after computation)
#load("./RenvGenderxDmf")
#load("./RenvSDmf")
#load("./RenvSGenderxDmf")

### Compute emergence curves (1 - survivor function)
### =================================================
  ## define covariate combinations for model T ~ gender*dmf
cov <- matrix(c(1, 1, 1,   1, 0, 0,   0, 1, 0,   0, 0, 0), ncol = 3, byrow = TRUE)  # girl, dmf;  girl, sound;  boy, dmf;  boy, sound

  ## define covariate combinations for logscale ~ dmf
cov2 <- matrix(c(1, 0, 1, 0), ncol = 1)                                             # dmf, sound, dmf, sound

  ## compute emergence curves for three models and above defined combinations of covariates
  ## a) T ~ gender*dmf, logscale~1
  ## b) T ~ gender*dmf, logscale~dmf
  ## c) T ~ gender*dmf, logscale~gender*dmf
cdfgd <- lapply(fgenderxdmf, survfit, time0 = startage, plot = FALSE, cov = cov, cdf = TRUE, xlim = c(7, 13))
cdfsd <- lapply(fsdmf, survfit, time0 = startage, plot = FALSE, cov = cov, logscale.cov = cov2, cdf = TRUE, xlim = c(7, 13))
cdfsgd <- lapply(fsgenderxdmf, survfit, time0 = startage, plot = FALSE, cov = cov, logscale.cov = cov, cdf = TRUE, xlim = c(7, 13))


  ## compute hazard curves for three models and above defined combinations of covariates
  ## a) T ~ gender*dmf, logscale~1
  ## b) T ~ gender*dmf, logscale~dmf
  ## c) T ~ gender*dmf, logscale~gender*dmf
hazgd <- lapply(fgenderxdmf, hazard, time0 = startage, plot = FALSE, cov = cov, xlim = c(7, 15))
hazsd <- lapply(fsdmf, hazard, time0 = startage, plot = FALSE, cov = cov, logscale.cov = cov2, xlim = c(7, 15))
hazsgd <- lapply(fsgenderxdmf, hazard, time0 = startage, plot = FALSE, cov = cov, logscale.cov = cov, xlim = c(7, 15))


  ## compute densities for three models and above defined combinations of covariates
  ## a) T ~ gender*dmf, logscale~1
  ## b) T ~ gender*dmf, logscale~dmf
  ## c) T ~ gender*dmf, logscale~gender*dmf
densgd <- lapply(fgenderxdmf, fdensity, time0 = startage, plot = FALSE, cov = cov, xlim = c(7, 14))
denssd <- lapply(fsdmf, fdensity, time0 = startage, plot = FALSE, cov = cov, logscale.cov = cov2, xlim = c(7, 14))
denssgd <- lapply(fsgenderxdmf, fdensity, time0 = startage, plot = FALSE, cov = cov, logscale.cov = cov, xlim = c(7, 14))


### PLOT01: Emergence curves for teeth 14 and 15 based on fitted models
###         + their comparison to Turnbull estimate
###           !!! Turnbull estimate was computed in Splus and stored on disk
###         - 4 figures, separately boys and girls
### ========================================================================
tand <- paste(c(14, 15))       ## teeth I want to plot
gender <- c("Girls", "Boys")

  ## Parameters for plots
col1 <- "black"; col2 <- "black"
cex.main <- 0.9
cex.lab <- 0.9
cex.axis <- 0.9
mai <- c(0.65, 0.5, 0.5, 0.1)
lwd <- 1
slty <- c(1, 1)
kmlty <- 2

#postscript(paste(paperdir, "/akplot01.ps", sep = ""), width = 6, height = 6, horizontal = FALSE)
par(bty="n", mai=mai, lwd=lwd, cex.main=cex.main, cex.lab=cex.lab, cex.axis=cex.axis)
par(mfrow = c(2, 2))
toplot <- cdfsd

  ## Loop over teeth
for (k in 1:2){
    ## Read stored Turnbull estimates (stored in files ./dataKMM/kmmTOOTHlabel.dat)
  km <- list()
  label <- c(3, 2, 1, 0)    ## labels of KM files corresponding to the same order of covariates (# girl,dmf; girl,sound; boy,dmf; boy,sound)
  for (i in 1:4) km[[i]] <- read.table(paste("./dataKMM/kmm", tand[k], ".", label[i], ".dat", sep = ""),
                                     header = FALSE)

      ## Loop over genders
    for (gg in 1:2){
      yname1 <- paste("y", (gg - 1)*2 + 1, sep = "")       ## name of the column in cdf* file that correspond to dmf = 1 for given gender
      yname2 <- paste("y", (gg - 1)*2 + 2, sep = "")       ## name of the column in cdf* file that correspond to dmf = 0 for given gender
      plot(toplot[[k]]$x, toplot[[k]][[yname1]], type = "l", lty = slty[1], xlab = "Age", ylab = "CDF", col = col1,
           ylim = c(0, 1), xlim = c(7, 12.3))
      lines(toplot[[k]]$x, toplot[[k]][[yname2]], lty = slty[2], col = col2)
      lines(km[[(gg - 1)*2 + 1]][,1] + startage, 1 - km[[(gg - 1)*2 + 1]][,2], lty = kmlty, col = col1, lwd = lwd+0.5)
      lines(km[[(gg - 1)*2 + 2]][,1] + startage, 1 - km[[(gg - 1)*2 + 2]][,2], lty = kmlty, col = col2, lwd = lwd+0.5)
      title(main = paste("Tooth ", tand[k], ", ", gender[gg], sep = ""), cex = cex.main)
#      legend(7, 1, legend = c("logscale ~ dmf", "Turnbull"), lty = c(slty[1], kmlty), lwd = c(lwd, lwd),
#             col = c("black", "black"), bty = "n", y.intersp = 1.7)
#      legend(7, 0.5, legend = c("dmf > 0", "dmf = 0"), lty = c(slty[1], slty[2]), col = c(col1, col2), lwd = c(lwd, lwd), bty = "n",
#             y.intersp = 1.7)  
    }      
}
#dev.off()


### PLOT02: Hazard curves for teeth 14 and 15 based on fitted models
###         - 4 figures, separately boys and girls
### ========================================================================
tand <- paste(c(14, 15))       ## teeth I want to plot
gender <- c("Girls", "Boys")

  ## Parameters for plots
col1 <- "black"; col2 <- "black"
cex.main <- 0.9
cex.lab <- 0.9
cex.axis <- 0.9
mai <- c(0.65, 0.5, 0.5, 0.1)
lwd <- 1.5
hlty <- c(1, 4)
ylim <- list(); ylim[[1]] <- c(0, 0.35); ylim[[2]] <- c(0, 0.25)

#postscript(paste(paperdir, "/akplot02.ps", sep = ""), width = 6, height = 6, horizontal = FALSE)
par(bty="n", mai=mai, lwd=lwd, cex.main=cex.main, cex.lab=cex.lab, cex.axis=cex.axis)
par(mfrow = c(2, 2))
toplot <- hazsd

  ## Loop over teeth
for (k in 1:2){

      ## Loop over genders
    for (gg in 1:2){
      yname1 <- paste("y", (gg - 1)*2 + 1, sep = "")       ## name of the column in cdf* file that correspond to dmf = 1 for given gender
      yname2 <- paste("y", (gg - 1)*2 + 2, sep = "")       ## name of the column in cdf* file that correspond to dmf = 0 for given gender
      plot(toplot[[k]]$x, toplot[[k]][[yname1]], type = "l", lty = hlty[1], xlab = "Age", ylab = "hazard", col = col1,
           ylim = ylim[[k]], xlim = c(7, 12.3))
      lines(toplot[[k]]$x, toplot[[k]][[yname2]], lty = hlty[2], col = col2)
      title(main = paste("Tooth ", tand[k], ", ", gender[gg], sep = ""), cex = cex.main)
#      legend(7, ylim[[k]][2], legend = c("dmf > 0", "dmf = 0"), lty = hlty, col = c(col1, col2), lwd = c(lwd, lwd), bty = "n",
#             y.intersp = 1.7)  
    }      
}
#dev.off()


### PLOT03: Densities for teeth 14 and 15 based on fitted models
###         - 4 figures, separately boys and girls
### ========================================================================
tand <- paste(c(14, 15))       ## teeth I want to plot
gender <- c("Girls", "Boys")

  ## Parameters for plots
col1 <- "black"; col2 <- "black"
lwd <- 1
cex.main <- 0.9
cex.lab <- 0.9
cex.axis <- 0.9
mai <- c(0.65, 0.5, 0.5, 0.1)
lwd <- 1.5
dlty <- c(1, 4)
ylim <- list(); ylim[[1]] <- c(0, 0.08); ylim[[2]] <- c(0, 0.08)

#postscript(paste(paperdir, "/akplot03.ps", sep = ""), width = 6, height = 6, horizontal = FALSE)
par(bty="n", mai=mai, lwd=lwd, cex.main=cex.main, cex.lab=cex.lab, cex.axis=cex.axis)
par(mfrow = c(2, 2))
toplot <- denssd

  ## Loop over teeth
for (k in 1:2){

      ## Loop over genders
    for (gg in 1:2){
      yname1 <- paste("y", (gg - 1)*2 + 1, sep = "")       ## name of the column in cdf* file that correspond to dmf = 1 for given gender
      yname2 <- paste("y", (gg - 1)*2 + 2, sep = "")       ## name of the column in cdf* file that correspond to dmf = 0 for given gender
      plot(toplot[[k]]$x, toplot[[k]][[yname1]], type = "l", lty = dlty[1], xlab = "Age", ylab = "hazard", col = col1,
           ylim = ylim[[k]], xlim = c(7, 14))
      lines(toplot[[k]]$x, toplot[[k]][[yname2]], lty = dlty[2], col = col2)
      title(main = paste("Tooth ", tand[k], ", ", gender[gg], sep = ""), cex = cex.main)
#      legend(7, ylim[[k]][2], legend = c("dmf > 0", "dmf = 0"), lty = hlty, col = c(col1, col2), lwd = c(lwd, lwd), bty = "n",
#             y.intersp = 1.7)  
    }      
}
#dev.off()
